/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lame.mp3;

import net.sourceforge.lame.mp3.BitStream;
import net.sourceforge.lame.mp3.GrInfo;
import net.sourceforge.lame.mp3.IIISideInfo;
import net.sourceforge.lame.mp3.LameGlobalFlags;
import net.sourceforge.lame.mp3.LameInternalFlags;
import net.sourceforge.lame.mp3.MeanBits;

public class Reservoir {
    BitStream bs;

    public final void setModules(BitStream bs) {
        this.bs = bs;
    }

    public final int ResvFrameBegin(LameGlobalFlags gfp, MeanBits mean_bits) {
        int fullFrameBits;
        int maxmp3buf;
        LameInternalFlags gfc = gfp.internal_flags;
        IIISideInfo l3_side = gfc.l3_side;
        int frameLength = this.bs.getframebits(gfp);
        mean_bits.bits = (frameLength - gfc.sideinfo_len * 8) / gfc.mode_gr;
        int resvLimit = 2048 * gfc.mode_gr - 8;
        if (gfp.getBitRate() > 320) {
            maxmp3buf = 8 * (int)((double)((float)(gfp.getBitRate() * 1000) / ((float)gfp.getOutSampleRate() / 1152.0f) / 8.0f) + 0.5);
        } else {
            maxmp3buf = 11520;
            if (gfp.strict_ISO) {
                maxmp3buf = 8 * (int)((double)(320000.0f / ((float)gfp.getOutSampleRate() / 1152.0f) / 8.0f) + 0.5);
            }
        }
        gfc.ResvMax = maxmp3buf - frameLength;
        if (gfc.ResvMax > resvLimit) {
            gfc.ResvMax = resvLimit;
        }
        if (gfc.ResvMax < 0 || gfp.disable_reservoir) {
            gfc.ResvMax = 0;
        }
        if ((fullFrameBits = mean_bits.bits * gfc.mode_gr + Math.min(gfc.ResvSize, gfc.ResvMax)) > maxmp3buf) {
            fullFrameBits = maxmp3buf;
        }
        assert (0 == gfc.ResvMax % 8);
        assert (gfc.ResvMax >= 0);
        l3_side.resvDrain_pre = 0;
        if (gfc.pinfo != null) {
            gfc.pinfo.mean_bits = mean_bits.bits / 2;
            gfc.pinfo.resvsize = gfc.ResvSize;
        }
        return fullFrameBits;
    }

    public final int ResvMaxBits(LameGlobalFlags gfp, int mean_bits, MeanBits targ_bits, int cbr) {
        int extra_bits;
        int add_bits;
        LameInternalFlags gfc = gfp.internal_flags;
        int ResvSize = gfc.ResvSize;
        int ResvMax = gfc.ResvMax;
        if (cbr != 0) {
            ResvSize += mean_bits;
        }
        if ((gfc.substep_shaping & 1) != 0) {
            ResvMax = (int)((double)ResvMax * 0.9);
        }
        targ_bits.bits = mean_bits;
        if (ResvSize * 10 > ResvMax * 9) {
            add_bits = ResvSize - ResvMax * 9 / 10;
            targ_bits.bits += add_bits;
            gfc.substep_shaping |= 0x80;
        } else {
            add_bits = 0;
            gfc.substep_shaping &= 0x7F;
            if (!gfp.disable_reservoir && 0 == (gfc.substep_shaping & 1)) {
                targ_bits.bits = (int)((double)targ_bits.bits - 0.1 * (double)mean_bits);
            }
        }
        int n = extra_bits = ResvSize < gfc.ResvMax * 6 / 10 ? ResvSize : gfc.ResvMax * 6 / 10;
        if ((extra_bits -= add_bits) < 0) {
            extra_bits = 0;
        }
        return extra_bits;
    }

    public final void ResvAdjust(LameInternalFlags gfc, GrInfo gi) {
        gfc.ResvSize -= gi.part2_3_length + gi.part2_length;
    }

    public final void ResvFrameEnd(LameInternalFlags gfc, int mean_bits) {
        IIISideInfo l3_side = gfc.l3_side;
        gfc.ResvSize += mean_bits * gfc.mode_gr;
        int stuffingBits = 0;
        l3_side.resvDrain_post = 0;
        l3_side.resvDrain_pre = 0;
        int over_bits = gfc.ResvSize % 8;
        if (over_bits != 0) {
            stuffingBits += over_bits;
        }
        if ((over_bits = gfc.ResvSize - stuffingBits - gfc.ResvMax) > 0) {
            assert (0 == over_bits % 8);
            assert (over_bits >= 0);
            stuffingBits += over_bits;
        }
        int mdb_bytes = Math.min(l3_side.main_data_begin * 8, stuffingBits) / 8;
        l3_side.resvDrain_pre += 8 * mdb_bytes;
        gfc.ResvSize -= 8 * mdb_bytes;
        l3_side.main_data_begin -= mdb_bytes;
        l3_side.resvDrain_post += (stuffingBits -= 8 * mdb_bytes);
        gfc.ResvSize -= stuffingBits;
    }
}

