/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.cli.UnrecognizedOptionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousOptionException
extends UnrecognizedOptionException {
    private static final long serialVersionUID = 5829816121277947229L;
    private final Collection<String> matchingOptions;

    public AmbiguousOptionException(String option, Collection<String> matchingOptions) {
        super(AmbiguousOptionException.createMessage(option, matchingOptions), option);
        this.matchingOptions = matchingOptions;
    }

    public Collection<String> getMatchingOptions() {
        return this.matchingOptions;
    }

    private static String createMessage(String option, Collection<String> matchingOptions) {
        StringBuilder buf2 = new StringBuilder("Ambiguous option: '");
        buf2.append(option);
        buf2.append("'  (could be: ");
        Iterator<String> it = matchingOptions.iterator();
        while (it.hasNext()) {
            buf2.append("'");
            buf2.append(it.next());
            buf2.append("'");
            if (!it.hasNext()) continue;
            buf2.append(", ");
        }
        buf2.append(")");
        return buf2.toString();
    }
}

