/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.openstatic.aprs.parser.APRSTypes;
import org.openstatic.aprs.parser.Digipeater;
import org.openstatic.aprs.parser.InformationField;

public class APRSPacket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String originalString;
    private String sourceCall;
    private String destinationCall;
    private ArrayList<Digipeater> digipeaters;
    private char dti;
    private InformationField aprsInformation;
    protected boolean hasFault;
    private APRSTypes type;
    static final String REGEX_PATH_ALIASES = "^(WIDE|TRACE|RELAY)\\d*$";

    public APRSPacket(String source, String destination, ArrayList<Digipeater> digipeaters, InformationField info) {
        this.sourceCall = source.toUpperCase();
        this.destinationCall = destination.toUpperCase();
        if (digipeaters == null) {
            Digipeater aprsIs = new Digipeater("TCPIP*");
            this.digipeaters = new ArrayList();
            this.digipeaters.add(aprsIs);
        } else {
            this.digipeaters = digipeaters;
        }
        this.aprsInformation = info;
        this.dti = info != null ? this.aprsInformation.getDateTypeIdentifier() : (char)32;
    }

    public static final String getBaseCall(String callsign) {
        int sepIdx = callsign.indexOf(45);
        if (sepIdx > -1) {
            return callsign.substring(0, sepIdx);
        }
        return callsign;
    }

    public static final String getSsid(String callsign) {
        int sepIdx = callsign.indexOf(45);
        if (sepIdx > -1) {
            return callsign.substring(sepIdx + 1);
        }
        return "0";
    }

    public String getIgate() {
        for (int i = 0; i < this.digipeaters.size(); ++i) {
            Digipeater d = this.digipeaters.get(i);
            if (d.getCallsign().equalsIgnoreCase("qar") && i < this.digipeaters.size() - 1) {
                return this.digipeaters.get(i + 1).toString();
            }
            if (d.getCallsign().equalsIgnoreCase("qas") && i < this.digipeaters.size() - 1) {
                return this.digipeaters.get(i + 1).toString();
            }
            if (d.getCallsign().equalsIgnoreCase("qac") && i < this.digipeaters.size() - 1) {
                return this.digipeaters.get(i + 1).toString();
            }
            if (!d.getCallsign().equalsIgnoreCase("qao") || i >= this.digipeaters.size() - 1) continue;
            return this.digipeaters.get(i + 1).toString();
        }
        return "";
    }

    public String getSourceCall() {
        return this.sourceCall;
    }

    public String getDestinationCall() {
        return this.destinationCall;
    }

    public ArrayList<Digipeater> getDigipeaters() {
        return this.digipeaters;
    }

    public void setDigipeaters(ArrayList<Digipeater> newDigis) {
        this.digipeaters = newDigis;
    }

    public String getLastUsedDigi() {
        for (int i = this.digipeaters.size() - 1; i >= 0; --i) {
            Digipeater d = this.digipeaters.get(i);
            String call = d.getCallsign();
            if (!d.isUsed() || call.matches(REGEX_PATH_ALIASES)) continue;
            return call;
        }
        return null;
    }

    public String getDigiString() {
        StringBuilder sb = new StringBuilder();
        for (Digipeater digi : this.digipeaters) {
            sb.append("," + digi.toString());
        }
        return sb.toString();
    }

    public char getDti() {
        return this.dti;
    }

    public InformationField getAprsInformation() {
        return this.aprsInformation;
    }

    public boolean isAprs() {
        return true;
    }

    public boolean hasFault() {
        return this.hasFault;
    }

    public void setHasFault(boolean hasFault) {
        this.hasFault = hasFault;
    }

    public APRSTypes getType() {
        return this.type;
    }

    public void setType(APRSTypes type) {
        this.type = type;
    }

    public final String getOriginalString() {
        return this.originalString;
    }

    public final void setOriginalString(String originalString) {
        this.originalString = originalString;
    }

    public String toString() {
        return this.sourceCall + ">" + this.destinationCall + this.getDigiString() + ":" + this.aprsInformation.toString();
    }

    public byte[] toAX25Frame() throws IllegalArgumentException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] dest = new Digipeater(this.destinationCall + "*").toAX25();
        baos.write(dest, 0, dest.length);
        byte[] src = new Digipeater(this.sourceCall).toAX25();
        if (this.digipeaters.size() == 0) {
            src[6] = (byte)(src[6] | 1);
        }
        baos.write(src, 0, src.length);
        for (int i = 0; i < this.digipeaters.size(); ++i) {
            byte[] d = this.digipeaters.get(i).toAX25();
            if (i == this.digipeaters.size() - 1) {
                d[6] = (byte)(d[6] | 1);
            }
            baos.write(d, 0, 7);
        }
        baos.write(3);
        baos.write(240);
        byte[] content = this.aprsInformation.getRawBytes();
        baos.write(content, 0, content.length);
        return baos.toByteArray();
    }
}

