/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Optional;
import org.json.JSONObject;
import org.openstatic.kiss.JavaKISSMain;

public class Callsign
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String callsign;
    protected String ssid;
    private JSONObject hamDbRecord;

    public Callsign(String call) {
        String[] callssid = call.split("-");
        this.callsign = callssid[0].toUpperCase();
        this.ssid = callssid.length > 1 ? callssid[1] : "";
    }

    public Callsign(byte[] data, int offset) {
        byte[] shifted = new byte[6];
        byte ssidbyte = data[offset + 6];
        for (int i = 0; i < 6; ++i) {
            shifted[i] = (byte)((data[offset + i] & 0xFF) >> 1);
        }
        this.callsign = new String(shifted, 0, 6).trim();
        int ssidval = (ssidbyte & 0x1E) >> 1;
        this.ssid = ssidval != 0 ? "" + ssidval : "";
    }

    public String getCallsign() {
        return this.callsign;
    }

    public void setCallsign(String callsign) {
        this.callsign = callsign.toUpperCase();
    }

    public String getSsid() {
        return this.ssid;
    }

    public void setSsid(String ssid) {
        this.ssid = ssid;
    }

    public String toString() {
        return this.callsign + (String)(this.ssid == "" ? "" : "-" + this.ssid);
    }

    public byte[] toAX25() throws IllegalArgumentException {
        byte[] callbytes = this.callsign.getBytes();
        byte[] ax25 = new byte[7];
        Arrays.fill(ax25, (byte)64);
        if (callbytes.length > 6) {
            throw new IllegalArgumentException("Callsign " + this.callsign + " is too long for AX.25!");
        }
        for (int i = 0; i < callbytes.length; ++i) {
            ax25[i] = (byte)(callbytes[i] << 1);
        }
        int ssidval = 0;
        try {
            ssidval = Integer.parseInt(this.ssid);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ax25[6] = (byte)(0x60 | ssidval * 2 & 0x1E);
        return ax25;
    }

    private void loadHamDBRecord() {
        try {
            File callsignFile;
            File callsignFolder = new File(JavaKISSMain.logsFolder, "callsign");
            if (!callsignFolder.exists()) {
                callsignFolder.mkdir();
            }
            if ((callsignFile = new File(callsignFolder, this.callsign + ".json")).exists()) {
                this.hamDbRecord = JavaKISSMain.loadJSONObject(callsignFile);
            } else {
                String url = "https://api.hamdb.org/v1/" + URLEncoder.encode(this.callsign, "UTF-8") + "/json/jaxt";
                HttpURLConnection con = (HttpURLConnection)new URL(url).openConnection();
                con.setRequestMethod("GET");
                con.setDoOutput(false);
                con.setReadTimeout(10000);
                con.setConnectTimeout(10000);
                InputStream inputStream = con.getInputStream();
                int responseCode = con.getResponseCode();
                InputStreamReader isr = new InputStreamReader(inputStream);
                Optional<String> optResponse = new BufferedReader(isr).lines().reduce((a, b) -> a + b);
                String output = "NO OUTPUT";
                if (optResponse.isPresent()) {
                    JSONObject hamdbObject;
                    output = optResponse.get();
                    JSONObject response = new JSONObject(output);
                    if (response.has("hamdb") && (hamdbObject = response.getJSONObject("hamdb")).has("callsign")) {
                        this.hamDbRecord = hamdbObject.getJSONObject("callsign");
                        if (this.hamDbRecord.optString("name", "NOT_FOUND").equals("NOT_FOUND")) {
                            this.hamDbRecord = new JSONObject();
                            this.hamDbRecord.put("error", "Not Found");
                        } else {
                            JavaKISSMain.saveJSONObject(callsignFile, this.hamDbRecord);
                        }
                    }
                } else {
                    this.hamDbRecord = new JSONObject();
                    this.hamDbRecord.put("error", "No Response");
                }
            }
        }
        catch (Exception e) {
            this.hamDbRecord = new JSONObject();
            this.hamDbRecord.put("error", e.getMessage());
        }
    }

    public JSONObject getHamDBRecord() {
        if (this.hamDbRecord == null) {
            this.loadHamDBRecord();
        }
        return this.hamDbRecord;
    }

    public String getFullName() {
        return (this.getHamDBRecord().optString("fname", "") + " " + this.getHamDBRecord().optString("name", "")).trim();
    }

    public String getAddress() {
        return this.getHamDBRecord().optString("addr1", "") + "\n" + this.getHamDBRecord().optString("addr2", "") + " " + this.getHamDBRecord().optString("state", "") + " " + this.getHamDBRecord().optString("zip", "") + "\n" + this.getHamDBRecord().optString("country", "");
    }

    public String getLicenseClass() {
        String cl = this.getHamDBRecord().optString("class", "");
        if (cl.equals("T")) {
            return "Technician";
        }
        if (cl.equals("E")) {
            return "Extra";
        }
        if (cl.equals("G")) {
            return "General";
        }
        return cl;
    }
}

