/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.Serializable;
import java.util.ArrayList;
import org.openstatic.aprs.parser.Callsign;

public class Digipeater
extends Callsign
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean used;

    public Digipeater(String call) {
        super(call.replaceAll("\\*", ""));
        if (call.indexOf("*") >= 0) {
            this.setUsed(true);
        }
    }

    public Digipeater(byte[] data, int offset) {
        super(data, offset);
        this.used = (data[offset + 6] & 0x80) == 128;
    }

    public static ArrayList<Digipeater> parseList(String digiList, boolean includeFirst) {
        String[] digiTemp = digiList.split(",");
        ArrayList<Digipeater> digis = new ArrayList<Digipeater>();
        boolean includeNext = includeFirst;
        for (String digi : digiTemp) {
            String digiTrim = digi.trim();
            if (digiTrim.length() > 0 && includeNext) {
                digis.add(new Digipeater(digiTrim));
            }
            includeNext = true;
        }
        return digis;
    }

    public boolean isUsed() {
        return this.used;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    @Override
    public String toString() {
        return super.toString() + (this.isUsed() ? "*" : "");
    }

    @Override
    public byte[] toAX25() throws IllegalArgumentException {
        byte[] ax25 = super.toAX25();
        ax25[6] = (byte)(ax25[6] | (this.isUsed() ? 128 : 0));
        return ax25;
    }
}

