/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.Serializable;
import org.openstatic.aprs.parser.APRSTypes;
import org.openstatic.aprs.parser.DataExtension;

public abstract class InformationField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private char dataTypeIdentifier;
    protected byte[] rawBytes;
    protected APRSTypes type;
    protected boolean hasFault = false;
    protected boolean canMessage = false;
    DataExtension extension = null;
    protected String comment = "";

    public InformationField() {
    }

    public InformationField(byte[] rawBytes) {
        if (rawBytes.length < 1) {
            System.err.println("Parse error:  zero length information field");
        }
        this.rawBytes = rawBytes;
        this.dataTypeIdentifier = (char)rawBytes[0];
        switch (this.dataTypeIdentifier) {
            case '\'': 
            case ':': 
            case '=': 
            case '@': {
                this.canMessage = true;
            }
        }
    }

    public char getDateTypeIdentifier() {
        return this.dataTypeIdentifier;
    }

    public void setDataTypeIdentifier(char dti) {
        this.dataTypeIdentifier = dti;
    }

    public byte[] getRawBytes() {
        if (this.rawBytes != null) {
            return this.rawBytes;
        }
        return this.toString().getBytes();
    }

    public byte[] getBytes(int start, int end) {
        byte[] returnArray = new byte[end - start];
        System.arraycopy(this.getRawBytes(), start, returnArray, 0, end - start);
        return returnArray;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return new String(this.rawBytes);
    }

    public boolean isHasFault() {
        return this.hasFault;
    }

    public final DataExtension getExtension() {
        return this.extension;
    }
}

