/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.Serializable;
import org.openstatic.aprs.parser.ObjectPacket;
import org.openstatic.aprs.parser.Position;
import org.openstatic.aprs.parser.PositionParser;

public class ItemPacket
extends ObjectPacket
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean live = true;

    public ItemPacket(byte[] msgBody) throws Exception {
        this.rawBytes = msgBody;
        this.setDataTypeIdentifier((char)this.rawBytes[0]);
        String body = new String(msgBody);
        int name_length = body.indexOf("!") - 1;
        if (name_length < 1 || name_length > 9) {
            name_length = body.indexOf("_");
            if (name_length < 1 || name_length > 9) {
                throw new Exception("Invalid ITEM packet, missing '!' or '_'.");
            }
            this.live = false;
        } else {
            this.live = true;
        }
        this.objectName = new String(msgBody, 1, name_length).trim();
        int cursor = name_length + 2;
        if (msgBody[cursor] > 48 && msgBody[cursor] < 57) {
            this.position = PositionParser.parseUncompressed(msgBody, cursor);
            cursor += 19;
        } else {
            this.position = PositionParser.parseCompressed(msgBody, cursor);
            cursor += 12;
        }
        this.comment = new String(msgBody, cursor, msgBody.length - cursor, "UTF-8").trim();
    }

    public ItemPacket(String objectName, boolean live, Position position, String comment) {
        super(objectName, live, position, comment);
    }

    @Override
    public String toString() {
        if (this.rawBytes != null) {
            return new String(this.rawBytes);
        }
        return ")" + this.objectName + (this.live ? "!" : "_") + this.position.toString() + this.comment;
    }
}

