/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.Serializable;
import org.openstatic.aprs.parser.APRSTypes;
import org.openstatic.aprs.parser.InformationField;

public class MessagePacket
extends InformationField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String messageBody;
    private String messageNumber;
    private String targetCallsign = "";
    private boolean isAck = false;
    private boolean isRej = false;

    public MessagePacket(byte[] bodyBytes, String destCall) {
        super(bodyBytes);
        String message = new String(bodyBytes);
        if (message.length() < 2) {
            this.hasFault = true;
            return;
        }
        int msgSpc = message.indexOf(58, 2);
        this.targetCallsign = msgSpc < 1 ? "UNKNOWN" : message.substring(1, msgSpc).trim().toUpperCase();
        int msgNumberIdx = message.lastIndexOf(123);
        this.messageNumber = "";
        if (msgNumberIdx > -1) {
            this.messageNumber = message.substring(msgNumberIdx + 1);
            this.messageBody = message.substring(11, msgNumberIdx);
        } else {
            this.messageBody = message.substring(11);
        }
        String lcMsg = this.messageBody.toLowerCase();
        if (lcMsg.startsWith("ack")) {
            this.isAck = true;
            this.messageNumber = this.messageBody.substring(3, this.messageBody.length());
            this.messageBody = this.messageBody.substring(0, 3);
        }
        if (lcMsg.startsWith("rej")) {
            this.isRej = true;
            this.messageNumber = this.messageBody.substring(3, this.messageBody.length());
            this.messageBody = this.messageBody.substring(0, 3);
        }
    }

    public MessagePacket(String targetCallsign, String messageBody, String messageNumber) {
        this.messageBody = messageBody;
        this.targetCallsign = targetCallsign;
        this.messageNumber = messageNumber;
        if (messageBody.equals("ack")) {
            this.isAck = true;
        }
        if (messageBody.equals("rej")) {
            this.isRej = true;
        }
        super.setDataTypeIdentifier(':');
        this.type = APRSTypes.T_MESSAGE;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public void setMessageBody(String messageBody) {
        this.messageBody = messageBody;
    }

    public String getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(String messageNumber) {
        this.messageNumber = messageNumber;
    }

    public String getTargetCallsign() {
        return this.targetCallsign;
    }

    public void setTargetCallsign(String targetCallsign) {
        this.targetCallsign = targetCallsign;
    }

    public boolean isAck() {
        return this.isAck;
    }

    public void setAck(boolean isAck) {
        this.isAck = isAck;
    }

    public boolean isRej() {
        return this.isRej;
    }

    public void setRej(boolean isRej) {
        this.isRej = isRej;
    }

    @Override
    public String toString() {
        if (this.rawBytes != null) {
            return new String(this.rawBytes);
        }
        if (this.messageBody.equals("ack") || this.messageBody.equals("rej")) {
            return String.format(":%-9s:%s%s", this.targetCallsign, this.messageBody, this.messageNumber);
        }
        if (this.messageNumber.length() > 0) {
            return String.format(":%-9s:%s{%s", this.targetCallsign, this.messageBody, this.messageNumber);
        }
        return String.format(":%-9s:%s", this.targetCallsign, this.messageBody);
    }
}

