/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.Serializable;
import org.openstatic.aprs.parser.DataExtension;
import org.openstatic.aprs.parser.InformationField;
import org.openstatic.aprs.parser.Position;
import org.openstatic.aprs.parser.PositionParser;

public class ObjectPacket
extends InformationField
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String objectName;
    protected boolean live = true;
    protected Position position;

    protected ObjectPacket() {
    }

    public ObjectPacket(byte[] msgBody) throws Exception {
        super(msgBody);
        this.objectName = new String(msgBody, 1, 9).trim();
        this.live = msgBody[10] == 42;
        int cursor = 18;
        if (msgBody[cursor] > 48 && msgBody[cursor] < 57) {
            this.position = PositionParser.parseUncompressed(msgBody, cursor);
            cursor += 19;
        } else {
            this.position = PositionParser.parseCompressed(msgBody, cursor);
            cursor += 12;
        }
        this.comment = new String(msgBody, cursor, msgBody.length - cursor, "UTF-8").trim();
    }

    public ObjectPacket(String objectName, boolean live, Position position, String comment) {
        this.objectName = objectName;
        this.live = live;
        this.position = position;
        this.comment = comment;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public boolean isLive() {
        return this.live;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    public void setExtension(DataExtension extension) {
        this.extension = extension;
    }

    @Override
    public String toString() {
        if (this.rawBytes != null) {
            return new String(this.rawBytes);
        }
        return String.format(";%-9s%c%s%s", this.objectName, Character.valueOf(this.live ? (char)'*' : '_'), this.position.toString(), this.comment);
    }
}

