/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.util.ArrayList;
import org.openstatic.aprs.parser.APRSPacket;
import org.openstatic.aprs.parser.APRSTypes;
import org.openstatic.aprs.parser.Callsign;
import org.openstatic.aprs.parser.Digipeater;
import org.openstatic.aprs.parser.InformationField;
import org.openstatic.aprs.parser.ItemPacket;
import org.openstatic.aprs.parser.MessagePacket;
import org.openstatic.aprs.parser.ObjectPacket;
import org.openstatic.aprs.parser.PositionPacket;
import org.openstatic.aprs.parser.UnsupportedInfoField;

public class Parser {
    public static APRSPacket parse(String packet) throws Exception {
        int cs = packet.indexOf(62);
        String source = packet.substring(0, cs).toUpperCase();
        int ms = packet.indexOf(58);
        String digiList = packet.substring(cs + 1, ms);
        String[] digiTemp = digiList.split(",");
        String dest = digiTemp[0].toUpperCase();
        ArrayList<Digipeater> digis = Digipeater.parseList(digiList, false);
        String body = packet.substring(ms + 1);
        APRSPacket ap = Parser.parseBody(source, dest, digis, body);
        ap.setOriginalString(packet);
        return ap;
    }

    public static APRSPacket parseAX25(byte[] packet) throws Exception {
        int pos = 0;
        String dest = new Callsign(packet, pos).toString();
        String source = new Callsign(packet, pos += 7).toString();
        pos += 7;
        ArrayList<Digipeater> digis = new ArrayList<Digipeater>();
        while ((packet[pos - 1] & 1) == 0) {
            Digipeater d = new Digipeater(packet, pos);
            digis.add(d);
            pos += 7;
        }
        if (packet[pos] != 3 || packet[pos + 1] != -16) {
            throw new IllegalArgumentException("control + pid must be 0x03 0xF0!");
        }
        String body = new String(packet, pos += 2, packet.length - pos);
        return Parser.parseBody(source, dest, digis, body);
    }

    public static APRSPacket parseBody(String source, String dest, ArrayList<Digipeater> digis, String body) throws Exception {
        byte[] bodyBytes = body.getBytes();
        byte dti = bodyBytes[0];
        InformationField infoField = null;
        APRSTypes type = APRSTypes.T_UNSPECIFIED;
        boolean hasFault = false;
        switch (dti) {
            case 33: 
            case 36: 
            case 39: 
            case 47: 
            case 61: 
            case 64: 
            case 96: {
                if (body.startsWith("$ULTW")) break;
                type = APRSTypes.T_POSITION;
                infoField = new PositionPacket(bodyBytes, dest);
                break;
            }
            case 58: {
                infoField = new MessagePacket(bodyBytes, dest);
                break;
            }
            case 59: {
                if (bodyBytes.length > 29) {
                    type = APRSTypes.T_OBJECT;
                    infoField = new ObjectPacket(bodyBytes);
                    break;
                }
                System.err.println("Object packet body too short for valid object");
                hasFault = true;
                break;
            }
            case 62: {
                type = APRSTypes.T_STATUS;
                break;
            }
            case 60: {
                type = APRSTypes.T_STATCAPA;
                break;
            }
            case 63: {
                type = APRSTypes.T_QUERY;
                break;
            }
            case 41: {
                type = APRSTypes.T_ITEM;
                if (bodyBytes.length > 18) {
                    infoField = new ItemPacket(bodyBytes);
                    break;
                }
                hasFault = true;
                break;
            }
            case 84: {
                if (bodyBytes.length > 18) break;
                hasFault = true;
                break;
            }
            case 35: 
            case 42: 
            case 95: {
                type = APRSTypes.T_WX;
                break;
            }
            case 123: {
                type = APRSTypes.T_USERDEF;
                break;
            }
            case 125: {
                type = APRSTypes.T_THIRDPARTY;
                break;
            }
            default: {
                hasFault = true;
            }
        }
        if (infoField == null) {
            infoField = new UnsupportedInfoField(bodyBytes);
        }
        APRSPacket returnPacket = new APRSPacket(source, dest, digis, infoField);
        returnPacket.setType(type);
        returnPacket.setHasFault(hasFault);
        return returnPacket;
    }
}

