/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.Serializable;
import java.util.Date;
import java.util.Locale;

public class Position
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Double latitude = 0.0;
    private Double longitude = 0.0;
    private Integer altitude = -1;
    private Integer positionAmbiguity;
    private Date timestamp;
    private char symbolTable;
    private char symbolCode;
    private String csTField = " sT";

    public Position() {
        this.timestamp = new Date();
    }

    public Position(double lat, double lon, int posAmb, char st, char sc) {
        this.latitude = (double)Math.round(lat * 100000.0) * 1.0E-5;
        this.longitude = (double)Math.round(lon * 100000.0) * 1.0E-5;
        this.positionAmbiguity = posAmb;
        this.symbolTable = st;
        this.symbolCode = sc;
        this.timestamp = new Date();
    }

    public Position(double lat, double lon) {
        this.latitude = (double)Math.round(lat * 100000.0) * 1.0E-5;
        this.longitude = (double)Math.round(lon * 100000.0) * 1.0E-5;
        this.positionAmbiguity = 0;
        this.symbolTable = (char)92;
        this.symbolCode = (char)46;
        this.timestamp = new Date();
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public int getAltitude() {
        return this.altitude;
    }

    public void setAltitude(int altitude) {
        this.altitude = altitude;
    }

    public int getPositionAmbiguity() {
        return this.positionAmbiguity;
    }

    public void setPositionAmbiguity(int positionAmbiguity) {
        this.positionAmbiguity = positionAmbiguity;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public char getSymbolTable() {
        return this.symbolTable;
    }

    public void setSymbolTable(char symbolTable) {
        this.symbolTable = symbolTable;
    }

    public char getSymbolCode() {
        return this.symbolCode;
    }

    public void setSymbolCode(char symbolCode) {
        this.symbolCode = symbolCode;
    }

    public String getDMS(double decimalDegree, boolean isLatitude) {
        String ambiguousFrac;
        boolean negative;
        int minFrac = (int)Math.round(decimalDegree * 6000.0);
        boolean bl = negative = minFrac < 0;
        if (negative) {
            minFrac = -minFrac;
        }
        int deg = minFrac / 6000;
        int min = minFrac / 100 % 60;
        minFrac %= 100;
        switch (this.positionAmbiguity) {
            case 1: {
                ambiguousFrac = "  .  ";
                break;
            }
            case 2: {
                ambiguousFrac = String.format((Locale)null, "%d .  ", min / 10);
                break;
            }
            case 3: {
                ambiguousFrac = String.format((Locale)null, "%02d.  ", min);
                break;
            }
            case 4: {
                ambiguousFrac = String.format((Locale)null, "%02d.%d ", min, minFrac / 10);
                break;
            }
            default: {
                ambiguousFrac = String.format((Locale)null, "%02d.%02d", min, minFrac);
            }
        }
        if (isLatitude) {
            return String.format((Locale)null, "%02d%s%s", deg, ambiguousFrac, negative ? "S" : "N");
        }
        return String.format((Locale)null, "%03d%s%s", deg, ambiguousFrac, negative ? "W" : "E");
    }

    public String toString() {
        return this.getDMS(this.latitude, true) + this.symbolTable + this.getDMS(this.longitude, false) + this.symbolCode;
    }

    public String toDecimalString() {
        return this.latitude + ", " + this.longitude;
    }

    public void setCsTField(String val) {
        if (val == null || val == "") {
            val = " sT";
        }
        this.csTField = val;
    }

    public String getCsTField() {
        return this.csTField;
    }

    public String toCompressedString() {
        long latbase = Math.round(380926.0 * (90.0 - this.latitude));
        long latchar1 = latbase / 753571L + 33L;
        long latchar2 = (latbase %= 753571L) / 8281L + 33L;
        int latchar3 = (int)((latbase %= 8281L) / 91L) + 33;
        int latchar4 = (int)(latbase % 91L) + 33;
        long lonbase = Math.round(190463.0 * (180.0 + this.longitude));
        long lonchar1 = lonbase / 753571L + 33L;
        long lonchar2 = (lonbase %= 753571L) / 8281L + 33L;
        int lonchar3 = (int)((lonbase %= 8281L) / 91L) + 33;
        int lonchar4 = (int)(lonbase % 91L) + 33;
        return "" + this.symbolTable + (char)latchar1 + (char)latchar2 + (char)latchar3 + (char)latchar4 + (char)lonchar1 + (char)lonchar2 + (char)lonchar3 + (char)lonchar4 + this.symbolCode + this.csTField;
    }

    public static float distFrom(double lat1, double lng1, double lat2, double lng2) {
        double earthRadius = 3958.75;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLng = Math.toRadians(lng2 - lng1);
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = earthRadius * c;
        return new Float(dist).floatValue();
    }

    public float distance(Position position2) {
        double lat1 = this.getLatitude();
        double lat2 = position2.getLatitude();
        double lng1 = this.getLongitude();
        double lng2 = position2.getLongitude();
        return Position.distFrom(lat1, lng1, lat2, lng2);
    }

    public float direction(Position position2) {
        double Lat1 = Math.toRadians(position2.getLatitude());
        double Lon1 = position2.getLongitude();
        double Lat2 = Math.toRadians(this.getLatitude());
        double Lon2 = this.getLongitude();
        double dLon = Math.toRadians(Lon2 - Lon1);
        double y = Math.sin(dLon) * Math.cos(Lat2);
        double x = Math.cos(Lat1) * Math.sin(Lat2) - Math.sin(Lat1) * Math.cos(Lat2) * Math.cos(dLon);
        return (float)((Math.toDegrees(Math.atan2(y, x)) + 360.0) % 360.0);
    }
}

