/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.io.Serializable;
import org.openstatic.aprs.parser.APRSTypes;
import org.openstatic.aprs.parser.InformationField;
import org.openstatic.aprs.parser.Position;
import org.openstatic.aprs.parser.PositionParser;

public class PositionPacket
extends InformationField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Position position;
    private String positionSource;
    private boolean compressedFormat;

    public PositionPacket(byte[] msgBody, String destinationField) throws Exception {
        super(msgBody);
        this.positionSource = "Unknown";
        char packetType = (char)msgBody[0];
        int cursor = 0;
        switch (packetType) {
            case '\'': 
            case '`': {
                this.type = APRSTypes.T_POSITION;
                this.position = PositionParser.parseMICe(msgBody, destinationField);
                this.extension = PositionParser.parseMICeExtension(msgBody, destinationField);
                this.positionSource = "MICe";
                cursor = 10;
                if (cursor < msgBody.length && (msgBody[cursor] == 62 || msgBody[cursor] == 93 || msgBody[cursor] == 96)) {
                    ++cursor;
                }
                if (cursor >= msgBody.length || msgBody[cursor] != 34) break;
                cursor += 4;
                break;
            }
            case '!': {
                if (msgBody[1] == 85 && msgBody[2] == 76 && msgBody[3] == 84) {
                    this.type = APRSTypes.T_WX;
                    break;
                }
            }
            case '/': 
            case '=': 
            case '@': {
                if (msgBody.length >= 10) {
                    char posChar;
                    this.type = APRSTypes.T_POSITION;
                    cursor = 1;
                    if (packetType == '/' || packetType == '@') {
                        cursor += 7;
                    }
                    if (this.validSymTableCompressed(posChar = (char)msgBody[cursor])) {
                        this.position = PositionParser.parseCompressed(msgBody, cursor);
                        this.extension = PositionParser.parseCompressedExtension(msgBody, cursor);
                        this.positionSource = "Compressed";
                        cursor += 13;
                        break;
                    }
                    if ('0' <= posChar && posChar <= '9') {
                        this.position = PositionParser.parseUncompressed(msgBody);
                        try {
                            this.extension = PositionParser.parseUncompressedExtension(msgBody, cursor);
                        }
                        catch (ArrayIndexOutOfBoundsException oobex) {
                            this.extension = null;
                        }
                        this.positionSource = "Uncompressed";
                        cursor += 19;
                        break;
                    }
                    this.hasFault = true;
                    break;
                }
                this.hasFault = true;
            }
            case '$': {
                if (msgBody.length > 10) {
                    this.type = APRSTypes.T_POSITION;
                    this.position = PositionParser.parseNMEA(msgBody);
                    this.positionSource = "NMEA";
                    break;
                }
                this.hasFault = true;
            }
        }
        if (cursor > 0 && cursor < msgBody.length) {
            this.comment = new String(msgBody, cursor, msgBody.length - cursor, "UTF-8");
        }
        this.compressedFormat = false;
    }

    public PositionPacket(Position position, String comment) {
        this.position = position;
        this.type = APRSTypes.T_POSITION;
        this.comment = comment;
        this.compressedFormat = false;
    }

    public PositionPacket(Position position, String comment, boolean msgCapable) {
        this(position, comment);
        this.canMessage = msgCapable;
    }

    public void setCompressedFormat(boolean val) {
        this.compressedFormat = val;
    }

    public boolean getCompressedFormat() {
        return this.compressedFormat;
    }

    private boolean validSymTableCompressed(char c) {
        if (c == '/' || c == '\\') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return 'a' <= c && c <= 'j';
    }

    public Position getPosition() {
        return this.position;
    }

    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public String toString() {
        if (this.rawBytes != null) {
            return new String(this.rawBytes);
        }
        if (this.compressedFormat) {
            return (this.canMessage ? "=" : "!") + this.position.toCompressedString() + this.comment;
        }
        return (this.canMessage ? "=" : "!") + String.valueOf(this.position) + this.comment;
    }

    public String getPositionSource() {
        return this.positionSource;
    }
}

