/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.aprs.parser;

import java.util.Date;
import java.util.regex.Pattern;
import org.openstatic.aprs.parser.CourseAndSpeedExtension;
import org.openstatic.aprs.parser.DataExtension;
import org.openstatic.aprs.parser.PHGExtension;
import org.openstatic.aprs.parser.Position;
import org.openstatic.aprs.parser.RangeExtension;
import org.openstatic.aprs.parser.UnparsablePositionException;

public class PositionParser {
    private static Pattern commaSplit = Pattern.compile(",");

    public static Position parseUncompressed(byte[] msgBody, int cursor) throws Exception {
        Date date = new Date();
        if (msgBody[0] == 47 || msgBody[0] == 64) {
            if (msgBody[cursor + 6] == 122) {
                int day = (msgBody[cursor + 0] - 48) * 10 + msgBody[cursor + 1] - 48;
                int hour = (msgBody[cursor + 2] - 48) * 10 + msgBody[cursor + 3] - 48;
                int minute = (msgBody[cursor + 4] - 48) * 10 + msgBody[cursor + 5] - 48;
                date.setDate(day);
                date.setHours(hour);
                date.setMinutes(minute);
            }
            cursor += 7;
        }
        if (msgBody.length < cursor + 19) {
            throw new UnparsablePositionException("Uncompressed packet too short");
        }
        int positionAmbiguity = 0;
        char[] posbuf = new char[msgBody.length - cursor + 1];
        int pos = 0;
        for (int i = cursor; i < cursor + 19; ++i) {
            posbuf[pos] = (char)msgBody[i];
            ++pos;
        }
        if (posbuf[2] == ' ') {
            posbuf[2] = 51;
            posbuf[3] = 48;
            posbuf[5] = 48;
            posbuf[6] = 48;
            positionAmbiguity = 1;
        }
        if (posbuf[3] == ' ') {
            posbuf[3] = 53;
            posbuf[5] = 48;
            posbuf[6] = 48;
            positionAmbiguity = 2;
        }
        if (posbuf[5] == ' ') {
            posbuf[5] = 53;
            posbuf[6] = 48;
            positionAmbiguity = 3;
        }
        if (posbuf[6] == ' ') {
            posbuf[6] = 53;
            positionAmbiguity = 4;
        }
        if (posbuf[12] == ' ') {
            posbuf[12] = 51;
            posbuf[13] = 48;
            posbuf[15] = 48;
            posbuf[16] = 48;
            positionAmbiguity = 1;
        }
        if (posbuf[13] == ' ') {
            posbuf[13] = 53;
            posbuf[15] = 48;
            posbuf[16] = 48;
            positionAmbiguity = 2;
        }
        if (posbuf[15] == ' ') {
            posbuf[15] = 53;
            posbuf[16] = 48;
            positionAmbiguity = 3;
        }
        if (posbuf[16] == ' ') {
            posbuf[16] = 53;
            positionAmbiguity = 4;
        }
        try {
            double latitude = PositionParser.parseDegMin(posbuf, 0, 2, 7, true);
            char lath = posbuf[7];
            char symbolTable = posbuf[8];
            double longitude = PositionParser.parseDegMin(posbuf, 9, 3, 8, true);
            char lngh = posbuf[17];
            char symbolCode = posbuf[18];
            if (lath == 's' || lath == 'S') {
                latitude = 0.0 - latitude;
            } else if (lath != 'n' && lath != 'N') {
                throw new Exception("Bad latitude sign character");
            }
            if (lngh == 'w' || lngh == 'W') {
                longitude = 0.0 - longitude;
            } else if (lngh != 'e' && lngh != 'E') {
                throw new Exception("Bad longitude sign character");
            }
            Position position = new Position(latitude, longitude, positionAmbiguity, symbolTable, symbolCode);
            position.setTimestamp(date);
            return position;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static Position parseUncompressed(byte[] msgBody) throws Exception {
        return PositionParser.parseUncompressed(msgBody, 1);
    }

    public static DataExtension parseUncompressedExtension(byte[] msgBody, int cursor) throws Exception {
        DataExtension de = null;
        if (msgBody.length <= 18 + cursor) {
            return null;
        }
        if ((char)msgBody[19 + cursor] == 'P' && (char)msgBody[20 + cursor] == 'H' && (char)msgBody[21 + cursor] == 'G') {
            PHGExtension phg = new PHGExtension();
            try {
                phg.setPower(Integer.parseInt(new String(msgBody, 22 + cursor, 1)));
                phg.setHeight(Integer.parseInt(new String(msgBody, 23 + cursor, 1)));
                phg.setGain(Integer.parseInt(new String(msgBody, 24 + cursor, 1)));
                phg.setDirectivity(Integer.parseInt(new String(msgBody, 25 + cursor, 1)));
                de = phg;
            }
            catch (NumberFormatException nfe) {
                de = null;
            }
        } else if ((char)msgBody[22 + cursor] == '/' && (char)msgBody[18 + cursor] != '_') {
            CourseAndSpeedExtension cse = new CourseAndSpeedExtension();
            String courseString = new String(msgBody, cursor + 19, 3);
            String speedString = new String(msgBody, cursor + 23, 3);
            int course = 0;
            int speed = 0;
            try {
                course = Integer.parseInt(courseString);
                speed = Integer.parseInt(speedString);
            }
            catch (NumberFormatException nfe) {
                course = 0;
                speed = 0;
            }
            cse.setCourse(course);
            cse.setSpeed(speed);
            de = cse;
        }
        return de;
    }

    public static Position parseMICe(byte[] msgBody, String destinationCall) throws Exception {
        char c;
        int i;
        String dcall = destinationCall;
        if (destinationCall.indexOf("-") > -1) {
            dcall = destinationCall.substring(0, destinationCall.indexOf("-"));
        }
        if (dcall.length() != 6) {
            throw new UnparsablePositionException("MicE Destination Call incorrect length:  " + dcall);
        }
        char[] destcall = dcall.toCharArray();
        for (i = 0; i < 3; ++i) {
            c = destcall[i + 1];
            if ('0' <= c && c <= '9' || 'A' <= c && c <= 'L' || 'P' <= c && c <= 'Z') continue;
            throw new UnparsablePositionException("Digit " + i + " dorked:  " + c);
        }
        for (i = 3; i < 5; ++i) {
            c = destcall[i + 1];
            if ('0' <= c && c <= '9' || 'L' == c || 'P' <= c && c <= 'Z') continue;
            throw new UnparsablePositionException("Digit " + i + " dorked:  " + c);
        }
        char c2 = (char)msgBody[1];
        if (c2 < '&' || c2 > '\u007f') {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 1");
        }
        c2 = (char)msgBody[2];
        if (c2 < '&' || c2 > 'a') {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 2");
        }
        c2 = (char)msgBody[3];
        if (c2 < '\u001c' || c2 > '\u007f') {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 3");
        }
        c2 = (char)msgBody[4];
        if (c2 < '\u001c' || c2 > '\u007f') {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 4");
        }
        c2 = (char)msgBody[5];
        if (c2 < '\u001c' || c2 > '}') {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 5");
        }
        c2 = (char)msgBody[6];
        if (c2 < '\u001c' || c2 > '\u007f') {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 6");
        }
        c2 = (char)msgBody[7];
        if ((c2 < '!' || c2 > '{') && c2 != '}') {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 7");
        }
        if (!PositionParser.validSymTableUncompressed((char)msgBody[8])) {
            throw new UnparsablePositionException("Raw packet contains " + c2 + " at position 8");
        }
        char[] destcall2 = new char[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            c2 = destcall[i2];
            destcall2[i2] = 'A' <= c2 && c2 <= 'J' ? (int)(c2 - 17) : ('P' <= c2 && c2 <= 'Y' ? (int)(c2 - 32) : ('K' == c2 || 'L' == c2 || 'Z' == c2 ? 95 : c2));
        }
        int posAmbiguity = 0;
        if (destcall2[5] == '_') {
            destcall2[5] = 53;
            posAmbiguity = 4;
        }
        if (destcall2[4] == '_') {
            destcall2[4] = 53;
            posAmbiguity = 3;
        }
        if (destcall2[3] == '_') {
            destcall2[3] = 53;
            posAmbiguity = 2;
        }
        if (destcall2[2] == '_') {
            destcall2[2] = 51;
            posAmbiguity = 1;
        }
        if (destcall2[1] == '_' || destcall2[0] == '_') {
            throw new UnparsablePositionException("bad pos-ambiguity on destcall");
        }
        double lat = 0.0;
        try {
            lat = PositionParser.parseDegMin(destcall2, 0, 2, 9, false);
        }
        catch (Exception e) {
            throw new UnparsablePositionException("Destination Call invalid for MicE:  " + new String(destcall2));
        }
        if (destinationCall.charAt(3) <= 'L') {
            lat = 0.0 - lat;
        }
        int longDeg = (char)msgBody[1] - 28;
        if (destcall[4] >= 'P') {
            longDeg += 100;
        }
        if (longDeg >= 180 && longDeg <= 189) {
            longDeg -= 80;
        } else if (longDeg >= 190 && longDeg <= 199) {
            longDeg -= 190;
        }
        int longMin = (char)msgBody[2] - 28;
        if (longMin >= 60) {
            longMin -= 60;
        }
        int longMinFract = (char)msgBody[3] - 28;
        float lng = 0.0f;
        switch (posAmbiguity) {
            case 0: {
                lng = (float)longDeg + (float)longMin / 60.0f + (float)longMinFract / 6000.0f;
                break;
            }
            case 1: {
                lng = (float)longDeg + (float)longMin / 60.0f + (float)(longMinFract - longMinFract % 10 + 5) / 6000.0f;
                break;
            }
            case 2: {
                lng = (float)longDeg + (float)longMin / 60.0f;
                break;
            }
            case 3: {
                lng = (float)longDeg + (float)(longMin - longMin % 10 + 5) / 60.0f;
                break;
            }
            case 4: {
                lng = (float)longDeg + 0.5f;
                break;
            }
            default: {
                throw new UnparsablePositionException("Unable to extract longitude from MicE");
            }
        }
        if (destcall[5] >= 'P') {
            lng = 0.0f - lng;
        }
        return new Position(lat, lng, posAmbiguity, (char)msgBody[8], (char)msgBody[7]);
    }

    public static CourseAndSpeedExtension parseMICeExtension(byte[] msgBody, String destinationField) throws Exception {
        CourseAndSpeedExtension cse = new CourseAndSpeedExtension();
        int sp = msgBody[4] - 28;
        int dc = msgBody[5] - 28;
        int se = msgBody[6] - 28;
        int speed = sp * 10;
        int q = dc / 10;
        speed += q;
        int r = dc % 10 * 100;
        int course = r + se;
        if (course >= 400) {
            course -= 400;
        }
        if (speed >= 800) {
            speed -= 800;
        }
        cse.setSpeed(speed);
        cse.setCourse(course);
        return cse;
    }

    public static Position parseNMEA(byte[] msgBody) throws Exception {
        String[] nmea = commaSplit.split(new String(msgBody));
        String lats = null;
        String lngs = null;
        String lath = null;
        String lngh = null;
        if (nmea.length < 5) {
            throw new UnparsablePositionException("Too few parts in NMEA sentence");
        }
        if ("$GPGGA".equals(nmea[0]) && nmea.length >= 15) {
            if (!"1".equals(nmea[6])) {
                throw new UnparsablePositionException("Not a valid position fix");
            }
            lats = nmea[2];
            lath = nmea[3];
            lngs = nmea[4];
            lngh = nmea[5];
        } else if ("$GPGLL".equals(nmea[0]) && nmea.length > 7) {
            if (!"A".equals(nmea[6]) || nmea[7].charAt(0) != 'A') {
                throw new UnparsablePositionException("Not valid or not autonomous NMEA sentence");
            }
            lats = nmea[1];
            lath = nmea[2];
            lngs = nmea[3];
            lngh = nmea[4];
        } else if ("$GPRMC".equals(nmea[0]) && nmea.length > 11) {
            if (!nmea[2].equals("A")) {
                throw new UnparsablePositionException("Not valid or not autonomous NMEA sentence");
            }
            lats = nmea[3];
            lath = nmea[4];
            lngs = nmea[5];
            lngh = nmea[6];
        } else if ("$GPWPL".equals(nmea[0]) && nmea.length > 5) {
            lats = nmea[1];
            lath = nmea[2];
            lngs = nmea[3];
            lngh = nmea[4];
        } else if (nmea.length > 15 && "$PNTS".equals(nmea[0]) && "1".equals(nmea[1])) {
            lats = nmea[7];
            lath = nmea[8];
            lngs = nmea[9];
            lngh = nmea[10];
        } else if ("$GPGSA".equals(nmea[0]) || "$GPVTG".equals(nmea[0]) || "$GPGSV".equals(nmea[0])) {
            throw new UnparsablePositionException("Ignored NMEA sentence");
        }
        if (lats == null) {
            throw new UnparsablePositionException("Invalid NMEA sentence");
        }
        try {
            double lat = PositionParser.parseDegMin(lats.toCharArray(), 0, 2, 9, true);
            double lng = PositionParser.parseDegMin(lngs.toCharArray(), 0, 3, 9, true);
            if (lat > 90.0) {
                throw new UnparsablePositionException("Latitude too high");
            }
            if (lng > 180.0) {
                throw new UnparsablePositionException("Longitude too high");
            }
            if (lath.equals("S") || lath.equals("s")) {
                lat = 0.0 - lat;
            } else if (!lath.equals("N") && !lath.equals("n")) {
                throw new UnparsablePositionException("Bad latitude sign");
            }
            if (lngh.equals("W") || lngh.equals("w")) {
                lng = 0.0 - lng;
            } else if (!lngh.equals("E") && !lngh.equals("e")) {
                throw new UnparsablePositionException("Bad longitude sign");
            }
            return new Position(lat, lng, 0, '/', '>');
        }
        catch (Exception e) {
            throw new UnparsablePositionException("Abject failure parsing NMEA sentence");
        }
    }

    public static Position parseCompressed(byte[] msgBody, int cursor) throws Exception {
        if (msgBody.length < cursor + 13) {
            throw new UnparsablePositionException("Compressed position too short");
        }
        for (int i = 1; i < 9; ++i) {
            char c = (char)msgBody[cursor + i];
            if (c >= '!' && c <= '{') continue;
            throw new UnparsablePositionException("Compressed position characters out of range");
        }
        int lat1 = (char)msgBody[cursor + 1] - 33;
        int lat2 = (char)msgBody[cursor + 2] - 33;
        int lat3 = (char)msgBody[cursor + 3] - 33;
        int lat4 = (char)msgBody[cursor + 4] - 33;
        int lng1 = (char)msgBody[cursor + 5] - 33;
        int lng2 = (char)msgBody[cursor + 6] - 33;
        int lng3 = (char)msgBody[cursor + 7] - 33;
        int lng4 = (char)msgBody[cursor + 8] - 33;
        float lat = 90.0f - (float)(lat1 * 91 * 91 * 91 + lat2 * 91 * 91 + lat3 * 91 + lat4) / 380926.0f;
        float lng = -180.0f + (float)(lng1 * 91 * 91 * 91 + lng2 * 91 * 91 + lng3 * 91 + lng4) / 190463.0f;
        return new Position(lat, lng, 0, (char)msgBody[cursor + 0], (char)msgBody[cursor + 9]);
    }

    public static DataExtension parseCompressedExtension(byte[] msgBody, int cursor) throws Exception {
        DataExtension de = null;
        if (msgBody[cursor + 9] == 95) {
            return null;
        }
        int t = (char)msgBody[cursor + 12] - 33;
        int nmeaSource = (t & 0x18) >> 3;
        if (nmeaSource == 2) {
            return null;
        }
        int c = (char)msgBody[cursor + 10] - 33;
        if (c + 33 == 32) {
            return null;
        }
        if (c < 90) {
            int s = (char)msgBody[cursor + 11] - 33;
            CourseAndSpeedExtension cse = new CourseAndSpeedExtension();
            cse.setCourse(c * 4);
            cse.setSpeed((int)Math.round(Math.pow(1.08, s) - 1.0));
            de = cse;
        } else if (c == 123) {
            RangeExtension re;
            int s = (char)msgBody[cursor + 11] - 33;
            s = (int)Math.round(2.0 * Math.pow(1.08, s));
            de = re = new RangeExtension(s);
        }
        return de;
    }

    private static double parseDegMin(char[] txt, int cursor, int degSize, int len, boolean decimalDot) throws Exception {
        if (txt == null || txt.length < cursor + degSize + 2) {
            throw new Exception("Too short degmin data");
        }
        double result = 0.0;
        for (int i = 0; i < degSize; ++i) {
            char c = txt[cursor + i];
            if (c < '0' || c > '9') {
                throw new Exception("Bad input decimals:  " + c);
            }
            result = result * 10.0 + (double)(c - 48);
        }
        double minFactor = 10.0;
        double minutes = 0.0;
        int mLen = txt.length - degSize - cursor;
        if (mLen > len - degSize) {
            mLen = len - degSize;
        }
        for (int i = 0; i < mLen; ++i) {
            char c = txt[cursor + degSize + i];
            if (decimalDot && i == 2) {
                if (c == '.') continue;
                throw new Exception("Expected decimal dot");
            }
            if (c < '0' || c > '9') {
                throw new Exception("Bad input decimals: " + c);
            }
            minutes += minFactor * (double)(c - 48);
            minFactor *= 0.1;
        }
        if (minutes >= 60.0) {
            throw new Exception("Bad minutes value - 60.0 or over");
        }
        result += minutes / 60.0;
        result = (double)Math.round(result * 100000.0) * 1.0E-5;
        if (degSize == 2 && result > 90.01) {
            throw new Exception("Latitude value too high");
        }
        if (degSize == 3 && result > (double)180.01f) {
            throw new Exception("Longitude value too high");
        }
        return result;
    }

    private static boolean validSymTableUncompressed(char c) {
        if (c == '/' || c == '\\') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }
}

