/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.kiss;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openstatic.aprs.parser.APRSPacket;
import org.openstatic.aprs.parser.APRSTypes;
import org.openstatic.aprs.parser.Callsign;
import org.openstatic.aprs.parser.Digipeater;
import org.openstatic.aprs.parser.InformationField;
import org.openstatic.aprs.parser.ObjectPacket;
import org.openstatic.aprs.parser.Parser;
import org.openstatic.aprs.parser.Position;
import org.openstatic.aprs.parser.PositionPacket;
import org.openstatic.kiss.APITermProcessHandler;
import org.openstatic.kiss.AX25Packet;
import org.openstatic.kiss.AX25PacketListener;
import org.openstatic.kiss.InterfaceServlet;
import org.openstatic.kiss.JavaKISSMain;
import org.openstatic.kiss.KISSClient;
import org.openstatic.sound.MixerStream;
import org.openstatic.sound.MixerStreamListener;

public class APIWebServer
implements AX25PacketListener,
Runnable,
MixerStreamListener {
    private Server httpServer;
    protected ArrayList<WebSocketSession> wsSessions;
    protected HashMap<WebSocketSession, JSONObject> sessionProps;
    protected HashMap<WebSocketSession, APITermProcessHandler> processes;
    private KISSClient kClient;
    private Thread pingPongThread;
    private ArrayList<JSONObject> packetHistory = new ArrayList();
    protected static APIWebServer instance;

    public APIWebServer(KISSClient client) {
        this.kClient = client;
        this.kClient.addAX25PacketListener(this);
        instance = this;
        this.wsSessions = new ArrayList();
        this.sessionProps = new HashMap();
        this.processes = new HashMap();
        this.httpServer = new Server(JavaKISSMain.settings.optInt("apiPort", 8101));
        ServletContextHandler context = new ServletContextHandler(0);
        context.setContextPath("/");
        context.addServlet(ApiServlet.class, "/jaxt/api/*");
        context.addServlet(EventsWebSocketServlet.class, "/jaxt/*");
        try {
            context.addServlet(InterfaceServlet.class, "/*");
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.httpServer.setHandler(context);
        try {
            this.httpServer.start();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.pingPongThread = new Thread(this);
        this.pingPongThread.start();
        this.refreshMixers();
    }

    public void refreshMixers() {
        JavaKISSMain.soundSystem.refreshMixers();
        JavaKISSMain.soundSystem.getAvailableMixerStreams().forEach(ms -> ms.addMixerStreamListener(this));
    }

    public static synchronized String generateBigAlphaKey(int key_length) {
        try {
            Thread.sleep(1L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Random n = new Random(System.currentTimeMillis());
        String alpha = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        StringBuffer return_key = new StringBuffer();
        for (int i = 0; i < key_length; ++i) {
            return_key.append(alpha.charAt(n.nextInt(alpha.length())));
        }
        String randKey = return_key.toString();
        return randKey;
    }

    public void addHistory(JSONObject obj) {
        this.packetHistory.add(obj);
        JavaKISSMain.jsonLogAppend("api.json", obj);
        if (this.packetHistory.size() > 1000) {
            this.packetHistory.remove(0);
        }
    }

    public static void sendAuthOk(WebSocketSession session, String termAuth) {
        JSONObject authJsonObject = new JSONObject();
        authJsonObject.put("action", "authOk");
        authJsonObject.put("termAuth", termAuth);
        authJsonObject.put("kissConnected", APIWebServer.instance.kClient.isConnected());
        authJsonObject.put("txDisabled", JavaKISSMain.settings.optBoolean("txDisabled", false));
        authJsonObject.put("availableHistory", APIWebServer.instance.packetHistory.size());
        authJsonObject.put("hostname", JavaKISSMain.settings.optString("hostname", "JAXT"));
        authJsonObject.put("source", JavaKISSMain.settings.optString("source", null));
        session.getRemote().sendStringByFuture(authJsonObject.toString());
    }

    public void handleWebSocketEvent(JSONObject j, WebSocketSession session) {
        JSONObject sessionProperties = this.sessionProps.get(session);
        if (!sessionProperties.optBoolean("auth", false)) {
            String termAuth;
            String settingPassword = JavaKISSMain.settings.optString("apiPassword", "");
            if (j.has("apiPassword")) {
                boolean authGood = settingPassword.equals(j.optString("apiPassword", ""));
                if (authGood) {
                    String termAuth2 = APIWebServer.generateBigAlphaKey(16);
                    sessionProperties.put("auth", true);
                    sessionProperties.put("termAuth", termAuth2);
                    APIWebServer.sendAuthOk(session, termAuth2);
                } else {
                    JSONObject errorJsonObject = new JSONObject();
                    errorJsonObject.put("action", "authFail");
                    errorJsonObject.put("error", "Invalid apiPassword!");
                    session.getRemote().sendStringByFuture(errorJsonObject.toString());
                }
            } else if (j.has("termAuth") && this.validateTermAuth(termAuth = j.optString("termAuth", ""))) {
                sessionProperties.put("auth", true);
                sessionProperties.put("termAuth", termAuth);
                APIWebServer.sendAuthOk(session, termAuth);
            }
        }
        if (sessionProperties.optBoolean("auth", false)) {
            if (j.has("source") && j.has("destination") && j.has("control")) {
                AX25Packet packet = new AX25Packet(j);
                try {
                    this.kClient.send(packet);
                }
                catch (Exception termAuth) {}
            } else if (j.has("history")) {
                int historyRequest = j.optInt("history", 100);
                if (historyRequest > this.packetHistory.size()) {
                    historyRequest = this.packetHistory.size();
                }
                for (int i = this.packetHistory.size() - historyRequest; i < this.packetHistory.size(); ++i) {
                    String histPacket = this.packetHistory.get(i).toString();
                    session.getRemote().sendStringByFuture(histPacket);
                }
            } else if (j.has("termId")) {
                sessionProperties.put("termId", j.optLong("termId", 0L));
                JSONObject commandsObject = new JSONObject();
                commandsObject.put("action", "commands");
                if (JavaKISSMain.settings.has("commandsFile")) {
                    try {
                        JSONObject commands = JavaKISSMain.loadJSONObject(new File(JavaKISSMain.settings.optString("commandsFile")));
                        commandsObject.put("commands", commands);
                        session.getRemote().sendStringByFuture(commandsObject.toString());
                        sessionProperties.put("commands", commands);
                    }
                    catch (Exception commands) {}
                }
            } else if (j.has("action")) {
                MixerStream mixerStream;
                int sourceDevId;
                int devId;
                String action = j.optString("action", "");
                if (action.equals("command") && sessionProperties.has("termId")) {
                    JSONArray argJSONArray = j.optJSONArray("args");
                    String[] args = APIWebServer.JSONArrayToStringArray(argJSONArray);
                    this.handleCommand(session, sessionProperties, j.optString("command"), args);
                } else if (action.equals("input") && sessionProperties.has("termId")) {
                    APITermProcessHandler apiTermProcessHandler = this.processes.get(session);
                    if (apiTermProcessHandler != null) {
                        apiTermProcessHandler.println(j.optString("text", ""));
                    }
                } else if (action.equals("kill") && sessionProperties.has("termId")) {
                    if (this.processes.containsKey(session)) {
                        APITermProcessHandler apiTermProcessHandler = this.processes.get(session);
                        if (apiTermProcessHandler != null) {
                            apiTermProcessHandler.kill();
                        }
                        this.processes.remove(session);
                    }
                } else if (action.equals("clearHistory")) {
                    this.packetHistory.clear();
                } else if (action.equals("lsradio")) {
                    this.refreshMixers();
                    JSONObject infoPacket = new JSONObject();
                    infoPacket.put("action", "lsradio");
                    infoPacket.put("devices", JavaKISSMain.soundSystem.getAvailableDevices());
                    infoPacket.put("state", JavaKISSMain.soundSystem.getAvailableStates());
                    infoPacket.put("timestamp", System.currentTimeMillis());
                    session.getRemote().sendStringByFuture(infoPacket.toString());
                } else if (action.equals("lucs")) {
                    Callsign callsign = new Callsign(j.optString("callsign"));
                    this.refreshMixers();
                    JSONObject infoPacket = new JSONObject();
                    infoPacket.put("action", "lucs");
                    infoPacket.put("callsign", callsign.getHamDBRecord());
                    infoPacket.put("timestamp", System.currentTimeMillis());
                    session.getRemote().sendStringByFuture(infoPacket.toString());
                } else if (action.equals("stopradio")) {
                    devId = j.optInt("devId", -1);
                    if (devId >= 0) {
                        JavaKISSMain.soundSystem.stopMixer(devId);
                    }
                } else if (action.equals("monitorradio")) {
                    sourceDevId = j.optInt("sourceDevId", -1);
                    int destDevId = j.optInt("destDevId", -1);
                    if (sourceDevId >= 0 && destDevId >= 0) {
                        MixerStream sourceMixerStream = JavaKISSMain.soundSystem.getMixer(sourceDevId);
                        MixerStream destMixerStream = JavaKISSMain.soundSystem.getMixer(destDevId);
                        if (sourceMixerStream != null && destMixerStream != null) {
                            JavaKISSMain.mainLog("[MONITORING] " + sourceMixerStream.getMixerName() + " with " + destMixerStream.getMixerName());
                            sourceMixerStream.addTargetMixerStream(destMixerStream);
                        }
                    }
                } else if (action.equals("unmonitorradio")) {
                    sourceDevId = j.optInt("sourceDevId", -1);
                    int destDevId = j.optInt("destDevId", -1);
                    if (sourceDevId >= 0 && destDevId >= 0) {
                        MixerStream sourceMixerStream = JavaKISSMain.soundSystem.getMixer(sourceDevId);
                        MixerStream destMixerStream = JavaKISSMain.soundSystem.getMixer(destDevId);
                        if (sourceMixerStream != null && destMixerStream != null) {
                            JavaKISSMain.mainLog("[UN-MONITORING] " + sourceMixerStream.getMixerName() + " with " + destMixerStream.getMixerName());
                            sourceMixerStream.removeTargetMixerStream(destMixerStream);
                        }
                    }
                } else if (action.equals("startradio")) {
                    devId = j.optInt("devId", -1);
                    if (devId >= 0) {
                        JavaKISSMain.soundSystem.startMixer(devId);
                    }
                } else if (action.equals("setradio")) {
                    devId = j.optInt("devId", -1);
                    if (devId >= 0) {
                        mixerStream = JavaKISSMain.soundSystem.getMixer(devId);
                        if (j.has("key") && j.has("value")) {
                            mixerStream.getMixerSettings().put(j.optString("key"), j.opt("value"));
                            if (mixerStream.isAlive()) {
                                mixerStream.restart();
                            }
                        }
                        JSONObject setAudioPacket = new JSONObject();
                        setAudioPacket.put("action", "setradio");
                        setAudioPacket.put("devId", devId);
                        setAudioPacket.put("name", mixerStream.getMixerName());
                        setAudioPacket.put("mixerSettings", mixerStream.getMixerSettings());
                        setAudioPacket.put("timestamp", System.currentTimeMillis());
                        session.getRemote().sendStringByFuture(setAudioPacket.toString());
                    }
                } else if (action.equals("unsetradio")) {
                    devId = j.optInt("devId", -1);
                    if (devId >= 0) {
                        mixerStream = JavaKISSMain.soundSystem.getMixer(devId);
                        if (j.has("key")) {
                            mixerStream.getMixerSettings().remove(j.optString("key"));
                            if (mixerStream.isAlive()) {
                                mixerStream.restart();
                            }
                        }
                        JSONObject setAudioPacket = new JSONObject();
                        setAudioPacket.put("action", "unsetradio");
                        setAudioPacket.put("devId", devId);
                        setAudioPacket.put("name", mixerStream.getMixerName());
                        setAudioPacket.put("mixerSettings", mixerStream.getMixerSettings());
                        setAudioPacket.put("timestamp", System.currentTimeMillis());
                        session.getRemote().sendStringByFuture(setAudioPacket.toString());
                    }
                } else if (action.equals("info")) {
                    this.broadcastINFO(j.optString("text", ""));
                }
            }
        } else {
            JSONObject errorJsonObject = new JSONObject();
            errorJsonObject.put("error", "Not Authorized!");
            session.getRemote().sendStringByFuture(errorJsonObject.toString());
        }
        this.sessionProps.put(session, sessionProperties);
    }

    public boolean validateTermAuth(String termAuth) {
        if (termAuth == null) {
            return false;
        }
        List termAuths = this.sessionProps.values().stream().map(p -> p.optString("termAuth", null)).filter(v -> !"".equals(v) && v != null).collect(Collectors.toList());
        return termAuths.contains(termAuth);
    }

    private static String[] JSONArrayToStringArray(JSONArray arry) {
        String[] args = new String[arry.length()];
        for (int i = 0; i < arry.length(); ++i) {
            args[i] = arry.getString(i);
        }
        return args;
    }

    public void broadcastINFO(String text) {
        JSONObject infoPacket = new JSONObject();
        infoPacket.put("action", "info");
        infoPacket.put("text", text);
        infoPacket.put("timestamp", System.currentTimeMillis());
        instance.broadcastJSONObject(infoPacket);
        this.addHistory(infoPacket);
    }

    public void broadcastJSONObject(JSONObject jo) {
        String message = jo.toString();
        for (Session session : this.wsSessions) {
            try {
                JSONObject sessionProps = this.sessionProps.get(session);
                if (!sessionProps.optBoolean("auth", false)) continue;
                session.getRemote().sendStringByFuture(message);
            }
            catch (Exception exception) {}
        }
    }

    public void sendJSONObject(JSONObject jo, long termId) {
        String message = jo.toString();
        for (Session session : this.wsSessions) {
            try {
                JSONObject sessionProps = this.sessionProps.get(session);
                if (!sessionProps.optBoolean("auth", false) || sessionProps.optLong("termId", 0L) != termId) continue;
                session.getRemote().sendStringByFuture(message);
            }
            catch (Exception exception) {}
        }
    }

    public void handleCommand(WebSocketSession session, JSONObject sessionProperties, String command, String[] args) {
        long termId = sessionProperties.optLong("termId", 0L);
        JSONObject commands = sessionProperties.optJSONObject("commands", new JSONObject());
        if (commands.has(command)) {
            JSONObject commandObject = commands.getJSONObject(command);
            ArrayList<String> commandWithArgs = new ArrayList<String>();
            if (commandObject.has("execute")) {
                String[] execute = APIWebServer.JSONArrayToStringArray(commandObject.getJSONArray("execute"));
                commandWithArgs.addAll(Arrays.asList(execute));
                if (!commandObject.optBoolean("ignoreExtraArgs", false)) {
                    commandWithArgs.addAll(Arrays.asList(args));
                }
                ProcessBuilder pb = new ProcessBuilder(commandWithArgs);
                APITermProcessHandler apiTermProcessHandler = new APITermProcessHandler(termId, pb);
                this.processes.put(session, apiTermProcessHandler);
            } else {
                this.writeTerm(termId, command + ": invalid command entry\r\n");
                this.promptTerm(termId);
            }
        } else {
            this.writeTerm(termId, command + ": command not found\r\n");
            this.promptTerm(termId);
        }
    }

    public void writeTerm(long termId, String text) {
        JSONObject jo = new JSONObject();
        jo.put("action", "write");
        jo.put("data", text);
        this.sendJSONObject(jo, termId);
    }

    public void promptTerm(long termId) {
        JSONObject jo = new JSONObject();
        jo.put("action", "prompt");
        this.sendJSONObject(jo, termId);
    }

    @Override
    public void onKISSConnect(InetSocketAddress socketAddress) {
        JSONObject kissStateJsonObject = new JSONObject();
        kissStateJsonObject.put("action", "kissConnected");
        this.broadcastJSONObject(kissStateJsonObject);
    }

    @Override
    public void onKISSDisconnect(InetSocketAddress socketAddress) {
        JSONObject kissStateJsonObject = new JSONObject();
        kissStateJsonObject.put("action", "kissDisconnected");
        this.broadcastJSONObject(kissStateJsonObject);
    }

    @Override
    public void onReceived(AX25Packet packet) {
        JSONObject jPacket = packet.toJSONObject();
        this.broadcastJSONObject(jPacket);
        this.addHistory(jPacket);
        this.broadcastAPRS(packet);
    }

    public void broadcastAPRS(AX25Packet packet) {
        if (packet.controlContains("UI")) {
            try {
                InformationField aprsData;
                ArrayList<Digipeater> digis = new ArrayList<Digipeater>();
                String[] paths = packet.getPath();
                for (int i = 0; i < paths.length; ++i) {
                    digis.add(new Digipeater(paths[i]));
                }
                APRSPacket aprs = Parser.parseBody(packet.getSourceCallsign(), packet.getDestinationCallsign(), digis, packet.getPayload());
                if (aprs.isAprs() && aprs.getType() != APRSTypes.T_UNSPECIFIED && (aprsData = aprs.getAprsInformation()) != null) {
                    Position position;
                    JSONObject aprsJSON = new JSONObject();
                    String sourceCallsign = packet.getSourceCallsign();
                    aprsJSON.put("source", sourceCallsign);
                    aprsJSON.put("sourceCallsign", new Callsign(sourceCallsign).getHamDBRecord());
                    aprsJSON.put("destination", packet.getDestinationCallsign());
                    if (packet.getPath() != null) {
                        aprsJSON.put("path", new JSONArray(packet.getPath()));
                    }
                    aprsJSON.put("comment", aprsData.getComment());
                    aprsJSON.put("type", aprs.getType());
                    aprsJSON.put("action", "APRS");
                    aprsJSON.put("timestamp", System.currentTimeMillis());
                    if (aprsData instanceof PositionPacket) {
                        PositionPacket posData = (PositionPacket)aprsData;
                        position = posData.getPosition();
                        aprsJSON.put("latitude", position.getLatitude());
                        aprsJSON.put("longitude", position.getLongitude());
                        aprsJSON.put("altitude", position.getAltitude());
                    }
                    if (aprsData instanceof ObjectPacket) {
                        ObjectPacket objectPacket = (ObjectPacket)aprsData;
                        position = objectPacket.getPosition();
                        aprsJSON.put("latitude", position.getLatitude());
                        aprsJSON.put("longitude", position.getLongitude());
                        aprsJSON.put("altitude", position.getAltitude());
                    }
                    this.broadcastJSONObject(aprsJSON);
                    this.addHistory(aprsJSON);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void onTransmit(AX25Packet packet) {
        JSONObject jPacket = packet.toJSONObject();
        this.broadcastJSONObject(jPacket);
        this.addHistory(jPacket);
        this.broadcastAPRS(packet);
    }

    @Override
    public void run() {
        while (this.httpServer.isRunning()) {
            try {
                JSONObject pingJSON = new JSONObject();
                pingJSON.put("action", "ping");
                pingJSON.put("timestamp", System.currentTimeMillis());
                this.broadcastJSONObject(pingJSON);
                Thread.sleep(10000L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void onAudioInput(MixerStream mixerStream) {
        JSONObject jo = new JSONObject();
        jo.put("action", "incomingAudio");
        jo.put("timestamp", System.currentTimeMillis());
        jo.put("devId", JavaKISSMain.soundSystem.getMixerId(mixerStream));
        jo.put("device", mixerStream.getMixerName());
        this.broadcastJSONObject(jo);
    }

    @Override
    public void onDTMF(MixerStream ms, char dtmf) {
        JSONObject jo = new JSONObject();
        jo.put("action", "dtmf");
        jo.put("timestamp", System.currentTimeMillis());
        jo.put("key", String.valueOf(dtmf));
        jo.put("devId", JavaKISSMain.soundSystem.getMixerId(ms));
        jo.put("device", ms.getMixerName());
        this.broadcastJSONObject(jo);
    }

    @Override
    public void onSilence(MixerStream mixerStream) {
        JSONObject jo = new JSONObject();
        jo.put("action", "silence");
        jo.put("timestamp", System.currentTimeMillis());
        jo.put("devId", JavaKISSMain.soundSystem.getMixerId(mixerStream));
        jo.put("device", mixerStream.getMixerName());
        this.broadcastJSONObject(jo);
    }

    @Override
    public void onShutdown(MixerStream mixerStream) {
        JSONObject jo = new JSONObject();
        jo.put("action", "stopradio");
        jo.put("timestamp", System.currentTimeMillis());
        jo.put("devId", JavaKISSMain.soundSystem.getMixerId(mixerStream));
        jo.put("device", mixerStream.getMixerName());
        this.broadcastJSONObject(jo);
    }

    @Override
    public void onStartup(MixerStream mixerStream) {
        JSONObject jo = new JSONObject();
        jo.put("action", "startradio");
        jo.put("timestamp", System.currentTimeMillis());
        jo.put("devId", JavaKISSMain.soundSystem.getMixerId(mixerStream));
        jo.put("device", mixerStream.getMixerName());
        this.broadcastJSONObject(jo);
    }

    @Override
    public void onDTMFSequence(MixerStream mixerStream, String dtmfSequence) {
        JSONObject jo = new JSONObject();
        jo.put("action", "dtmfSequence");
        jo.put("timestamp", System.currentTimeMillis());
        jo.put("sequence", dtmfSequence);
        jo.put("devId", JavaKISSMain.soundSystem.getMixerId(mixerStream));
        jo.put("device", mixerStream.getMixerName());
        this.broadcastJSONObject(jo);
        this.addHistory(jo);
    }

    @Override
    public void onRecording(MixerStream mixerStream, long recordingDuration, File recordingFile) {
        JSONObject recordingEvent = new JSONObject();
        recordingEvent.put("action", "recording");
        recordingEvent.put("name", recordingFile.getName());
        recordingEvent.put("timestamp", System.currentTimeMillis());
        recordingEvent.put("duration", recordingDuration);
        recordingEvent.put("device", mixerStream.getMixerName());
        String uri = ("jaxt/api/logs/" + recordingFile.getAbsolutePath().replaceAll(Pattern.quote(JavaKISSMain.logsFolder.getAbsolutePath()), "")).replaceAll(Pattern.quote("//"), "/");
        recordingEvent.put("uri", uri);
        JavaKISSMain.apiWebServer.broadcastJSONObject(recordingEvent);
        JavaKISSMain.apiWebServer.addHistory(recordingEvent);
    }

    public static class ApiServlet
    extends HttpServlet {
        public JSONObject readJSONObjectPOST(HttpServletRequest request) {
            StringBuffer jb = new StringBuffer();
            String line = null;
            try {
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jb.append(line);
                }
            }
            catch (Exception reader) {
                // empty catch block
            }
            try {
                JSONObject jsonObject = new JSONObject(jb.toString());
                return jsonObject;
            }
            catch (JSONException e) {
                e.printStackTrace(System.err);
                return new JSONObject();
            }
        }

        public boolean isNumber(String v) {
            try {
                Integer.parseInt(v);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        protected void doPost(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            httpServletResponse.setContentType("text/javascript");
            httpServletResponse.setStatus(200);
            httpServletResponse.setCharacterEncoding("iso-8859-1");
            String target = request.getPathInfo();
            JSONObject response = new JSONObject();
            if (request.getContentType().contains("text/javascript") || request.getContentType().contains("application/json")) {
                JSONObject requestPost = this.readJSONObjectPOST(request);
                if (JavaKISSMain.settings.optString("apiPassword", "").equals(requestPost.optString("apiPassword", "")) || instance.validateTermAuth(requestPost.optString("termAuth", null))) {
                    try {
                        if (target.equals("/transmit/")) {
                            AX25Packet packet = new AX25Packet(requestPost);
                            APIWebServer.instance.kClient.send(packet);
                            response.put("transmitted", packet.toJSONObject());
                        }
                    }
                    catch (Exception x) {
                        x.printStackTrace(System.err);
                    }
                } else {
                    response.put("error", "Invalid apiPassword or termAuth!");
                }
            } else if (request.getContentType().equals("audio/wav") || request.getContentType().equals("audio/wave")) {
                try {
                    int devId;
                    MixerStream mixerStream;
                    if (target.equals("/transmit/") && (mixerStream = JavaKISSMain.soundSystem.getMixer(devId = Integer.valueOf(request.getParameter("devId")).intValue())) != null) {
                        long cll = request.getContentLengthLong();
                        ServletInputStream rInputStream = request.getInputStream();
                        byte[] payload = rInputStream.readAllBytes();
                        rInputStream.close();
                        mixerStream.play(payload);
                        response.put("transmitted", true);
                        response.put("bytes", payload.length);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace(System.err);
                }
            }
            httpServletResponse.getWriter().println(response.toString());
        }

        @Override
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            String responseType = "text/javascript";
            String target = request.getPathInfo();
            if (target.startsWith("/logs/") && JavaKISSMain.logsFolder != null) {
                File logFile = new File(JavaKISSMain.logsFolder, (target = target.substring(5)).replace('/', File.separatorChar));
                if (logFile.exists() && !logFile.isDirectory()) {
                    String contentType = InterfaceServlet.getContentTypeFor(target);
                    httpServletResponse.setContentType(contentType);
                    httpServletResponse.setStatus(200);
                    httpServletResponse.setCharacterEncoding("UTF-8");
                    FileInputStream inputStream = new FileInputStream(logFile);
                    ServletOutputStream output = httpServletResponse.getOutputStream();
                    ((InputStream)inputStream).transferTo(output);
                    output.flush();
                    ((InputStream)inputStream).close();
                } else {
                    httpServletResponse.setStatus(404);
                }
                return;
            }
            Set<String> parameterNames = request.getParameterMap().keySet();
            JSONObject response = new JSONObject();
            if (JavaKISSMain.settings.optString("apiPassword", "").equals(request.getParameter("apiPassword")) || instance.validateTermAuth(request.getParameter("termAuth"))) {
                if (target.equals("/transmit/")) {
                    if (APIWebServer.instance.kClient.isConnected()) {
                        try {
                            AX25Packet packet = AX25Packet.buildPacket(request.getParameter("source"), request.getParameter("destination"), request.getParameter("payload"));
                            APIWebServer.instance.kClient.send(packet);
                            response.put("transmitted", packet.toJSONObject());
                        }
                        catch (Exception x) {
                            response.put("error", x.getLocalizedMessage());
                        }
                    } else {
                        response.put("error", "Not connected to KISS server!");
                    }
                } else if (target.equals("/settings/")) {
                    Set<String> keySet = JavaKISSMain.settings.keySet();
                    for (String key : keySet) {
                        if ("apiPassword".equals(key)) continue;
                        response.put(key, JavaKISSMain.settings.opt(key));
                    }
                } else if (target.equals("/audio/")) {
                    response.put("devices", JavaKISSMain.soundSystem.getAvailableDevices());
                    response.put("state", JavaKISSMain.soundSystem.getAvailableStates());
                } else if (target.equals("/serial/")) {
                    response.put("devices", JavaKISSMain.serialSystem.getSerialPorts());
                } else if (target.equals("/stream/")) {
                    int devId = Integer.valueOf(request.getParameter("devId"));
                    try {
                        JavaKISSMain.soundSystem.openRecordingDeviceAndWriteTo(devId, request, httpServletResponse);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    return;
                }
            } else {
                response.put("error", "Invalid apiPassword!");
            }
            if ("text/javascript".equals(responseType)) {
                httpServletResponse.setContentType("text/javascript");
                httpServletResponse.setStatus(200);
                httpServletResponse.setCharacterEncoding("iso-8859-1");
                httpServletResponse.getWriter().println(response.toString());
            }
        }
    }

    public static class EventsWebSocketServlet
    extends WebSocketServlet {
        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(EventsWebSocket.class);
        }
    }

    @WebSocket
    public static class EventsWebSocket {
        @OnWebSocketMessage
        public void onText(Session session, String message) throws IOException {
            try {
                JSONObject jo = new JSONObject(message);
                if (session instanceof WebSocketSession) {
                    WebSocketSession wssession = (WebSocketSession)session;
                    instance.handleWebSocketEvent(jo, wssession);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @OnWebSocketConnect
        public void onConnect(Session session) throws IOException {
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                APIWebServer.instance.wsSessions.add(wssession);
                JSONObject sessionProperties = new JSONObject();
                String settingPassword = JavaKISSMain.settings.optString("apiPassword", "");
                if (settingPassword.equals("")) {
                    String termAuth = APIWebServer.generateBigAlphaKey(16);
                    sessionProperties.put("auth", true);
                    sessionProperties.put("termAuth", termAuth);
                    APIWebServer.sendAuthOk(wssession, termAuth);
                } else {
                    JSONObject hostJsonObject = new JSONObject();
                    hostJsonObject.put("hostname", JavaKISSMain.settings.optString("hostname", "JAXT"));
                    session.getRemote().sendStringByFuture(hostJsonObject.toString());
                }
                APIWebServer.instance.sessionProps.put(wssession, sessionProperties);
            }
        }

        @OnWebSocketClose
        public void onClose(Session session, int status, String reason) {
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                APIWebServer.instance.wsSessions.remove(wssession);
                APIWebServer.instance.sessionProps.remove(wssession);
                if (APIWebServer.instance.processes.containsKey(wssession)) {
                    APITermProcessHandler proc = APIWebServer.instance.processes.get(wssession);
                    proc.kill();
                    APIWebServer.instance.processes.remove(wssession);
                }
            }
        }
    }
}

