/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.kiss;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class AX25Packet {
    private String source;
    private String destination;
    private String[] path;
    private String payload;
    private Date timestamp;
    private JSONArray control;
    private int protocol;
    private String direction;
    private String commandResponse;
    private final int AX25_CRC_CORRECT = 61624;
    private final int CRC_CCITT_INIT_VAL = 65535;
    private final int MAX_FRAME_SIZE = 330;
    public static final int AX25_CONTROL_UI = 3;
    public static final int AX25_CONTROL_DISC = 83;
    public static final int AX25_CONTROL_SABM = 63;
    public static final int AX25_CONTROL_SABME = 127;
    public static final int AX25_CONTROL_UA_F0 = 99;
    public static final int AX25_CONTROL_UA_F1 = 115;
    public static final int AX25_CONTROL_DM = 15;
    public static final int AX25_CONTROL_FRMR = 135;
    public static final int AX25_PROTOCOL_COMPRESSED_TCPIP = 6;
    public static final int AX25_PROTOCOL_UNCOMPRESSED_TCPIP = 7;
    public static final int AX25_PROTOCOL_NO_LAYER_3 = 240;
    private static final int[] crc_ccitt_tab = new int[]{0, 4489, 8978, 12955, 17956, 22445, 25910, 29887, 35912, 40385, 44890, 48851, 51820, 56293, 59774, 63735, 4225, 264, 13203, 8730, 22181, 18220, 30135, 25662, 40137, 36160, 49115, 44626, 56045, 52068, 63999, 59510, 8450, 12427, 528, 5017, 26406, 30383, 17460, 21949, 44362, 48323, 36440, 40913, 60270, 64231, 51324, 55797, 12675, 8202, 4753, 792, 30631, 26158, 21685, 17724, 48587, 44098, 40665, 36688, 64495, 60006, 55549, 51572, 16900, 21389, 24854, 28831, 1056, 5545, 10034, 14011, 52812, 57285, 60766, 64727, 34920, 39393, 43898, 47859, 21125, 17164, 29079, 24606, 5281, 1320, 14259, 9786, 57037, 53060, 64991, 60502, 39145, 35168, 48123, 43634, 25350, 29327, 16404, 20893, 9506, 13483, 1584, 6073, 61262, 65223, 52316, 56789, 43370, 47331, 35448, 39921, 29575, 25102, 20629, 16668, 13731, 9258, 5809, 1848, 65487, 60998, 56541, 52564, 47595, 43106, 39673, 35696, 33800, 38273, 42778, 46739, 49708, 54181, 57662, 61623, 2112, 6601, 11090, 15067, 20068, 24557, 28022, 31999, 38025, 34048, 47003, 42514, 53933, 49956, 61887, 57398, 6337, 2376, 15315, 10842, 24293, 20332, 32247, 27774, 42250, 46211, 34328, 38801, 58158, 62119, 49212, 53685, 10562, 14539, 2640, 7129, 28518, 32495, 19572, 24061, 46475, 41986, 38553, 34576, 62383, 57894, 53437, 49460, 14787, 10314, 6865, 2904, 32743, 28270, 23797, 19836, 50700, 55173, 58654, 62615, 32808, 37281, 41786, 45747, 19012, 23501, 26966, 30943, 3168, 7657, 12146, 16123, 54925, 50948, 62879, 58390, 37033, 33056, 46011, 41522, 23237, 19276, 31191, 26718, 7393, 3432, 16371, 11898, 59150, 63111, 50204, 54677, 41258, 45219, 33336, 37809, 27462, 31439, 18516, 23005, 11618, 15595, 3696, 8185, 63375, 58886, 54429, 50452, 45483, 40994, 37561, 33584, 31687, 27214, 22741, 18780, 15843, 11370, 7921, 3960};

    public void setDirection(String d) {
        this.direction = d;
    }

    public byte[] bytesWithoutCRC() {
        int i;
        boolean uiOri;
        int crc = 65535;
        byte[] packet = new byte[330];
        int size = 0;
        int cpfSize = 1;
        int controlNumber = AX25Packet.encodeControl(this.control);
        boolean bl = uiOri = AX25Packet.JSONArrayContains(this.control, "I") || AX25Packet.JSONArrayContains(this.control, "UI");
        if (uiOri) {
            cpfSize = 2;
        } else {
            this.protocol = 0;
        }
        byte[] payloadArray = this.payload.getBytes(Charset.forName("US-ASCII"));
        int n = 14 + 7 * this.path.length + cpfSize + payloadArray.length;
        byte[] bytes = new byte[n];
        int offset = 0;
        boolean sourceCBit = false;
        boolean destCBit = false;
        if (AX25Packet.JSONArrayContains(this.control, "C")) {
            sourceCBit = false;
            destCBit = true;
        } else if (AX25Packet.JSONArrayContains(this.control, "R")) {
            sourceCBit = true;
            destCBit = false;
        } else {
            sourceCBit = false;
            destCBit = false;
        }
        AX25Packet.addCall(bytes, offset, this.destination, false, destCBit);
        AX25Packet.addCall(bytes, offset += 7, this.source, this.path == null || this.path.length == 0, sourceCBit);
        offset += 7;
        for (i = 0; i < this.path.length; ++i) {
            AX25Packet.addCall(bytes, offset, this.path[i], i == this.path.length - 1, false);
            offset += 7;
        }
        bytes[offset++] = (byte)controlNumber;
        if (uiOri) {
            bytes[offset++] = (byte)this.protocol;
            for (int j = 0; j < payloadArray.length; ++j) {
                bytes[offset++] = payloadArray[j];
            }
        }
        assert (offset == n);
        assert (size == 0);
        assert (crc == 65535);
        assert (bytes.length + 2 <= packet.length);
        for (i = 0; i < bytes.length; ++i) {
            packet[size] = bytes[i];
            crc = AX25Packet.crc_ccitt_update(crc, packet[size]);
            ++size;
        }
        int crcl = crc & 0xFF ^ 0xFF;
        int crch = crc >> 8 ^ 0xFF;
        packet[size] = (byte)crcl;
        crc = AX25Packet.crc_ccitt_update(crc, packet[size]);
        packet[++size] = (byte)crch;
        crc = AX25Packet.crc_ccitt_update(crc, packet[size]);
        ++size;
        assert (crc == 61624);
        return Arrays.copyOf(packet, size - 2);
    }

    public AX25Packet(byte[] bytes) {
        int crc = 65535;
        byte[] packet = new byte[330];
        int size = 0;
        this.timestamp = new Date(System.currentTimeMillis());
        this.direction = null;
        assert (crc == 65535);
        assert (bytes.length + 2 <= packet.length);
        for (int i = 0; i < bytes.length; ++i) {
            packet[size] = bytes[i];
            crc = AX25Packet.crc_ccitt_update(crc, packet[size]);
            ++size;
        }
        int crcl = crc & 0xFF ^ 0xFF;
        int crch = crc >> 8 ^ 0xFF;
        packet[size] = (byte)crcl;
        crc = AX25Packet.crc_ccitt_update(crc, packet[size]);
        packet[++size] = (byte)crch;
        crc = AX25Packet.crc_ccitt_update(crc, packet[size]);
        ++size;
        assert (crc == 61624) : "Invalid CRC";
        int offset = 0;
        this.destination = AX25Packet.parseCall(packet, offset);
        boolean destCBit = AX25Packet.parseCallCBit(packet, offset);
        this.source = AX25Packet.parseCall(packet, offset += 7);
        boolean sourceCBit = AX25Packet.parseCallCBit(packet, offset);
        offset += 7;
        String commandResponse = null;
        commandResponse = !sourceCBit && destCBit ? "C" : (sourceCBit && !destCBit ? "R" : null);
        assert (!AX25Packet.containsNonKeyboardChars(this.source) && !AX25Packet.containsNonKeyboardChars(this.destination)) : "Bad characters in callsign";
        int repeaters = 0;
        while (offset + 7 <= size && (packet[offset - 1] & 1) == 0 && ++repeaters <= 8) {
            String path_element = AX25Packet.parseCall(packet, offset);
            offset += 7;
            if (this.path == null) {
                this.path = new String[1];
                this.path[0] = path_element;
                continue;
            }
            this.path = Arrays.copyOf(this.path, this.path.length + 1);
            this.path[this.path.length - 1] = path_element;
        }
        int controlNumber = packet[offset++] & 0xFF;
        byte[] payloadArray = new byte[]{};
        this.control = AX25Packet.decodeControl(commandResponse, controlNumber);
        if (this.controlContains("UI") || this.controlContains("I")) {
            this.protocol = packet[offset++] & 0xFF;
            if (size >= 18) {
                payloadArray = Arrays.copyOfRange(packet, offset, size - 2);
            }
        } else {
            this.protocol = 0;
        }
        this.payload = new String(payloadArray);
    }

    public static AX25Packet buildResponse(AX25Packet packet, JSONArray control) {
        JSONObject reverse = new JSONObject();
        reverse.put("source", packet.getDestinationCallsign());
        reverse.put("destination", packet.getSourceCallsign());
        if (!AX25Packet.JSONArrayContains(control, "R")) {
            control.put("R");
        }
        reverse.put("control", control);
        return new AX25Packet(reverse);
    }

    public static AX25Packet buildPacket(String source, String destination, String payload) {
        JSONObject packet = new JSONObject();
        packet.put("source", source);
        packet.put("destination", destination);
        packet.put("payload", payload);
        return new AX25Packet(packet);
    }

    public AX25Packet(JSONObject packet) {
        this.direction = null;
        this.timestamp = new Date(packet.optLong("timestamp", System.currentTimeMillis()));
        this.payload = packet.optString("payload", "");
        this.path = new String[0];
        if (packet.has("path")) {
            List<Object> pathList = packet.getJSONArray("path").toList();
            this.path = pathList.toArray(new String[pathList.size()]);
        }
        this.control = packet.optJSONArray("control");
        if (this.control == null) {
            this.control = AX25Packet.decodeControl(null, 3);
        }
        this.protocol = packet.optInt("protocol", 240) & 0xFF;
        this.commandResponse = packet.optString("commandResponse", null);
        this.source = packet.optString("source", "NOCALL").toUpperCase();
        this.destination = packet.optString("destination", "NOCALL").toUpperCase();
        if ("".equals(this.source)) {
            this.source = "NOCALL";
        }
        if ("".equals(this.destination)) {
            this.destination = "NOCALL";
        }
    }

    public JSONArray getControl() {
        return this.control;
    }

    public boolean controlContains(String key) {
        return AX25Packet.JSONArrayContains(this.control, key);
    }

    public void setTimestampNow() {
        this.setTimestamp(System.currentTimeMillis());
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = new Date(timestamp);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getSourceCallsign() {
        return this.source;
    }

    public String getDestinationCallsign() {
        return this.destination;
    }

    public String[] getPath() {
        if (this.path != null) {
            return this.path;
        }
        return new String[0];
    }

    public String getPayload() {
        return this.payload;
    }

    public int getReceiveModulus() {
        ArrayList<String> RCV = new ArrayList<String>(Arrays.asList("R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7"));
        for (int i = 0; i < this.control.length(); ++i) {
            String item = this.control.optString(i, "");
            int rcvIndex = RCV.indexOf(item);
            if (rcvIndex < 0) continue;
            return rcvIndex;
        }
        return -1;
    }

    public int getSendModulus() {
        ArrayList<String> SND = new ArrayList<String>(Arrays.asList("S0", "S1", "S2", "S3", "S4", "S5", "S6", "S7"));
        for (int i = 0; i < this.control.length(); ++i) {
            String item = this.control.optString(i, "");
            int sndIndex = SND.indexOf(item);
            if (sndIndex < 0) continue;
            return sndIndex;
        }
        return -1;
    }

    public void updatePayloadVar(String varName, long value) {
        this.updatePayloadVar(varName, String.valueOf(value));
    }

    public void updatePayloadVar(String varName, int value) {
        this.updatePayloadVar(varName, String.valueOf(value));
    }

    public void updatePayloadVar(String varName, String value) {
        if (this.payload != null) {
            this.payload = this.payload.replaceAll(Pattern.quote(varName), value);
        }
    }

    private static String parseCall(byte[] packet, int offset) {
        int c;
        int i;
        Object call = "";
        for (i = 0; i < 6; ++i) {
            int n = c = packet[offset + i] > 0 ? packet[offset + i] >> 1 : packet[offset + i] + 256 >> 1;
            if ((char)c == ' ') continue;
            call = (String)call + (char)c;
        }
        c = packet[offset + i] > 0 ? packet[offset + i] >> 1 : packet[offset + i] + 256 >> 1;
        int ssid = c & 0xF;
        if (ssid != 0) {
            call = (String)call + String.format("-%d", ssid);
        }
        return new String((String)call);
    }

    public static int encodeControl(JSONArray array) {
        ArrayList<String> RCV = new ArrayList<String>(Arrays.asList("R0", "R1", "R2", "R3", "R4", "R5", "R6", "R7"));
        ArrayList<String> SND = new ArrayList<String>(Arrays.asList("S0", "S1", "S2", "S3", "S4", "S5", "S6", "S7"));
        int control = 0;
        for (int i = 0; i < array.length(); ++i) {
            String item = array.optString(i, "");
            if (item.equals("SABME")) {
                control = 127;
                continue;
            }
            if (item.equals("SABM")) {
                control = 63;
                continue;
            }
            if (item.equals("DISC")) {
                control = 83;
                continue;
            }
            if (item.equals("UA")) {
                if (AX25Packet.JSONArrayContains(array, "F")) {
                    control = 115;
                    continue;
                }
                control = 99;
                continue;
            }
            if (item.equals("DM")) {
                control = 15;
                continue;
            }
            if (item.equals("FRMR")) {
                control = 135;
                continue;
            }
            if (item.equals("UI")) {
                control = 3;
                continue;
            }
            if (item.equals("RR")) {
                if (AX25Packet.JSONArrayContains(array, "P")) {
                    control = 17;
                    continue;
                }
                control = 1;
                continue;
            }
            if (item.equals("RNR")) {
                if (AX25Packet.JSONArrayContains(array, "P")) {
                    control = 21;
                    continue;
                }
                control = 5;
                continue;
            }
            if (item.equals("REJ")) {
                if (AX25Packet.JSONArrayContains(array, "P")) {
                    control = 25;
                    continue;
                }
                control = 9;
                continue;
            }
            if (item.equals("SREJ")) {
                if (AX25Packet.JSONArrayContains(array, "P")) {
                    control = 29;
                    continue;
                }
                control = 13;
                continue;
            }
            if (item.equals("I")) {
                if (AX25Packet.JSONArrayContains(array, "F")) {
                    control = 0;
                    continue;
                }
                control = 16;
                continue;
            }
            int sndIndex = SND.indexOf(item);
            int rcvIndex = RCV.indexOf(item);
            if (rcvIndex >= 0) {
                control = (rcvIndex & 7) << 5 | control;
            }
            if (sndIndex < 0) continue;
            control = (sndIndex & 7) << 1 | control;
        }
        return control;
    }

    public static JSONArray decodeControl(String cr, int controlNumber) {
        JSONArray ra = new JSONArray();
        if ((controlNumber & 3) == 1) {
            int pollFinal;
            int filtered_b;
            int filtered = controlNumber & 0xF;
            if (filtered == 1) {
                ra.put("RR");
                filtered_b = controlNumber & 0xE0;
                ra.put("R" + String.valueOf(filtered_b >> 5 & 7));
            }
            if (filtered == 5) {
                ra.put("RNR");
                filtered_b = controlNumber & 0xE0;
                ra.put("R" + String.valueOf(filtered_b >> 5 & 7));
            }
            if (filtered == 9) {
                ra.put("REJ");
                filtered_b = controlNumber & 0xE0;
                ra.put("R" + String.valueOf(filtered_b >> 5 & 7));
            }
            if (filtered == 13) {
                ra.put("SREJ");
                filtered_b = controlNumber & 0xE0;
                ra.put("R" + String.valueOf(filtered_b >> 5 & 7));
            }
            if ((pollFinal = (controlNumber & 0x10) >> 4) == 1) {
                ra.put("P");
            } else {
                ra.put("F");
            }
        } else if ((controlNumber & 3) == 3) {
            int filtered = controlNumber & 0xFF;
            if (filtered == 127) {
                ra.put("SABME");
                ra.put("P");
            }
            if (filtered == 63) {
                ra.put("SABM");
                ra.put("P");
            }
            if (filtered == 83) {
                ra.put("DISC");
                ra.put("P");
            }
            if (filtered == 15) {
                ra.put("DM");
                ra.put("F");
            }
            if (filtered == 135) {
                ra.put("FRMR");
                ra.put("F");
            }
            if (filtered == 115) {
                ra.put("UA");
                ra.put("F");
            } else if (filtered == 99) {
                ra.put("UA");
            }
            if (filtered == 3) {
                ra.put("UI");
            }
        } else if ((controlNumber & 1) == 0) {
            ra.put("I");
            int pollFinal = (controlNumber & 0x10) >> 4;
            if (pollFinal == 1) {
                ra.put("P");
            } else {
                ra.put("F");
            }
            int filtered = controlNumber & 0xE;
            ra.put("S" + String.valueOf(filtered >> 1 & 7));
            int filtered_b = controlNumber & 0xE0;
            ra.put("R" + String.valueOf(filtered_b >> 5 & 7));
        }
        if (cr != null) {
            if (cr.toUpperCase().equals("C")) {
                ra.put("C");
            } else if (cr.toUpperCase().equals("R")) {
                ra.put("R");
            }
        }
        return ra;
    }

    private static boolean parseCallCBit(byte[] packet, int offset) {
        int i = 6;
        int c = packet[offset + i] > 0 ? packet[offset + i] >> 1 : packet[offset + i] + 256 >> 1;
        int cBit = c & 0xE0;
        return cBit == 96;
    }

    private static void addCall(byte[] bytes, int offset, String call, boolean last, boolean cBit) {
        int i;
        boolean call_ended = false;
        char c = ' ';
        int ssid = 0;
        for (i = 0; i < 6; ++i) {
            if (i < call.length()) {
                c = call.charAt(i);
            } else {
                call_ended = true;
            }
            if (call_ended || !Character.isLetterOrDigit(c) || c == '-') {
                call_ended = true;
                c = ' ';
            } else {
                c = Character.toUpperCase(c);
            }
            bytes[offset++] = (byte)(c << 1);
        }
        for (i = 0; i < call.length(); ++i) {
            c = call.charAt(i);
            if (c != 45 || i + 1 >= call.length()) continue;
            ssid = Integer.parseInt(call.substring(i + 1));
            if (ssid <= 15 && ssid >= 0) break;
            ssid = 0;
            break;
        }
        ssid = ssid << 1 | (cBit ? 224 : 96) | (last ? 1 : 0);
        bytes[offset++] = (byte)ssid;
    }

    private static int crc_ccitt_update(int crc, byte b) {
        return crc >> 8 ^ crc_ccitt_tab[(crc ^ b) & 0xFF];
    }

    private static boolean containsNonKeyboardChars(String str) {
        String keyboardChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789`~!@#$%^&*()-_=+[{]}\\|;:'\",<.>/? ";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (keyboardChars.indexOf(c) != -1) continue;
            return true;
        }
        return false;
    }

    public JSONObject toJSONObject() {
        JSONObject ro = new JSONObject();
        ro.put("source", this.getSourceCallsign());
        ro.put("destination", this.getDestinationCallsign());
        if (this.payload != null && this.payload.length() > 0) {
            ro.put("payload", this.getPayload());
        }
        ro.put("control", this.control);
        if (this.protocol > 0) {
            ro.put("protocol", this.protocol & 0xFF);
        }
        if (this.direction != null) {
            ro.put("direction", this.direction);
        }
        try {
            ro.put("size", this.bytesWithoutCRC().length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.path != null && this.path.length > 0) {
            ro.put("path", new JSONArray(this.path));
        }
        ro.put("timestamp", this.timestamp.getTime());
        return ro;
    }

    public static boolean JSONArrayContains(JSONArray a, String needle) {
        for (int i = 0; i < a.length(); ++i) {
            if (!needle.equals(a.optString(i, null))) continue;
            return true;
        }
        return false;
    }

    public String toLogString() {
        StringBuffer sb = new StringBuffer();
        sb.append(AX25Packet.createSizedString(this.getSourceCallsign(), 9) + " > " + AX25Packet.createSizedString(this.getDestinationCallsign(), 9));
        String plStr = this.getPayload();
        sb.append(" [ ");
        StringBuffer sb2 = new StringBuffer();
        for (int i = 0; i < this.control.length(); ++i) {
            sb2.append(this.control.get(i));
            sb2.append(" ");
        }
        sb.append(AX25Packet.createSizedString(sb2.toString(), 14));
        sb.append("] ");
        if (plStr.length() > 0) {
            sb.append(plStr.replaceAll(Pattern.quote("\r"), "<CR>").replaceAll(Pattern.quote("\n"), "<LF>"));
        }
        return sb.toString();
    }

    public static String getPaddingSpace(int value) {
        StringBuffer x = new StringBuffer("");
        for (int n = 0; n < value; ++n) {
            x.append(" ");
        }
        return x.toString();
    }

    public static String createSizedString(String value, int size) {
        if (value == null) {
            return AX25Packet.getPaddingSpace(size);
        }
        if (value.length() == size) {
            return value;
        }
        if (value.length() > size) {
            return value.substring(0, size);
        }
        if (value.length() < size) {
            return value + AX25Packet.getPaddingSpace(size - value.length());
        }
        return null;
    }
}

