/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.kiss;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.MimeTypes;

public class InterfaceServlet
extends HttpServlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object target = request.getPathInfo();
        if (target == null) {
            target = "/";
        }
        if ("/".equals(target)) {
            target = "/index.html";
        }
        target = "/jaxt" + (String)target;
        URL data = this.getClass().getResource((String)target);
        if (data != null) {
            String contentType = InterfaceServlet.getContentTypeFor((String)target);
            httpServletResponse.setContentType(contentType);
            httpServletResponse.setStatus(200);
            httpServletResponse.setCharacterEncoding("UTF-8");
            InputStream inputStream = this.getClass().getResourceAsStream((String)target);
            ServletOutputStream output = httpServletResponse.getOutputStream();
            inputStream.transferTo(output);
            output.flush();
        } else {
            httpServletResponse.setStatus(404);
        }
    }

    public static String getContentTypeFor(String filename) {
        String lc_file = filename.toLowerCase();
        if (lc_file.endsWith(".html") || lc_file.endsWith(".htm")) {
            return "text/html";
        }
        if (lc_file.endsWith(".txt")) {
            return "text/plain";
        }
        if (lc_file.endsWith(".css")) {
            return "text/css";
        }
        if (lc_file.endsWith(".js")) {
            return "text/javascript";
        }
        if (lc_file.endsWith(".jpg") || lc_file.endsWith(".jpe") || lc_file.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (lc_file.endsWith(".gif")) {
            return "image/gif";
        }
        if (lc_file.endsWith(".png")) {
            return "image/png";
        }
        if (lc_file.endsWith(".svg")) {
            return "image/svg+xml";
        }
        if (lc_file.endsWith(".bmp")) {
            return "image/x-ms-bmp";
        }
        if (lc_file.endsWith(".mp3")) {
            return "audio/mpeg3";
        }
        if (lc_file.endsWith(".zip")) {
            return "application/zip";
        }
        if (lc_file.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (lc_file.endsWith(".xml")) {
            return "text/xml";
        }
        if (lc_file.endsWith(".mid") || lc_file.endsWith(".midi")) {
            return "audio/midi";
        }
        if (lc_file.endsWith(".tar")) {
            return "application/x-tar";
        }
        if (lc_file.endsWith(".ico")) {
            return "image/x-icon";
        }
        if (lc_file.endsWith(".avi")) {
            return "video/x-msvideo";
        }
        if (lc_file.endsWith(".mp4")) {
            return "video/mp4";
        }
        if (lc_file.endsWith(".mkv")) {
            return "video/x-matroska";
        }
        if (lc_file.endsWith(".mov")) {
            return "video/quicktime";
        }
        if (lc_file.endsWith(".wmv")) {
            return "video/x-ms-wmv";
        }
        if (lc_file.endsWith(".3gp")) {
            return "video/3gpp";
        }
        String result = MimeTypes.getDefaultMimeByExtension(filename);
        if ("".equals(result) || result == null) {
            result = "application/octet-stream";
        }
        return result;
    }
}

