/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.kiss;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import org.openstatic.kiss.KISSClient;

public class KissProcessor {
    private final int KISS_TX_FRAME_MAX_SIZE = 798;
    private final byte KISS_FEND = (byte)-64;
    private final byte KISS_FESC = (byte)-37;
    private final byte KISS_TFEND = (byte)-36;
    private final byte KISS_TFESC = (byte)-35;
    public final byte KISS_CMD_DATA = 0;
    public final byte KISS_CMD_TX_DELAY = 1;
    public final byte KISS_CMD_P = (byte)2;
    public final byte KISS_CMD_SLOT_TIME = (byte)3;
    public final byte KISS_CMD_DUPLEX = (byte)5;
    public final byte KISS_CMD_NOCMD = (byte)-128;
    private final byte KISS_MODEM_STREAMING = (byte)32;
    private final byte KISS_MODEM_BERT = (byte)48;
    private KissState _kissState = KissState.VOID;
    private byte _kissCmd = (byte)-128;
    private final byte _tncCsmaPersistence = (byte)63;
    private final byte _tncCsmaSlotTime = (byte)4;
    private final byte _tncTxDelay;
    private final byte _tncDuplex;
    private final byte[] _outputKissBuffer;
    private final byte[] _inputKissBuffer;
    private final KISSClient _callback;
    private int _outputKissBufferPos;
    private int _inputKissBufferPos;

    public KissProcessor(KISSClient callback, byte txDelay) {
        this._callback = callback;
        this._outputKissBuffer = new byte[798];
        this._inputKissBuffer = new byte[79800];
        this._tncTxDelay = txDelay;
        this._tncDuplex = 1;
        this._outputKissBufferPos = 0;
        this._inputKissBufferPos = 0;
    }

    public KissProcessor(KISSClient callback, byte txDelay, byte duplex) {
        this._callback = callback;
        this._outputKissBuffer = new byte[798];
        this._inputKissBuffer = new byte[79800];
        this._tncTxDelay = txDelay;
        this._tncDuplex = duplex;
        this._outputKissBufferPos = 0;
        this._inputKissBufferPos = 0;
    }

    public void send(byte[] frame) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream(frame.length * 2);
        output.write(-64);
        output.write(32);
        this.escape(frame, output);
        output.write(-64);
        this._callback.onKPSend(output.toByteArray());
    }

    public void receive(byte[] data) {
        block6: for (byte b : data) {
            switch (this._kissState) {
                case VOID: {
                    if (b != -64) continue block6;
                    this._kissCmd = (byte)-128;
                    this._kissState = KissState.GET_CMD;
                    continue block6;
                }
                case GET_CMD: {
                    if ((b & 7) == 0) {
                        this._kissCmd = b;
                        this._kissState = KissState.GET_DATA;
                        continue block6;
                    }
                    if (b == -64) continue block6;
                    this.resetState();
                    continue block6;
                }
                case GET_DATA: {
                    if (b == -37) {
                        this._kissState = KissState.ESCAPE;
                        continue block6;
                    }
                    if (b == -64) {
                        if (this._kissCmd == 0) {
                            this._callback.onKPReceive(Arrays.copyOfRange(this._inputKissBuffer, 0, this._inputKissBufferPos));
                        }
                        this.resetState();
                        continue block6;
                    }
                    this.receiveFrameByte(b);
                    continue block6;
                }
                case ESCAPE: {
                    if (b == -36) {
                        this.receiveFrameByte((byte)-64);
                        this._kissState = KissState.GET_DATA;
                        continue block6;
                    }
                    if (b == -35) {
                        this.receiveFrameByte((byte)-37);
                        this._kissState = KissState.GET_DATA;
                        continue block6;
                    }
                    this.resetState();
                    continue block6;
                }
            }
        }
    }

    public void flush() throws IOException {
        this.completeKissPacket();
    }

    public void sendKissByte(byte b) {
        if (this._outputKissBufferPos < this._outputKissBuffer.length) {
            this._outputKissBuffer[this._outputKissBufferPos++] = b;
        }
    }

    private void receiveFrameByte(byte b) {
        this._inputKissBuffer[this._inputKissBufferPos++] = b;
        if (this._inputKissBufferPos >= this._inputKissBuffer.length) {
            this.resetState();
        }
    }

    private void resetState() {
        this._kissCmd = (byte)-128;
        this._kissState = KissState.VOID;
        this._inputKissBufferPos = 0;
    }

    public void startKissPacket(byte commandCode) throws IOException {
        this.sendKissByte((byte)-64);
        this.sendKissByte(commandCode);
    }

    public void completeKissPacket() throws IOException {
        if (this._outputKissBufferPos > 0) {
            this.sendKissByte((byte)-64);
            this._callback.onKPSend(Arrays.copyOf(this._outputKissBuffer, this._outputKissBufferPos));
            this._outputKissBufferPos = 0;
        }
    }

    private void escape(byte[] inputBuffer, ByteArrayOutputStream output) {
        block4: for (byte b : inputBuffer) {
            switch (b) {
                case -64: {
                    output.write(-37);
                    output.write(-36);
                    continue block4;
                }
                case -37: {
                    output.write(-37);
                    output.write(-35);
                    continue block4;
                }
                default: {
                    output.write(b);
                }
            }
        }
    }

    private static enum KissState {
        VOID,
        GET_CMD,
        GET_DATA,
        ESCAPE;

    }
}

