/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.kiss;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.openstatic.kiss.AX25Packet;
import org.openstatic.kiss.AX25PacketListener;
import org.openstatic.kiss.KISSClient;
import org.openstatic.kiss.TerminalLinkListener;
import org.openstatic.kiss.TerminalLinkSession;

public class TerminalLink
implements AX25PacketListener {
    private KISSClient kClient;
    private String callsign;
    private HashMap<String, TerminalLinkSession> sessions = new HashMap();
    private ArrayList<TerminalLinkListener> listeners = new ArrayList();

    public TerminalLink(KISSClient kClient, String callsign) {
        this.kClient = kClient;
        this.callsign = callsign.toUpperCase();
        this.kClient.addAX25PacketListener(this);
    }

    public void addTerminalLinkListener(TerminalLinkListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public KISSClient getKISSClient() {
        return this.kClient;
    }

    public String getCallsign() {
        return this.callsign;
    }

    @Override
    public void onKISSConnect(InetSocketAddress socketAddress) {
    }

    @Override
    public void onKISSDisconnect(InetSocketAddress socketAddress) {
    }

    @Override
    public void onReceived(AX25Packet packet) {
        if (packet.getDestinationCallsign().equals(this.callsign)) {
            try {
                TerminalLinkSession session;
                if (packet.controlContains("SABM")) {
                    boolean newSessionNeeded = false;
                    TerminalLinkSession session2 = this.sessions.get(packet.getSourceCallsign());
                    if (session2 == null) {
                        newSessionNeeded = true;
                    } else if (!session2.isAlive()) {
                        newSessionNeeded = true;
                    }
                    if (newSessionNeeded) {
                        TerminalLinkSession fSession = session2 = new TerminalLinkSession(this, packet.getSourceCallsign());
                        this.sessions.put(packet.getSourceCallsign(), session2);
                        this.listeners.forEach(l -> l.onTerminalLinkSession(fSession));
                    }
                    session2.handleFrame(packet);
                }
                if (packet.controlContains("DISC")) {
                    JSONArray respCtrl = new JSONArray();
                    respCtrl.put("UA");
                    if (packet.controlContains("P")) {
                        respCtrl.put("F");
                    }
                    respCtrl.put("R");
                    AX25Packet pr = AX25Packet.buildResponse(packet, respCtrl);
                    this.kClient.send(pr);
                    TerminalLinkSession session3 = this.sessions.get(packet.getSourceCallsign());
                    if (session3 != null) {
                        this.sessions.remove(packet.getSourceCallsign());
                        session3.handleDisconnect();
                    }
                }
                if ((packet.controlContains("I") || packet.controlContains("RR") || packet.controlContains("UA") || packet.controlContains("REJ") || packet.controlContains("SREJ")) && (session = this.sessions.get(packet.getSourceCallsign())) != null) {
                    session.handleFrame(packet);
                }
            }
            catch (Exception tex) {
                tex.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void onTransmit(AX25Packet packet) {
    }

    public static boolean JSONArrayContains(JSONArray a, String needle) {
        for (int i = 0; i < a.length(); ++i) {
            if (!needle.equals(a.optString(i, null))) continue;
            return true;
        }
        return false;
    }
}

