/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.kiss;

import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.kiss.AX25Packet;
import org.openstatic.kiss.JavaKISSMain;
import org.openstatic.kiss.TerminalLink;
import org.openstatic.kiss.TerminalLinkSessionHandler;

public class TerminalLinkSession
implements Runnable {
    private int txModulus;
    private int rxModulus;
    private String remoteCallsign;
    private String linkCallsign;
    private TerminalLink link;
    private TerminalLinkSessionHandler handler;
    private LinkedBlockingQueue<String> outboundQueue;
    private boolean remoteReceiveReady;
    private int txRetryCount;
    private long lastRxAt;
    private long lastTxAt;
    private long lastSABMAt;
    private boolean sabmComplete;
    private Thread monitorThread;
    private boolean connected;
    private AX25Packet[] pendingPacket;

    public TerminalLinkSession(TerminalLink link, String remoteCallsign) {
        this.link = link;
        this.linkCallsign = link.getCallsign();
        this.remoteCallsign = remoteCallsign;
        this.txModulus = 0;
        this.rxModulus = 0;
        this.txRetryCount = 0;
        this.sabmComplete = false;
        this.lastSABMAt = System.currentTimeMillis();
        this.remoteReceiveReady = false;
        this.connected = true;
        this.outboundQueue = new LinkedBlockingQueue();
        this.pendingPacket = new AX25Packet[8];
        this.lastRxAt = System.currentTimeMillis();
        this.lastTxAt = 0L;
        this.monitorThread = new Thread(this);
        this.monitorThread.start();
    }

    public boolean isAlive() {
        return this.link != null && this.monitorThread.isAlive();
    }

    public void setHandler(TerminalLinkSessionHandler handler) {
        this.handler = handler;
        this.handler.onConnect(this);
    }

    public String getTerminalCallsign() {
        return this.linkCallsign;
    }

    public String getRemoteCallsign() {
        return this.remoteCallsign;
    }

    public void sendText(String text) {
        this.outboundQueue.addAll(TerminalLinkSession.splitString(text));
        if (this.remoteReceiveReady) {
            this.sendFromQueue();
        }
    }

    private void sendFromQueue() {
        if (this.outboundQueue.size() > 0) {
            String dataOut = this.outboundQueue.poll();
            this.sendIFrame(dataOut);
        }
    }

    private void sendIFrame(String text) {
        JSONObject jPacket = new JSONObject();
        jPacket.put("source", this.linkCallsign);
        jPacket.put("destination", this.remoteCallsign);
        jPacket.put("payload", text);
        JSONArray cArray = new JSONArray();
        cArray.put("I");
        cArray.put("R" + String.valueOf(this.rxModulus));
        cArray.put("S" + String.valueOf(this.txModulus));
        cArray.put("C");
        jPacket.put("control", cArray);
        AX25Packet packet = new AX25Packet(jPacket);
        this.remoteReceiveReady = false;
        this.pendingPacket[packet.getSendModulus()] = packet;
        this.transmit(packet);
    }

    public void disconnect() {
        JSONObject jPacket = new JSONObject();
        jPacket.put("source", this.linkCallsign);
        jPacket.put("destination", this.remoteCallsign);
        JSONArray cArray = new JSONArray();
        cArray.put("DISC");
        cArray.put("F");
        cArray.put("C");
        jPacket.put("control", cArray);
        AX25Packet packet = new AX25Packet(jPacket);
        this.transmit(packet);
        this.handleDisconnect();
    }

    protected void handleDisconnect() {
        if (this.connected) {
            if (this.handler != null) {
                this.handler.onDisconnect(this);
            }
            this.link = null;
            this.connected = false;
        }
    }

    private static ArrayList<String> splitString(String str) {
        ArrayList<String> result = new ArrayList<String>();
        while (str.length() > 0) {
            int endIndex = Math.min(str.length(), 255);
            String chunk = str.substring(0, endIndex);
            result.add(chunk);
            str = str.substring(endIndex);
        }
        return result;
    }

    protected void handleFrame(AX25Packet packet) {
        int nextTxMod;
        AX25Packet pr;
        JSONArray respCtrl;
        this.lastRxAt = System.currentTimeMillis();
        if (packet.controlContains("SABM")) {
            this.lastSABMAt = System.currentTimeMillis();
            JSONObject jPacket = new JSONObject();
            jPacket.put("source", this.linkCallsign);
            jPacket.put("destination", this.remoteCallsign);
            JSONArray respCtrl2 = new JSONArray();
            respCtrl2.put("UA");
            respCtrl2.put("F");
            respCtrl2.put("R");
            jPacket.put("control", respCtrl2);
            AX25Packet pr2 = new AX25Packet(jPacket);
            this.transmit(pr2);
        }
        if (packet.controlContains("I")) {
            if (packet.getSendModulus() == this.rxModulus) {
                if (this.handler != null) {
                    this.handler.onData(this, packet.getPayload());
                }
                ++this.rxModulus;
                if (this.rxModulus >= 8) {
                    this.rxModulus = 0;
                }
            }
            respCtrl = new JSONArray();
            respCtrl.put("RR");
            respCtrl.put("R" + String.valueOf(this.rxModulus));
            respCtrl.put("R");
            pr = AX25Packet.buildResponse(packet, respCtrl);
            this.transmit(pr);
        }
        if (packet.controlContains("RR")) {
            if (packet.controlContains("C")) {
                respCtrl = new JSONArray();
                respCtrl.put("RR");
                respCtrl.put("R" + String.valueOf(this.rxModulus));
                pr = AX25Packet.buildResponse(packet, respCtrl);
                this.transmit(pr);
            } else if (packet.controlContains("R") && !this.remoteReceiveReady) {
                this.txRetryCount = 0;
                this.txModulus = packet.getReceiveModulus();
                this.pendingPacket[this.txModulus] = null;
                this.remoteReceiveReady = true;
                this.sendFromQueue();
            }
        }
        if (packet.controlContains("REJ") && packet.controlContains("R") && (nextTxMod = (this.txModulus + 1) % 8) == packet.getReceiveModulus()) {
            this.txModulus = packet.getReceiveModulus();
            this.pendingPacket[this.txModulus] = null;
            this.remoteReceiveReady = true;
            this.sendFromQueue();
        }
    }

    public long lastTxAge() {
        return System.currentTimeMillis() - this.lastTxAt;
    }

    public long lastRxAge() {
        return System.currentTimeMillis() - this.lastRxAt;
    }

    private void transmit(AX25Packet packet) {
        if (this.link != null) {
            try {
                this.link.getKISSClient().send(packet);
                this.lastTxAt = System.currentTimeMillis();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        while (this.connected && this.link != null) {
            long now = System.currentTimeMillis();
            try {
                if (!this.sabmComplete) {
                    if (now - this.lastSABMAt < 7000L && this.lastTxAge() > 2000L) {
                        JSONObject jPacket = new JSONObject();
                        jPacket.put("source", this.linkCallsign);
                        jPacket.put("destination", this.remoteCallsign);
                        JSONArray respCtrl = new JSONArray();
                        respCtrl.put("UA");
                        respCtrl.put("F");
                        respCtrl.put("R");
                        jPacket.put("control", respCtrl);
                        AX25Packet pr = new AX25Packet(jPacket);
                        this.transmit(pr);
                    } else {
                        this.sabmComplete = true;
                        this.remoteReceiveReady = true;
                        this.sendFromQueue();
                    }
                } else {
                    if (!this.remoteReceiveReady) {
                        if (this.pendingPacket[this.txModulus] != null && this.lastTxAge() > 10000L) {
                            this.transmit(this.pendingPacket[this.txModulus]);
                            ++this.txRetryCount;
                        }
                        if (this.txRetryCount >= 3) {
                            this.disconnect();
                            JavaKISSMain.mainLog("[TERMINAL ERROR] Tried to transmit 4x with no response, disconnecting");
                        }
                    }
                    if (this.lastRxAge() > 300000L) {
                        this.disconnect();
                        JavaKISSMain.mainLog("[TERMINAL ERROR] IDLE for 5m, disconnecting");
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }
}

