/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.sound;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import net.sourceforge.lame.lowlevel.LameEncoder;
import net.sourceforge.lame.mp3.MPEGMode;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.kiss.JavaKISSMain;
import org.openstatic.sound.MixerStream;
import org.openstatic.sound.MixerStreamListener;
import org.openstatic.sound.dtmf.DTMFUtil;

public class MixerStreamProcess
implements Runnable,
MixerStream {
    private ProcessBuilder processBuilder;
    private ProcessBuilder playExecuteProcessBuilder;
    private ProcessBuilder stopExecuteProcessBuilder;
    private ProcessBuilder startExecuteProcessBuilder;
    private ProcessBuilder pttExecuteProcessBuilder;
    private Process process;
    private Process playbackProcess;
    private ArrayList<OutputStream> outputMp3;
    private ArrayList<OutputStream> outputRaw;
    private ArrayList<MixerStream> outputMixerStreams;
    private Thread myThread;
    private ArrayList<MixerStreamListener> listeners;
    private double rms;
    private boolean silence;
    private boolean longSilence;
    private boolean userStop;
    private long silenceStartAt;
    private JSONObject mixerSettings;
    private File recordingFile;
    private FileOutputStream recordingOutputStream;
    private long recordingStart;
    private OutputStream processOutputStream;
    private OutputStream playbackExecOutputStream;
    private InputStream processInputStream;
    private AudioFormat format;
    private String execString;
    private String playExecString;
    private String stopExecString;
    private String startExecString;
    private String pttExecString;
    private DTMFUtil dtmfUtil;
    private char lastDTMF;
    private String dtmfSequence;
    private long lastDTMFToneAt;
    private boolean ptt;

    public MixerStreamProcess(JSONObject mixerSettings) {
        this.mixerSettings = mixerSettings;
        this.silenceStartAt = System.currentTimeMillis();
        this.silence = true;
        this.userStop = false;
        this.longSilence = true;
        this.ptt = false;
        this.outputMp3 = new ArrayList();
        this.outputRaw = new ArrayList();
        this.outputMixerStreams = new ArrayList();
        this.listeners = new ArrayList();
        this.rebuild();
    }

    @Override
    public float getSampleRate() {
        return this.format.getSampleRate();
    }

    public String frequencyLong(String frequency) {
        if (frequency.endsWith("M")) {
            BigDecimal million;
            BigDecimal v = new BigDecimal(frequency.substring(0, frequency.length() - 1));
            String rv = v.multiply(million = new BigDecimal("1000000")).toPlainString();
            if (rv.endsWith(".00")) {
                rv = rv.substring(0, rv.length() - 3);
            }
            return rv;
        }
        if (frequency.endsWith("K")) {
            BigDecimal thousand;
            BigDecimal v = new BigDecimal(frequency.substring(0, frequency.length() - 1));
            String rv = v.multiply(thousand = new BigDecimal("1000")).toPlainString();
            if (rv.endsWith(".00")) {
                rv = rv.substring(0, rv.length() - 3);
            }
            return rv;
        }
        return frequency;
    }

    @Override
    public int getNumChannels() {
        return this.format.getChannels();
    }

    public void rebuild() {
        Set<String> keySet;
        String cs;
        int i;
        ArrayList<String> commandArray;
        JSONArray command;
        this.format = new AudioFormat(this.mixerSettings.optFloat("sampleRate", 44100.0f), this.mixerSettings.optInt("sampleSizeInBits", 16), this.mixerSettings.optInt("channels", 1), this.mixerSettings.optBoolean("signed", true), this.mixerSettings.optBoolean("bigEndian", false));
        this.dtmfUtil = new DTMFUtil(this);
        this.lastDTMF = (char)95;
        this.dtmfSequence = "";
        if (this.mixerSettings.has("execute")) {
            command = this.mixerSettings.optJSONArray("execute");
            commandArray = new ArrayList<String>();
            for (i = 0; i < command.length(); ++i) {
                cs = command.getString(i);
                keySet = this.mixerSettings.keySet();
                for (String key : keySet) {
                    cs = cs.replaceAll(Pattern.quote("{{" + key + "}}"), this.mixerSettings.get(key).toString());
                }
                if (this.mixerSettings.has("frequency")) {
                    cs = cs.replaceAll(Pattern.quote("{{frequency.long}}"), this.frequencyLong(this.mixerSettings.get("frequency").toString()));
                }
                commandArray.add(cs);
            }
            this.execString = commandArray.stream().collect(Collectors.joining(" "));
            this.processBuilder = new ProcessBuilder(commandArray);
        }
        if (this.mixerSettings.has("playExecute")) {
            command = this.mixerSettings.optJSONArray("playExecute");
            commandArray = new ArrayList();
            for (i = 0; i < command.length(); ++i) {
                cs = command.getString(i);
                keySet = this.mixerSettings.keySet();
                for (String key : keySet) {
                    cs = cs.replaceAll(Pattern.quote("{{" + key + "}}"), this.mixerSettings.get(key).toString());
                }
                if (this.mixerSettings.has("frequency")) {
                    cs = cs.replaceAll(Pattern.quote("{{frequency.long}}"), this.frequencyLong(this.mixerSettings.get("frequency").toString()));
                }
                commandArray.add(cs);
            }
            this.playExecString = commandArray.stream().collect(Collectors.joining(" "));
            this.playExecuteProcessBuilder = new ProcessBuilder(commandArray);
        } else {
            this.playExecuteProcessBuilder = null;
            this.playExecString = null;
        }
        if (this.mixerSettings.has("stopExecute")) {
            command = this.mixerSettings.optJSONArray("stopExecute");
            commandArray = new ArrayList();
            for (i = 0; i < command.length(); ++i) {
                cs = command.getString(i);
                keySet = this.mixerSettings.keySet();
                for (String key : keySet) {
                    cs = cs.replaceAll(Pattern.quote("{{" + key + "}}"), this.mixerSettings.get(key).toString());
                }
                if (this.mixerSettings.has("frequency")) {
                    cs = cs.replaceAll(Pattern.quote("{{frequency.long}}"), this.frequencyLong(this.mixerSettings.get("frequency").toString()));
                }
                commandArray.add(cs);
            }
            this.stopExecString = commandArray.stream().collect(Collectors.joining(" "));
            this.stopExecuteProcessBuilder = new ProcessBuilder(commandArray);
        } else {
            this.stopExecuteProcessBuilder = null;
            this.stopExecString = null;
        }
        if (this.mixerSettings.has("startExecute")) {
            command = this.mixerSettings.optJSONArray("startExecute");
            commandArray = new ArrayList();
            for (i = 0; i < command.length(); ++i) {
                cs = command.getString(i);
                keySet = this.mixerSettings.keySet();
                for (String key : keySet) {
                    cs = cs.replaceAll(Pattern.quote("{{" + key + "}}"), this.mixerSettings.get(key).toString());
                }
                if (this.mixerSettings.has("frequency")) {
                    cs = cs.replaceAll(Pattern.quote("{{frequency.long}}"), this.frequencyLong(this.mixerSettings.get("frequency").toString()));
                }
                commandArray.add(cs);
            }
            this.startExecString = commandArray.stream().collect(Collectors.joining(" "));
            this.startExecuteProcessBuilder = new ProcessBuilder(commandArray);
        } else {
            this.startExecuteProcessBuilder = null;
            this.startExecString = null;
        }
        if (this.mixerSettings.has("pttExecute")) {
            command = this.mixerSettings.optJSONArray("pttExecute");
            commandArray = new ArrayList();
            for (i = 0; i < command.length(); ++i) {
                cs = command.getString(i);
                keySet = this.mixerSettings.keySet();
                for (String key : keySet) {
                    cs = cs.replaceAll(Pattern.quote("{{" + key + "}}"), this.mixerSettings.get(key).toString());
                }
                if (this.mixerSettings.has("frequency")) {
                    cs = cs.replaceAll(Pattern.quote("{{frequency.long}}"), this.frequencyLong(this.mixerSettings.get("frequency").toString()));
                }
                commandArray.add(cs);
            }
            this.pttExecString = commandArray.stream().collect(Collectors.joining(" "));
            this.pttExecuteProcessBuilder = new ProcessBuilder(commandArray);
        } else {
            this.pttExecuteProcessBuilder = null;
            this.pttExecString = null;
        }
    }

    @Override
    public void start() {
        if (!this.isAlive()) {
            this.rebuild();
            if (this.startExecuteProcessBuilder != null && this.mixerSettings.optBoolean("startExecuteEnabled", true)) {
                try {
                    JavaKISSMain.mainLog("[START EXECUTE] " + this.getMixerName() + " (" + this.startExecString + ")");
                    Process startExecProc = this.startExecuteProcessBuilder.start();
                    startExecProc.waitFor();
                    JavaKISSMain.mainLog("[START EXECUTE TERMINATED] " + this.getMixerName() + " (" + this.startExecString + ")");
                }
                catch (Exception startExecProc) {
                    // empty catch block
                }
            }
            try {
                this.format = new AudioFormat(this.mixerSettings.optFloat("sampleRate", 44100.0f), this.mixerSettings.optInt("sampleSizeInBits", 16), this.mixerSettings.optInt("channels", 1), this.mixerSettings.optBoolean("signed", true), this.mixerSettings.optBoolean("bigEndian", false));
                this.process = this.processBuilder.start();
                this.processInputStream = this.process.getInputStream();
                this.processOutputStream = this.process.getOutputStream();
                this.myThread = new Thread(this);
                this.myThread.setPriority(10);
                this.myThread.start();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void stop() {
        this.userStop = true;
        if (this.processInputStream != null) {
            try {
                this.processInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.processOutputStream != null) {
            try {
                this.processOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.silence = true;
        if (!this.longSilence) {
            this.longSilence = true;
            this.fireLongSilence();
        }
        if (this.process != null) {
            this.process.destroy();
        }
        if (this.stopExecuteProcessBuilder != null) {
            Thread t = new Thread(() -> {
                try {
                    Thread.sleep(1000L);
                    JavaKISSMain.mainLog("[STOP EXECUTE] " + this.getMixerName() + " (" + this.stopExecString + ")");
                    Process stopExecProc = this.stopExecuteProcessBuilder.start();
                    stopExecProc.waitFor();
                    JavaKISSMain.mainLog("[STOP EXECUTE TERMINATED] " + this.getMixerName() + " (" + this.stopExecString + ")");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            t.start();
        }
    }

    @Override
    public JSONObject getMixerSettings() {
        return this.mixerSettings;
    }

    @Override
    public String getMixerName() {
        return this.mixerSettings.optString("name", "UNKNOWN");
    }

    public double getRMS() {
        return this.rms;
    }

    @Override
    public void addMixerStreamListener(MixerStreamListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    @Override
    public void addMP3TargetStream(OutputStream os) {
        if (!this.outputMp3.contains(os)) {
            this.outputMp3.add(os);
        }
    }

    @Override
    public void addRawTargetStream(OutputStream os) {
        if (!this.outputRaw.contains(os)) {
            this.outputRaw.add(os);
        }
    }

    @Override
    public void removeRawTargetStream(OutputStream os) {
        if (this.outputRaw.contains(os)) {
            this.outputRaw.remove(os);
        }
    }

    @Override
    public void addTargetMixerStream(MixerStream ms) {
        if (!this.outputMixerStreams.contains(ms)) {
            this.outputMixerStreams.add(ms);
        }
    }

    @Override
    public void removeTargetMixerStream(MixerStream ms) {
        if (this.outputMixerStreams.contains(ms)) {
            this.outputMixerStreams.remove(ms);
        }
    }

    @Override
    public Collection<MixerStream> getTargetMixerStreams() {
        return this.outputMixerStreams;
    }

    @Override
    public boolean isAlive() {
        if (this.myThread != null) {
            return this.myThread.isAlive();
        }
        return false;
    }

    private void rmsEvents() {
        if (this.rms < this.mixerSettings.optDouble("rmsActivation", 0.05)) {
            if (!this.silence) {
                this.silence = true;
                this.silenceStartAt = System.currentTimeMillis();
            }
        } else if (this.silence) {
            this.silence = false;
        }
        if (this.silence && !this.longSilence) {
            if (System.currentTimeMillis() - this.silenceStartAt > this.mixerSettings.optLong("silenceTimeout", 5000L)) {
                this.longSilence = true;
                this.fireLongSilence();
            }
        } else if (!this.silence && this.longSilence) {
            this.longSilence = false;
            this.fireSilenceBroken();
        }
    }

    public static double calcRMS(byte[] data, int numBytesRead) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        short[] shorts = new short[data.length / 2];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get(shorts);
        byteArrayOutputStream.write(data, 0, numBytesRead);
        double rms = 0.0;
        for (int i = 0; i < shorts.length; ++i) {
            double normal = (float)shorts[i] / 32768.0f;
            rms += normal * normal;
        }
        rms = Math.sqrt(rms / (double)shorts.length);
        return rms;
    }

    public void setAutoRecord(boolean v) {
        this.mixerSettings.put("autoRecord", v);
    }

    private void fireLongSilence() {
        if (this.mixerSettings.optBoolean("logAudio", true)) {
            JavaKISSMain.mainLog("[RADIO SILENCE] " + this.getMixerName());
        }
        this.outputMixerStreams.forEach(ms -> ms.setPTT(false));
        Thread t = new Thread(() -> {
            if (this.recordingOutputStream != null) {
                try {
                    this.recordingOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long recordingDuration = System.currentTimeMillis() - this.recordingStart;
                if (recordingDuration >= this.mixerSettings.optLong("minimumRecordDuration", 500L)) {
                    this.listeners.forEach(l -> l.onRecording(this, recordingDuration, this.recordingFile));
                } else {
                    try {
                        this.recordingFile.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.recordingFile = null;
                this.recordingOutputStream = null;
                this.recordingStart = 0L;
                this.listeners.forEach(l -> l.onSilence(this));
            }
        });
        t.start();
    }

    private void fireSilenceBroken() {
        if (this.mixerSettings.optBoolean("logAudio", true)) {
            JavaKISSMain.mainLog("[INCOMING AUDIO] " + this.getMixerName());
        }
        this.outputMixerStreams.forEach(ms -> ms.setPTT(true));
        Thread t = new Thread(() -> {
            if (this.mixerSettings.optBoolean("autoRecord", false) && JavaKISSMain.logsFolder != null) {
                SimpleDateFormat simpleDateStringFormat;
                String dateString;
                File dateFolder;
                Date nowDate = new Date(System.currentTimeMillis());
                File mixerFolder = new File(JavaKISSMain.logsFolder, this.getMixerName());
                if (!mixerFolder.exists()) {
                    mixerFolder.mkdir();
                }
                if (!(dateFolder = new File(mixerFolder, dateString = (simpleDateStringFormat = new SimpleDateFormat("yyyy-MM-dd")).format(nowDate))).exists()) {
                    dateFolder.mkdir();
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HHmmss");
                String mp3Name = (String)(this.mixerSettings.has("frequency") ? this.mixerSettings.optString("frequency") + " - " : "") + simpleDateFormat.format(nowDate) + ".mp3";
                this.recordingFile = new File(dateFolder, mp3Name);
                try {
                    this.recordingOutputStream = new FileOutputStream(this.recordingFile);
                    this.recordingStart = System.currentTimeMillis();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.listeners.forEach(l -> l.onAudioInput(this));
        });
        t.start();
    }

    private void fireDTMF(char dtmf) {
        Thread t = new Thread(() -> this.listeners.forEach(l -> l.onDTMF(this, dtmf)));
        t.start();
    }

    private void fireDTMFSequence(String dtmfSequence) {
        Thread t = new Thread(() -> this.listeners.forEach(l -> l.onDTMFSequence(this, dtmfSequence)));
        t.start();
    }

    private void dtmfEvents(byte[] rawInputBuffer) {
        if (!this.longSilence) {
            char dtmfChar = this.dtmfUtil.decodeNextFrameMono(rawInputBuffer);
            if (dtmfChar != '_' && dtmfChar != this.lastDTMF) {
                this.fireDTMF(dtmfChar);
                this.dtmfSequence = this.dtmfSequence + dtmfChar;
                this.lastDTMFToneAt = System.currentTimeMillis();
            }
            this.lastDTMF = dtmfChar;
        }
        if (System.currentTimeMillis() - this.lastDTMFToneAt > this.mixerSettings.optLong("dtmfTimeout", 5000L) && !this.dtmfSequence.equals("")) {
            this.fireDTMFSequence(this.dtmfSequence);
            this.dtmfSequence = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.userStop = false;
        try {
            this.listeners.forEach(l -> l.onStartup(this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        JavaKISSMain.mainLog("[AUDIO MIXER ACTIVATED] " + this.getMixerName() + " (" + this.execString + ")");
        AudioInputStream audioInputStream = new AudioInputStream(this.processInputStream, this.format, -1L);
        try {
            boolean USE_VARIABLE_BITRATE = false;
            int GOOD_QUALITY_BITRATE = 128;
            LameEncoder encoder = new LameEncoder(audioInputStream.getFormat(), GOOD_QUALITY_BITRATE, MPEGMode.MONO, 1, USE_VARIABLE_BITRATE);
            int pcmBuffSize = 8192;
            byte[] rawInputBuffer = new byte[pcmBuffSize];
            byte[] mp3OutputBuffer = new byte[pcmBuffSize];
            while (this.process.isAlive()) {
                if (audioInputStream.available() > 128) {
                    int bytesRead = audioInputStream.read(rawInputBuffer);
                    this.rms = MixerStreamProcess.calcRMS(rawInputBuffer, bytesRead);
                    if (this.ptt) {
                        this.rms = 0.0;
                    }
                    this.rmsEvents();
                    if (this.ptt) continue;
                    if (this.mixerSettings.optBoolean("dtmf", false)) {
                        this.dtmfEvents(rawInputBuffer);
                    }
                    int bytesWritten = encoder.encodeBuffer(rawInputBuffer, 0, bytesRead, mp3OutputBuffer);
                    for (OutputStream outputMp3Stream : (ArrayList)this.outputMp3.clone()) {
                        try {
                            outputMp3Stream.write(mp3OutputBuffer, 0, bytesWritten);
                        }
                        catch (Exception e) {
                            this.outputMp3.remove(outputMp3Stream);
                        }
                    }
                    if (this.recordingOutputStream != null) {
                        try {
                            this.recordingOutputStream.write(mp3OutputBuffer, 0, bytesWritten);
                        }
                        catch (Exception e) {
                            this.recordingFile = null;
                            this.recordingOutputStream = null;
                        }
                    }
                    for (OutputStream outputRawStream : (ArrayList)this.outputRaw.clone()) {
                        try {
                            outputRawStream.write(rawInputBuffer);
                        }
                        catch (Exception e) {
                            this.outputRaw.remove(outputRawStream);
                        }
                    }
                    if (this.longSilence) continue;
                    for (MixerStream outputMixerStream : (ArrayList)this.outputMixerStreams.clone()) {
                        try {
                            outputMixerStream.getOutputStream().write(rawInputBuffer);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            this.outputMixerStreams.remove(outputMixerStream);
                        }
                    }
                    continue;
                }
                this.rms = 0.0;
                this.rmsEvents();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            encoder.close();
        }
        catch (IOException USE_VARIABLE_BITRATE) {
        }
        finally {
            try {
                this.processInputStream.close();
                this.processOutputStream.close();
            }
            catch (Exception USE_VARIABLE_BITRATE) {}
        }
        try {
            this.listeners.forEach(l -> l.onShutdown(this));
        }
        catch (Exception USE_VARIABLE_BITRATE) {
            // empty catch block
        }
        JavaKISSMain.mainLog("[AUDIO MIXER DEACTIVATED] " + this.getMixerName() + " (" + this.execString + ")");
        if (!this.userStop && this.mixerSettings.optBoolean("autoRestart", true)) {
            Thread x = new Thread(() -> {
                try {
                    Thread.sleep(this.mixerSettings.optLong("autoRestartDelay", 10000L));
                    this.start();
                    JavaKISSMain.mainLog("[AUDIO MIXER AUTO-RESTART] " + this.getMixerName() + " (" + this.execString + ")");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            x.start();
        }
    }

    @Override
    public void removeMixerStreamListener(MixerStreamListener l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
        }
    }

    @Override
    public boolean canBeRecorded() {
        return this.mixerSettings.optBoolean("canBeRecorded", false);
    }

    @Override
    public boolean canPlayTo() {
        return this.mixerSettings.optBoolean("canPlayTo", false);
    }

    @Override
    public void restart() {
        Thread t = new Thread(() -> {
            try {
                this.stop();
                Thread.sleep(2000L);
                this.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        t.start();
    }

    @Override
    public void setPTT(boolean v) {
        String pttType;
        JSONObject pttObject;
        this.ptt = v;
        if (v) {
            JavaKISSMain.mainLog("[PTT PRESSED] " + this.getMixerName());
            if (this.pttExecuteProcessBuilder != null) {
                try {
                    JavaKISSMain.mainLog("[PTT EXECUTE] " + this.getMixerName() + " (" + this.pttExecString + ")");
                    Process pttProcess = this.pttExecuteProcessBuilder.start();
                    pttProcess.waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
            if (this.playExecuteProcessBuilder != null && this.playbackProcess == null && this.playbackExecOutputStream == null) {
                try {
                    JavaKISSMain.mainLog("[PLAYBACK EXECUTE] " + this.getMixerName() + " (" + this.playExecString + ")");
                    this.playbackProcess = this.playExecuteProcessBuilder.start();
                    this.playbackExecOutputStream = this.playbackProcess.getOutputStream();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        } else {
            JavaKISSMain.mainLog("[PTT RELEASED] " + this.getMixerName());
            if (this.playbackExecOutputStream != null) {
                try {
                    this.playbackExecOutputStream.flush();
                    this.playbackExecOutputStream.close();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                this.playbackExecOutputStream = null;
            }
            if (this.playbackProcess != null) {
                try {
                    this.playbackProcess.waitFor();
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                JavaKISSMain.mainLog("[PLAYBACK EXECUTE TERMINATED] " + this.getMixerName() + " (" + this.playExecString + ")");
                this.playbackProcess = null;
            }
        }
        if (this.mixerSettings.has("ptt") && (pttObject = this.mixerSettings.optJSONObject("ptt")) != null && pttObject.has("type") && (pttType = pttObject.optString("type", "")).equals("rts") && pttObject.has("serialPort")) {
            String serialPort = pttObject.optString("serialPort");
            JavaKISSMain.serialSystem.setRTS(serialPort, v);
        }
    }

    @Override
    public void play(byte[] clipData) {
        if (this.canPlayTo()) {
            Thread t = new Thread(() -> {
                try {
                    JavaKISSMain.mainLog("[PLAYBACK STARTED] " + this.getMixerName());
                    ByteArrayInputStream bais = new ByteArrayInputStream(clipData);
                    AudioFormat aff = AudioSystem.getAudioFileFormat(bais).getFormat();
                    bais.reset();
                    AudioInputStream fAIS = new AudioInputStream(bais, aff, -1L);
                    AudioInputStream ais = AudioSystem.getAudioInputStream(this.format, fAIS);
                    this.setPTT(true);
                    if (this.playbackExecOutputStream != null) {
                        ais.transferTo(this.playbackExecOutputStream);
                    } else {
                        ais.transferTo(this.processOutputStream);
                    }
                    ais.close();
                    JavaKISSMain.mainLog("[PLAYBACK ENDED] " + this.getMixerName());
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
                this.setPTT(false);
            });
            t.start();
        }
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.playbackExecOutputStream != null) {
            return this.playbackExecOutputStream;
        }
        return this.processOutputStream;
    }
}

