/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.sound;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.kiss.JavaKISSMain;
import org.openstatic.sound.PlaybackCompleteListener;
import org.openstatic.sound.RadioOutput;

public class RadioOutputProcess
implements RadioOutput {
    private ProcessBuilder playExecuteProcessBuilder;
    private ProcessBuilder pttExecuteProcessBuilder;
    private Process playbackProcess;
    private Thread myThread;
    private boolean userStop;
    private ArrayList<PlaybackCompleteListener> listeners;
    private JSONObject mixerSettings;
    private OutputStream playbackExecOutputStream;
    private AudioFormat format;
    private String playExecString;

    public RadioOutputProcess(JSONObject mixerSettings) {
        this.mixerSettings = mixerSettings;
        this.userStop = false;
        this.listeners = new ArrayList();
        this.rebuild();
    }

    @Override
    public float getSampleRate() {
        return this.format.getSampleRate();
    }

    public String frequencyLong(String frequency) {
        if (frequency.endsWith("M")) {
            BigDecimal million;
            BigDecimal v = new BigDecimal(frequency.substring(0, frequency.length() - 1));
            String rv = v.multiply(million = new BigDecimal("1000000")).toPlainString();
            if (rv.endsWith(".00")) {
                rv = rv.substring(0, rv.length() - 3);
            }
            return rv;
        }
        if (frequency.endsWith("K")) {
            BigDecimal thousand;
            BigDecimal v = new BigDecimal(frequency.substring(0, frequency.length() - 1));
            String rv = v.multiply(thousand = new BigDecimal("1000")).toPlainString();
            if (rv.endsWith(".00")) {
                rv = rv.substring(0, rv.length() - 3);
            }
            return rv;
        }
        return frequency;
    }

    @Override
    public int getNumChannels() {
        return this.format.getChannels();
    }

    public void rebuild() {
        this.format = new AudioFormat(this.mixerSettings.optFloat("sampleRate", 44100.0f), this.mixerSettings.optInt("sampleSizeInBits", 16), this.mixerSettings.optInt("channels", 1), this.mixerSettings.optBoolean("signed", true), this.mixerSettings.optBoolean("bigEndian", false));
        if (this.mixerSettings.has("playExecute")) {
            JSONArray command = this.mixerSettings.optJSONArray("playExecute");
            ArrayList<String> commandArray = new ArrayList<String>();
            for (int i = 0; i < command.length(); ++i) {
                String cs = command.getString(i);
                Set<String> keySet = this.mixerSettings.keySet();
                for (String key : keySet) {
                    cs = cs.replaceAll(Pattern.quote("{{" + key + "}}"), this.mixerSettings.get(key).toString());
                }
                if (this.mixerSettings.has("frequency")) {
                    cs = cs.replaceAll(Pattern.quote("{{frequency.long}}"), this.frequencyLong(this.mixerSettings.get("frequency").toString()));
                }
                commandArray.add(cs);
            }
            this.playExecString = commandArray.stream().collect(Collectors.joining(" "));
            this.playExecuteProcessBuilder = new ProcessBuilder(commandArray);
        } else {
            this.playExecuteProcessBuilder = null;
            this.playExecString = null;
        }
    }

    @Override
    public void start() {
        if (!this.isAlive()) {
            this.rebuild();
            try {
                this.format = new AudioFormat(this.mixerSettings.optFloat("sampleRate", 44100.0f), this.mixerSettings.optInt("sampleSizeInBits", 16), this.mixerSettings.optInt("channels", 1), this.mixerSettings.optBoolean("signed", true), this.mixerSettings.optBoolean("bigEndian", false));
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void stop() {
        this.userStop = true;
    }

    @Override
    public JSONObject getMixerSettings() {
        return this.mixerSettings;
    }

    @Override
    public String getMixerName() {
        return this.mixerSettings.optString("name", "UNKNOWN");
    }

    @Override
    public boolean isAlive() {
        if (this.myThread != null) {
            return this.myThread.isAlive();
        }
        return false;
    }

    @Override
    public void play(byte[] clipData) {
        this.myThread = new Thread(() -> {
            try {
                JavaKISSMain.mainLog("[PLAYBACK STARTED] " + this.getMixerName());
                ByteArrayInputStream bais = new ByteArrayInputStream(clipData);
                AudioFormat aff = AudioSystem.getAudioFileFormat(bais).getFormat();
                bais.reset();
                AudioInputStream fAIS = new AudioInputStream(bais, aff, -1L);
                AudioInputStream ais = AudioSystem.getAudioInputStream(this.format, fAIS);
                this.listeners.forEach(l -> l.onPlaybackStarted(this));
                if (this.playbackExecOutputStream != null) {
                    ais.transferTo(this.playbackExecOutputStream);
                }
                ais.close();
                JavaKISSMain.mainLog("[PLAYBACK ENDED] " + this.getMixerName());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            this.listeners.forEach(l -> l.onPlaybackComplete(this));
        });
        this.myThread.start();
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.playExecuteProcessBuilder != null && this.playbackProcess == null && this.playbackExecOutputStream == null) {
            try {
                JavaKISSMain.mainLog("[PLAYBACK EXECUTE] " + this.getMixerName() + " (" + this.playExecString + ")");
                this.playbackProcess = this.playExecuteProcessBuilder.start();
                this.playbackExecOutputStream = this.playbackProcess.getOutputStream();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return this.playbackExecOutputStream;
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public void addPlaybackCompleteListener(PlaybackCompleteListener pcl) {
        if (!this.listeners.contains(pcl)) {
            this.listeners.add(pcl);
        }
    }

    @Override
    public void removePlaybackCompleteListener(PlaybackCompleteListener pcl) {
        if (this.listeners.contains(pcl)) {
            this.listeners.remove(pcl);
        }
    }
}

