/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.sound;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openstatic.kiss.JavaKISSMain;
import org.openstatic.sound.MixerStream;
import org.openstatic.sound.MixerStreamHardware;
import org.openstatic.sound.MixerStreamListener;
import org.openstatic.sound.MixerStreamProcess;

public class SoundSystem {
    public ArrayList<MixerStream> availableMixerStreams;
    private ArrayList<MixerStream> allMixerStreams;
    private HashMap<Mixer.Info, MixerStreamHardware> mixerHardwareStreams;
    private HashMap<String, MixerStreamProcess> mixerProcessStreams;
    private JSONObject audioSettings = JavaKISSMain.settings.optJSONObject("audio", new JSONObject());

    public SoundSystem() {
        this.mixerHardwareStreams = new HashMap();
        this.mixerProcessStreams = new HashMap();
        this.refreshMixers();
        this.availableMixerStreams.forEach(mixerStream -> {
            JSONObject mixerStreamSettings = mixerStream.getMixerSettings();
            if (mixerStreamSettings.optBoolean("autoStart", false) && !mixerStream.isAlive()) {
                mixerStream.start();
            }
        });
    }

    public void refreshMixers() {
        Mixer.Info[] mixers;
        this.allMixerStreams = new ArrayList();
        this.availableMixerStreams = new ArrayList();
        boolean hideUndefined = this.audioSettings.optBoolean("hideUndefined", false);
        HashMap definedDevices = new HashMap();
        if (this.audioSettings.has("devices")) {
            JSONArray devices = this.audioSettings.getJSONArray("devices");
            devices.forEach(dsn -> {
                JSONObject jo = (JSONObject)dsn;
                if (jo.has("hardwareName") && jo.optString("type", "").equals("hardware")) {
                    definedDevices.put(jo.optString("hardwareName"), jo);
                }
            });
        }
        for (Mixer.Info mixerInfo : mixers = AudioSystem.getMixerInfo()) {
            String mixerHardwareName = mixerInfo.getName();
            try {
                boolean defined = false;
                JSONObject mSettings = new JSONObject();
                mSettings.put("name", mixerHardwareName);
                mSettings.put("type", "hardware");
                mSettings.put("hardwareName", mixerHardwareName);
                mSettings.put("dtmf", false);
                mSettings.put("disabled", false);
                mSettings.put("autoRecord", false);
                mSettings.put("autoStart", false);
                mSettings.put("silenceTimeout", 5000);
                mSettings.put("sampleRate", 44100);
                for (String key : definedDevices.keySet()) {
                    if (!mixerHardwareName.contains(key)) continue;
                    mSettings = (JSONObject)definedDevices.get(key);
                    defined = true;
                }
                MixerStreamHardware mixerStreamHardware = this.mixerHardwareStreams.get(mixerInfo);
                if (mixerStreamHardware == null) {
                    mixerStreamHardware = new MixerStreamHardware(mixerInfo, mSettings);
                    this.mixerHardwareStreams.put(mixerInfo, mixerStreamHardware);
                }
                if (!mixerStreamHardware.canBeRecorded() && !mixerStreamHardware.canPlayTo()) continue;
                if (!(mSettings.optBoolean("disabled", false) || hideUndefined && !defined)) {
                    this.availableMixerStreams.add(mixerStreamHardware);
                }
                if (hideUndefined && !defined) continue;
                this.allMixerStreams.add(mixerStreamHardware);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        JSONArray devices = this.audioSettings.optJSONArray("devices");
        if (devices != null) {
            devices.forEach(dsn -> {
                JSONObject jo = (JSONObject)dsn;
                if (jo.has("name") && jo.has("execute") && jo.optString("type", "").equals("process")) {
                    String mxName = jo.optString("name");
                    MixerStreamProcess msp = this.mixerProcessStreams.get(mxName);
                    if (msp == null) {
                        msp = new MixerStreamProcess(jo);
                        this.mixerProcessStreams.put(mxName, msp);
                    }
                    if (!jo.optBoolean("disabled", false)) {
                        this.availableMixerStreams.add(msp);
                    }
                    this.allMixerStreams.add(msp);
                }
            });
        }
    }

    public ArrayList<MixerStream> getAvailableMixerStreams() {
        return this.availableMixerStreams;
    }

    public JSONArray getAvailableDevices() {
        JSONArray ra = new JSONArray();
        for (MixerStream mixer : this.availableMixerStreams) {
            ra.put(mixer.getMixerName());
        }
        return ra;
    }

    public JSONObject getAvailableStates() {
        JSONObject ro = new JSONObject();
        for (MixerStream mixer : this.availableMixerStreams) {
            JSONObject stateObject = new JSONObject();
            stateObject.put("settings", mixer.getMixerSettings());
            stateObject.put("isAlive", mixer.isAlive());
            stateObject.put("canBeRecorded", mixer.canBeRecorded());
            stateObject.put("canPlayTo", mixer.canPlayTo());
            JSONArray targetsArray = new JSONArray();
            mixer.getTargetMixerStreams().forEach(ms -> targetsArray.put(ms.getMixerName()));
            stateObject.put("targets", targetsArray);
            ro.put(mixer.getMixerName(), stateObject);
        }
        return ro;
    }

    public JSONObject getAudioSettings() {
        JSONArray devices = new JSONArray();
        for (MixerStream mixerStream : this.allMixerStreams) {
            devices.put(mixerStream.getMixerSettings());
        }
        this.audioSettings.put("devices", devices);
        return this.audioSettings;
    }

    public void shutdown() {
        this.mixerHardwareStreams.forEach((k, v) -> {
            if (v.isAlive()) {
                v.stop();
            }
        });
        this.mixerProcessStreams.forEach((k, v) -> {
            if (v.isAlive()) {
                v.stop();
            }
        });
    }

    public void stopMixer(int devId) {
        MixerStream mixerStream = this.availableMixerStreams.get(devId);
        if (mixerStream != null) {
            mixerStream.stop();
        }
    }

    public void startMixer(int devId) {
        MixerStream mixerStream = this.availableMixerStreams.get(devId);
        if (mixerStream != null) {
            mixerStream.start();
        }
    }

    public int getMixerId(MixerStream ms) {
        return this.availableMixerStreams.indexOf(ms);
    }

    public MixerStream getMixer(int devId) {
        return this.availableMixerStreams.get(devId);
    }

    public void openRecordingDeviceAndWriteTo(int devId, HttpServletRequest request, HttpServletResponse httpServletResponse) throws IOException {
        httpServletResponse.setContentType("audio/mpeg");
        httpServletResponse.setStatus(200);
        final AsyncContext asyncContext = request.startAsync();
        ServletOutputStream out = httpServletResponse.getOutputStream();
        try {
            MixerStream mixerStream = this.availableMixerStreams.get(devId);
            if (!mixerStream.isAlive()) {
                mixerStream.start();
            }
            mixerStream.addMP3TargetStream(out);
            mixerStream.addMixerStreamListener(new MixerStreamListener(){

                @Override
                public void onAudioInput(MixerStream mixerStream) {
                }

                @Override
                public void onSilence(MixerStream mixerStream) {
                }

                @Override
                public void onShutdown(MixerStream mixerStream) {
                    asyncContext.complete();
                    mixerStream.removeMixerStreamListener(this);
                }

                @Override
                public void onDTMF(MixerStream mixerStream, char dtmf) {
                }

                @Override
                public void onStartup(MixerStream mixerStream) {
                }

                @Override
                public void onDTMFSequence(MixerStream mixerStream, String dtmfSequence) {
                }

                @Override
                public void onRecording(MixerStream mixerStream, long recordingDuration, File recordingFile) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }
}

