/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.sound;

import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.SourceDataLine;

public class SourceDataLineOutputStream
extends OutputStream {
    private SourceDataLine sourceDataLine;

    public SourceDataLineOutputStream(SourceDataLine sourceDataLine) {
        this.sourceDataLine = sourceDataLine;
    }

    public SourceDataLine getSourceDataLine() {
        return this.sourceDataLine;
    }

    public boolean isAlive() {
        return this.sourceDataLine != null && this.sourceDataLine.isRunning();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.sourceDataLine != null) {
            if (!this.sourceDataLine.isOpen()) {
                throw new IOException("Cannot write, sourceDataLine is dead!");
            }
        } else {
            throw new IOException("Cannot write, no sourceDataLine!");
        }
        int n = this.sourceDataLine.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.sourceDataLine != null) {
            if (!this.sourceDataLine.isOpen()) {
                throw new IOException("Cannot write, sourceDataLine is dead!");
            }
        } else {
            throw new IOException("Cannot write, no sourceDataLine!");
        }
        int n = this.sourceDataLine.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Cannot write single bytes to this stream!");
    }

    @Override
    public void flush() {
        if (this.sourceDataLine != null) {
            this.sourceDataLine.flush();
        }
    }
}

