/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.sound.dtmf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.transform.DftNormalization;
import org.apache.commons.math3.transform.FastFourierTransformer;
import org.apache.commons.math3.transform.TransformType;
import org.openstatic.sound.MixerStream;
import org.openstatic.sound.dtmf.DTMFDecoderException;
import org.openstatic.sound.dtmf.DecoderUtil;
import org.openstatic.sound.dtmf.GoertzelOptimised;

public class DTMFUtil {
    public static boolean debug = false;
    public static boolean goertzel = true;
    private static final double CUT_OFF_POWER = 0.004;
    private static final double FFT_CUT_OFF_POWER_NOISE_RATIO = 0.46;
    private static final double FFT_FRAME_DURATION = 0.03;
    private static final double GOERTZEL_CUT_OFF_POWER_NOISE_RATIO = 0.87;
    private static final double GOERTZEL_FRAME_DURATION = 0.045;
    private boolean decoded;
    private boolean decoder = true;
    private boolean generate = false;
    private String[] seq;
    private MixerStream audio;
    private int frameSize;
    private static int[] freqIndicies;
    public static final int[] DTMF_FREQUENCIES_BIN;
    public static final int[] DTMF_FREQUENCIES;
    public static final char[] DTMF_CHARACTERS;
    private double[] generatedSeq;
    private int outPauseDurr;
    private int outToneDurr;
    private double outFs;
    private char[] outChars;
    private boolean generated;

    public DTMFUtil(MixerStream data) {
        this.audio = data;
        this.setFrameSize();
        if (!goertzel) {
            this.setCentreIndicies();
        }
        this.decoded = false;
        this.seq = new String[2];
        this.seq[0] = "";
        this.seq[1] = "";
    }

    private void setChars(char[] chars) throws DTMFDecoderException {
        this.outChars = new char[chars.length];
        char[] cc = Arrays.copyOf(DTMF_CHARACTERS, DTMF_CHARACTERS.length);
        Arrays.sort(cc);
        for (int c = 0; c < chars.length; ++c) {
            if (Arrays.binarySearch(cc, chars[c]) < 0) {
                throw new DTMFDecoderException("The character \"" + chars[c] + "\" is not a DTMF character.");
            }
            this.outChars[c] = chars[c];
        }
    }

    private void setCentreIndicies() {
        freqIndicies = new int[DTMF_FREQUENCIES_BIN.length];
        for (int i = 0; i < freqIndicies.length; ++i) {
            int ind;
            DTMFUtil.freqIndicies[i] = ind = (int)Math.round((double)DTMF_FREQUENCIES_BIN[i] * 1.0 / (double)this.audio.getSampleRate() * 1.0 * (double)this.frameSize);
        }
    }

    private void setFrameSize() {
        if (goertzel) {
            this.frameSize = (int)Math.floor(0.045 * (double)this.audio.getSampleRate());
        } else {
            int size = 0;
            for (int i = 8; i <= 15; ++i) {
                size = (int)Math.pow(2.0, i);
                if ((double)size / ((double)this.audio.getSampleRate() * 1.0) < 0.03) continue;
                this.frameSize = size;
                return;
            }
        }
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    private static double[] filterFrame(double[] frame) {
        double[] out = new double[8];
        out[0] = frame[freqIndicies[0]];
        if (freqIndicies[0] != freqIndicies[1]) {
            out[0] = out[0] + frame[freqIndicies[1]];
        }
        if (freqIndicies[0] != freqIndicies[2] && freqIndicies[1] != freqIndicies[2]) {
            out[0] = out[0] + frame[freqIndicies[2]];
        }
        out[1] = frame[freqIndicies[3]];
        if (freqIndicies[3] != freqIndicies[4]) {
            out[1] = out[1] + frame[freqIndicies[4]];
        }
        if (freqIndicies[3] != freqIndicies[5] && freqIndicies[4] != freqIndicies[5]) {
            out[1] = out[1] + frame[freqIndicies[5]];
        }
        out[2] = frame[freqIndicies[6]];
        if (freqIndicies[6] != freqIndicies[7]) {
            out[2] = out[2] + frame[freqIndicies[7]];
        }
        if (freqIndicies[6] != freqIndicies[8] && freqIndicies[7] != freqIndicies[8]) {
            out[2] = out[2] + frame[freqIndicies[8]];
        }
        out[3] = frame[freqIndicies[9]];
        if (freqIndicies[9] != freqIndicies[10]) {
            out[3] = out[3] + frame[freqIndicies[10]];
        }
        if (freqIndicies[9] != freqIndicies[11] && freqIndicies[10] != freqIndicies[11]) {
            out[3] = out[3] + frame[freqIndicies[11]];
        }
        out[4] = frame[freqIndicies[12]];
        if (freqIndicies[12] != freqIndicies[13]) {
            out[4] = out[4] + frame[freqIndicies[13]];
        }
        if (freqIndicies[12] != freqIndicies[14] && freqIndicies[13] != freqIndicies[14]) {
            out[5] = out[5] + frame[freqIndicies[14]];
        }
        out[5] = frame[freqIndicies[15]];
        if (freqIndicies[15] != freqIndicies[16]) {
            out[5] = out[5] + frame[freqIndicies[16]];
        }
        if (freqIndicies[15] != freqIndicies[17] && freqIndicies[16] != freqIndicies[17]) {
            out[5] = out[5] + frame[freqIndicies[17]];
        }
        out[6] = frame[freqIndicies[18]];
        if (freqIndicies[18] != freqIndicies[19]) {
            out[6] = out[6] + frame[freqIndicies[19]];
        }
        if (freqIndicies[18] != freqIndicies[20] && freqIndicies[19] != freqIndicies[20]) {
            out[6] = out[6] + frame[freqIndicies[20]];
        }
        out[7] = frame[freqIndicies[21]];
        out[7] = frame[freqIndicies[22]] != frame[freqIndicies[21]] ? out[7] + frame[freqIndicies[22]] : out[7] + frame[freqIndicies[23]];
        out[7] = out[7] + frame[freqIndicies[24]];
        return out;
    }

    public String[] getDecoded() throws DTMFDecoderException {
        if (!this.decoded) {
            throw new DTMFDecoderException("File has not been decoded yet. Please run the method decode() first!");
        }
        return this.seq;
    }

    private static double[] transformFrameFFT(double[] frame, int Fs) {
        FastFourierTransformer fft = new FastFourierTransformer(DftNormalization.STANDARD);
        Complex[] spectrum = fft.transform(frame, TransformType.FORWARD);
        double[] powerSpectrum = new double[frame.length / 2 + 1];
        for (int ii = 0; ii < powerSpectrum.length; ++ii) {
            double abs = spectrum[ii].abs();
            powerSpectrum[ii] = abs * abs;
        }
        return powerSpectrum;
    }

    private static double[] transformFrameG(double[] frame, int Fs) throws DTMFDecoderException {
        GoertzelOptimised g = new GoertzelOptimised(Fs, frame, DTMF_FREQUENCIES_BIN);
        if (g.compute()) {
            double[] out = DTMFUtil.filterFrameG(g.getMagnitudeSquared());
            return out;
        }
        throw new DTMFDecoderException("Decoding failed.");
    }

    private static double[] filterFrameG(double[] frame) {
        double[] out = new double[]{DecoderUtil.max(Arrays.copyOfRange(frame, 0, 3)), DecoderUtil.max(Arrays.copyOfRange(frame, 3, 6)), DecoderUtil.max(Arrays.copyOfRange(frame, 6, 9)), DecoderUtil.max(Arrays.copyOfRange(frame, 9, 12)), DecoderUtil.max(Arrays.copyOfRange(frame, 12, 15)), DecoderUtil.max(Arrays.copyOfRange(frame, 15, 18)), DecoderUtil.max(Arrays.copyOfRange(frame, 18, 21)), DecoderUtil.max(Arrays.copyOfRange(frame, 21, 25))};
        return out;
    }

    private boolean isNoisy(double[] dft_data, double[] power_spectrum) {
        if (power_spectrum == null) {
            return true;
        }
        double[] temp1 = Arrays.copyOfRange(dft_data, 0, 4);
        double[] temp2 = Arrays.copyOfRange(dft_data, 4, 8);
        Arrays.sort(temp1);
        Arrays.sort(temp2);
        return (temp1[temp1.length - 1] + temp2[temp2.length - 1]) / DecoderUtil.sumArray(power_spectrum) < 0.46;
    }

    private boolean isNoisyG(double[] dft_data) {
        double[] temp1 = Arrays.copyOfRange(dft_data, 0, 4);
        double[] temp2 = Arrays.copyOfRange(dft_data, 4, 8);
        Arrays.sort(temp1);
        Arrays.sort(temp2);
        double one = temp1[temp1.length - 1];
        double two = temp2[temp2.length - 1];
        double sum = DecoderUtil.sumArray(dft_data);
        return (one + two) / sum < 0.87;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static char getRawChar(double[] dft_data) throws DTMFDecoderException {
        int out = 0;
        double[] lower = Arrays.copyOfRange(dft_data, 0, 4);
        double[] higher = Arrays.copyOfRange(dft_data, 4, 8);
        int low = DecoderUtil.maxIndex(lower);
        int hi = DecoderUtil.maxIndex(higher);
        if (low == 0) {
            if (hi == 0) {
                return (char)49;
            }
            if (hi == 1) {
                return (char)50;
            }
            if (hi == 2) {
                return (char)51;
            }
            if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
            return (char)65;
        }
        if (low == 1) {
            if (hi == 0) {
                return (char)52;
            }
            if (hi == 1) {
                return (char)53;
            }
            if (hi == 2) {
                return (char)54;
            }
            if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
            return (char)66;
        }
        if (low == 2) {
            if (hi == 0) {
                return (char)55;
            }
            if (hi == 1) {
                return (char)56;
            }
            if (hi == 2) {
                return (char)57;
            }
            if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
            return (char)67;
        }
        if (low != 3) throw new DTMFDecoderException("Something went terribly wrong!");
        if (hi == 0) {
            return (char)42;
        }
        if (hi == 1) {
            return (char)48;
        }
        if (hi == 2) {
            return (char)35;
        }
        if (hi != 3) throw new DTMFDecoderException("Something went terribly wrong!");
        return (char)68;
    }

    public static double[] toDoubleArray(byte[] byteArray) {
        double[] doubles = new double[byteArray.length / 2];
        int i = 0;
        int j = 0;
        while (i != doubles.length) {
            doubles[i] = byteArray[j] & 0xFF | (byteArray[j + 1] & 0xFF) << 8;
            ++i;
            j += 2;
        }
        return doubles;
    }

    public char decodeNextFrameMono(byte[] buffer) {
        HashMap<Character, Integer> votes = new HashMap<Character, Integer>();
        int length = buffer.length;
        int chunkSize = this.getFrameSize();
        for (int i = 0; i < length; i += chunkSize) {
            int end = Math.min(length, i + chunkSize);
            byte[] chunk = Arrays.copyOfRange(buffer, i, end);
            try {
                char dtmfChar = this.decodeNextFrameMono(DTMFUtil.toDoubleArray(chunk));
                if (votes.containsKey(Character.valueOf(dtmfChar))) {
                    votes.put(Character.valueOf(dtmfChar), (Integer)votes.get(Character.valueOf(dtmfChar)) + 1);
                    continue;
                }
                votes.put(Character.valueOf(dtmfChar), 1);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int votesSize = votes.size();
        if (votesSize == 2 && votes.containsKey(Character.valueOf('_'))) {
            votes.remove(Character.valueOf('_'));
        }
        Map.Entry maxEntry = votes.entrySet().stream().max(Map.Entry.comparingByValue()).orElse(null);
        char dtmfChar = '_';
        if (maxEntry != null) {
            dtmfChar = ((Character)maxEntry.getKey()).charValue();
        }
        if ((Integer)maxEntry.getValue() < 2) {
            dtmfChar = '_';
        }
        return dtmfChar;
    }

    private char decodeNextFrameMono(double[] buffer) throws DTMFDecoderException, IOException {
        char out;
        double[] frame;
        int bufferSize = buffer.length;
        double[] tempBuffer11 = new double[bufferSize];
        double[] tempBuffer21 = new double[bufferSize];
        if (goertzel) {
            frame = DecoderUtil.concatenateAll(tempBuffer21, tempBuffer11, buffer);
            tempBuffer21 = tempBuffer11;
            tempBuffer11 = buffer;
        } else {
            int slice = buffer.length + tempBuffer11.length + tempBuffer21.length - this.frameSize;
            double[] sliced = Arrays.copyOfRange(buffer, 0, buffer.length - slice);
            frame = DecoderUtil.concatenateAll(tempBuffer21, tempBuffer11, sliced);
            tempBuffer21 = tempBuffer11;
            tempBuffer11 = buffer;
        }
        if (DecoderUtil.signalPower(frame) < 0.004) {
            return '_';
        }
        if (goertzel) {
            double[] dft_data = DTMFUtil.transformFrameG(frame, (int)this.audio.getSampleRate());
            if (this.isNoisyG(dft_data)) {
                return '_';
            }
            out = DTMFUtil.getRawChar(dft_data);
            return out;
        }
        double[] power_spectrum = DTMFUtil.transformFrameFFT(frame, (int)this.audio.getSampleRate());
        double[] dft_data = DTMFUtil.filterFrame(power_spectrum);
        if (this.isNoisy(dft_data, power_spectrum)) {
            return '_';
        }
        out = DTMFUtil.getRawChar(dft_data);
        return out;
    }

    public boolean isDecoded() {
        return this.decoded;
    }

    public int getChannelCount() {
        return this.audio.getNumChannels();
    }

    public boolean generate() throws DTMFDecoderException {
        int i;
        if (!this.generate) {
            throw new DTMFDecoderException("The object was not instantiated in the generation mode. Plese use the correct constructor.");
        }
        ArrayList<Double> outSamples = new ArrayList<Double>();
        int toneLen = (int)Math.floor((double)this.outToneDurr * this.outFs / 1000.0);
        int pauseLen = (int)Math.floor((double)this.outPauseDurr * this.outFs / 1000.0);
        this.addPause(outSamples, pauseLen);
        for (i = 0; i < this.outChars.length; ++i) {
            this.addTone(outSamples, this.outChars[i], toneLen);
            this.addPause(outSamples, pauseLen);
        }
        this.addPause(outSamples, pauseLen);
        this.generatedSeq = new double[outSamples.size()];
        for (i = 0; i < this.generatedSeq.length; ++i) {
            this.generatedSeq[i] = outSamples.get(i);
        }
        this.generated = true;
        return true;
    }

    private void addTone(ArrayList<Double> samples, char c, int toneLen) throws DTMFDecoderException {
        double[] f = this.getFreqs(c);
        for (double s = 0.0; s < (double)toneLen; s += 1.0) {
            double lo = Math.sin(Math.PI * 2 * f[0] * s / this.outFs);
            double hi = Math.sin(Math.PI * 2 * f[1] * s / this.outFs);
            samples.add((hi + lo) / 2.0);
        }
    }

    private double[] getFreqs(char c) throws DTMFDecoderException {
        double[] out = new double[2];
        if (c == '0') {
            out[0] = 941.0;
            out[1] = 1336.0;
        } else if (c == '1') {
            out[0] = 697.0;
            out[1] = 1209.0;
        } else if (c == '2') {
            out[0] = 697.0;
            out[1] = 1336.0;
        } else if (c == '3') {
            out[0] = 697.0;
            out[1] = 1477.0;
        } else if (c == '4') {
            out[0] = 770.0;
            out[1] = 1209.0;
        } else if (c == '5') {
            out[0] = 770.0;
            out[1] = 1336.0;
        } else if (c == '6') {
            out[0] = 770.0;
            out[1] = 1477.0;
        } else if (c == '7') {
            out[0] = 852.0;
            out[1] = 1209.0;
        } else if (c == '8') {
            out[0] = 852.0;
            out[1] = 1336.0;
        } else if (c == '9') {
            out[0] = 852.0;
            out[1] = 1477.0;
        } else if (c == 'A' || c == 'a') {
            out[0] = 697.0;
            out[1] = 1633.0;
        } else if (c == 'B' || c == 'b') {
            out[0] = 770.0;
            out[1] = 1633.0;
        } else if (c == 'C' || c == 'c') {
            out[0] = 852.0;
            out[1] = 1633.0;
        } else if (c == 'D' || c == 'd') {
            out[0] = 941.0;
            out[1] = 1633.0;
        } else {
            throw new DTMFDecoderException("\"" + c + "\" is not a DTMF Character.");
        }
        return out;
    }

    private void addPause(ArrayList<Double> samples, int pauseLen) {
        for (int s = 0; s < pauseLen; ++s) {
            samples.add(0.0);
        }
    }

    public double[] getGeneratedSequence() throws DTMFDecoderException {
        if (this.generated) {
            return this.generatedSeq;
        }
        throw new DTMFDecoderException("Samples have not been generated yet. Please run generate() first.");
    }

    static {
        DTMF_FREQUENCIES_BIN = new int[]{687, 697, 707, 758, 770, 782, 839, 852, 865, 927, 941, 955, 1191, 1209, 1227, 1316, 1336, 1356, 1455, 1477, 1499, 1609, 1633, 1647, 1657};
        DTMF_FREQUENCIES = new int[]{697, 770, 852, 941, 1209, 1336, 1477, 1633};
        DTMF_CHARACTERS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'A', 'B', 'C', 'D'};
    }
}

