/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.sound.dtmf;

import java.lang.reflect.Array;
import java.util.Arrays;

public class DecoderUtil {
    public static <T> T[] concatenate(T[] a, T[] b) {
        int aLen = a.length;
        int bLen = b.length;
        Object[] c = (Object[])Array.newInstance(a.getClass().getComponentType(), aLen + bLen);
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static double[] concatenate(double[] a, double[] b) {
        int aLen = a.length;
        int bLen = b.length;
        double[] c = new double[aLen + bLen];
        System.arraycopy(a, 0, c, 0, aLen);
        System.arraycopy(b, 0, c, aLen, bLen);
        return c;
    }

    public static double[] concatenateAll(double[] arr1, double[] ... arr2) {
        int totalLength = arr1.length;
        for (double[] array : arr2) {
            totalLength += array.length;
        }
        double[] result = Arrays.copyOf(arr1, totalLength);
        int offset = arr1.length;
        for (double[] array : arr2) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static double signalPower(double[] frame) {
        double power = 0.0;
        for (int i = 0; i < frame.length; ++i) {
            power += Math.abs(frame[i]);
        }
        return power / (double)frame.length;
    }

    public static double max(double[] arr) {
        Arrays.sort(arr);
        return arr[arr.length - 1];
    }

    public static int maxIndex(double[] arr) {
        int index = 0;
        double max = arr[0];
        for (int i = 0; i < arr.length; ++i) {
            if (!(arr[i] > max)) continue;
            max = arr[i];
            index = i;
        }
        return index;
    }

    public static String getFileSequence(String filename) {
        filename = filename.substring(filename.lastIndexOf(47) + 1, filename.length() - 4);
        return filename;
    }

    public static double meanArray(double[] arr) {
        double out = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            out += arr[i];
        }
        return out / (1.0 * (double)arr.length);
    }

    public static double sumArray(double[] arr) {
        double out = 0.0;
        for (int i = 0; i < arr.length; ++i) {
            out += arr[i];
        }
        return out;
    }
}

