/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic.sound.dtmf;

import org.openstatic.sound.dtmf.DTMFDecoderException;

public class GoertzelOptimised {
    private int[] fbin;
    private int Fs;
    private double[] coeffs;
    private double[] samples;
    private double[] magSquared;
    private boolean computed = false;

    public GoertzelOptimised(int Fs, double[] samples, int[] fbin) {
        this.Fs = Fs;
        this.samples = samples;
        this.fbin = fbin;
        this.calculateCoefficients();
    }

    public GoertzelOptimised(int Fs, int[] fbin) {
        this.Fs = Fs;
        this.fbin = fbin;
        this.calculateCoefficients();
    }

    private void calculateCoefficients() {
        this.coeffs = new double[this.fbin.length];
        for (int i = 0; i < this.coeffs.length; ++i) {
            this.coeffs[i] = 2.0 * Math.cos(2.0 * (double)this.fbin[i] * Math.PI / (double)this.Fs);
        }
    }

    public boolean compute() throws DTMFDecoderException {
        if (this.samples == null) {
            throw new DTMFDecoderException("No samples have been provided. To use this method please instantiate the Goertzel object with the constructor GoertzelOptimised()");
        }
        double[] magSquared = new double[this.fbin.length];
        for (int f = 0; f < this.fbin.length; ++f) {
            double q1 = 0.0;
            double q2 = 0.0;
            for (int s = 0; s < this.samples.length; ++s) {
                double q0 = this.coeffs[f] * q1 - q2 + this.samples[s];
                q2 = q1;
                q1 = q0;
            }
            magSquared[f] = q1 * q1 + q2 * q2 - q1 * q2 * this.coeffs[f];
        }
        this.magSquared = magSquared;
        this.computed = true;
        return true;
    }

    public boolean compute(double[] samples) {
        double[] magSquared = new double[this.fbin.length];
        for (int f = 0; f < this.fbin.length; ++f) {
            double q1 = 0.0;
            double q2 = 0.0;
            for (int s = 0; s < samples.length; ++s) {
                double q0 = this.coeffs[f] * q1 - q2 + samples[s];
                q2 = q1;
                q1 = q0;
            }
            magSquared[f] = q1 * q1 + q2 * q2 - q1 * q2 * this.coeffs[f];
        }
        this.magSquared = magSquared;
        this.computed = true;
        return true;
    }

    public double[] getMagnitudeSquared() throws DTMFDecoderException {
        if (this.computed) {
            return this.magSquared;
        }
        throw new DTMFDecoderException("Not yet decoded.");
    }
}

