/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi;

import io.github.leovr.rtipmidi.control.AppleMidiControlServer;
import io.github.leovr.rtipmidi.session.AppleMidiSession;
import io.github.leovr.rtipmidi.session.AppleMidiSessionClient;
import io.github.leovr.rtipmidi.session.AppleMidiSessionServer;
import io.github.leovr.rtipmidi.session.SessionChangeListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleMidiServer
implements SessionChangeListener {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiServer.class);
    private static final int DEFAULT_PORT = 50004;
    private static final String DEFAULT_NAME = "rtpMIDIJava";
    private final int port;
    private final AppleMidiControlServer controlServer;
    private final AppleMidiSessionServer sessionServer;
    private final ArrayList<AppleMidiSessionClient> clients;
    private AppleMidiSession session;
    private String name;

    public AppleMidiServer() throws UnknownHostException {
        this(InetAddress.getLocalHost(), DEFAULT_NAME, 50004);
    }

    public AppleMidiServer(InetAddress socketAddress, @Nonnull String name, int port) {
        this.port = port;
        this.name = name;
        this.clients = new ArrayList();
        this.controlServer = new AppleMidiControlServer(socketAddress, name, port, this);
        this.sessionServer = new AppleMidiSessionServer(socketAddress, name, port + 1, this);
        this.sessionServer.registerSessionChangeListener(this);
        this.controlServer.registerEndSessionListener(this.sessionServer);
    }

    public AppleMidiSessionClient connect(@Nonnull String remoteName, InetAddress address, int port) {
        AppleMidiSessionClient client = new AppleMidiSessionClient(remoteName, address, port, this.name);
        this.clients.add(client);
        return client;
    }

    public boolean hasConnection(String remoteName, InetAddress address, int port) {
        if (this.sessionServer.hasConnection(remoteName, address, port)) {
            return true;
        }
        return this.clients.stream().filter(client -> client.is(address, remoteName) && client.isConnected()).count() > 0L;
    }

    public void closeConnection(InetAddress address, int port) {
        this.controlServer.closeConnection(address, port);
        this.sessionServer.closeConnection(address, port + 1);
        this.clients.forEach(client -> {
            if (client.isConnected() && client.getRemoteAddress().equals(address) && (client.getControlPort() == port || client.getSessionPort() == port)) {
                client.stopClient();
            }
        });
    }

    public void setAppleMidiSession(AppleMidiSession session) {
        this.session = session;
    }

    public AppleMidiSession getAppleMidiSession() {
        return this.session;
    }

    @Override
    public void onMaxNumberOfSessionsChange(int maxNumberOfSessions) {
        this.controlServer.setMaxNumberOfSessions(maxNumberOfSessions);
    }

    public void start() {
        this.sessionServer.start();
        this.controlServer.start();
        System.err.println("AppleMidiServer started");
        log.info("AppleMidiServer started");
    }

    public void stop() {
        this.sessionServer.stopServer();
        this.controlServer.stopServer();
        this.clients.forEach(client -> {
            if (client.isConnected()) {
                client.stopClient();
            }
        });
        log.info("AppleMidiServer stopped");
    }

    public int getPort() {
        return this.port;
    }
}

