/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.handler;

import io.github.leovr.rtipmidi.AppleMidiCommandListener;
import io.github.leovr.rtipmidi.handler.AppleMidiCommandLogListener;
import io.github.leovr.rtipmidi.messages.AppleMidiClockSynchronization;
import io.github.leovr.rtipmidi.messages.AppleMidiEndSession;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationAccepted;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationDeclined;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationRequest;
import io.github.leovr.rtipmidi.messages.CommandWord;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleMidiCommandHandler {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiCommandHandler.class);
    private static final int NUMBER_OF_PADDING_BYTES = 3;
    private static final int PROTOCOL_VERSION = 2;
    private static final int COMMAND_BUFFER_LENGTH = 2;
    private static final String NUL_TERMINATOR = "\u0000";
    private final List<AppleMidiCommandListener> listeners = new ArrayList<AppleMidiCommandListener>();

    public AppleMidiCommandHandler() {
        this.listeners.add(new AppleMidiCommandLogListener());
    }

    public void handle(@Nonnull byte[] data, @Nonnull AppleMidiServerAddress appleMidiServer) {
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(data));
        try {
            CommandWord commandWord;
            byte header1 = dataInputStream.readByte();
            if (header1 != -1) {
                log.info("Header did not contain first MIDI command header");
                return;
            }
            byte header2 = dataInputStream.readByte();
            if (header2 != -1) {
                log.info("Header did not contain second MIDI command header");
                return;
            }
            byte[] commandBuffer = new byte[2];
            int commandBytesRead = dataInputStream.read(commandBuffer);
            if (commandBytesRead != 2) {
                log.info("The number of command bytes: {} did not match: {}", (Object)commandBytesRead, (Object)2);
                return;
            }
            String command = new String(commandBuffer, StandardCharsets.UTF_8);
            try {
                commandWord = CommandWord.valueOf(command);
            }
            catch (IllegalArgumentException e) {
                log.info("Could not parse command word from: {}", (Object)command);
                return;
            }
            switch (commandWord) {
                case IN: {
                    this.handleInvitation(dataInputStream, appleMidiServer);
                    break;
                }
                case CK: {
                    this.handleSynchronization(dataInputStream, appleMidiServer);
                    break;
                }
                case BY: {
                    this.handleEndSession(dataInputStream, appleMidiServer);
                    break;
                }
                case OK: {
                    this.handleInvitationAccepted(dataInputStream, appleMidiServer);
                    break;
                }
                case NO: {
                    this.handleInvitationRejected(dataInputStream, appleMidiServer);
                    break;
                }
                default: {
                    System.err.println("Unknown RTP Command: " + commandWord.toString());
                    break;
                }
            }
        }
        catch (IOException e) {
            log.error("IOException while parsing message", (Throwable)e);
        }
    }

    private void handleEndSession(DataInputStream dataInputStream, AppleMidiServerAddress appleMidiServer) throws IOException {
        int protocolVersion = dataInputStream.readInt();
        if (protocolVersion != 2) {
            log.info("Protocol version: {} did not match version {}", (Object)protocolVersion, (Object)2);
            return;
        }
        int initiatorToken = dataInputStream.readInt();
        int ssrc = dataInputStream.readInt();
        for (AppleMidiCommandListener listener : this.listeners) {
            listener.onEndSession(new AppleMidiEndSession(protocolVersion, initiatorToken, ssrc), appleMidiServer);
        }
    }

    private void handleSynchronization(DataInputStream dataInputStream, AppleMidiServerAddress appleMidiServer) throws IOException {
        int ssrc = dataInputStream.readInt();
        byte count = dataInputStream.readByte();
        int paddingBytes = dataInputStream.read(new byte[3]);
        if (paddingBytes != 3) {
            log.info("The number of padding bytes: {} did not match: {}", (Object)paddingBytes, (Object)3);
            return;
        }
        long timestamp1 = dataInputStream.readLong();
        long timestamp2 = dataInputStream.readLong();
        long timestamp3 = dataInputStream.readLong();
        for (AppleMidiCommandListener listener : this.listeners) {
            listener.onClockSynchronization(new AppleMidiClockSynchronization(ssrc, count, timestamp1, timestamp2, timestamp3), appleMidiServer);
        }
    }

    private void handleInvitation(DataInputStream dataInputStream, AppleMidiServerAddress appleMidiServer) throws IOException {
        int protocolVersion = dataInputStream.readInt();
        if (protocolVersion != 2) {
            log.info("Protocol version: {} did not match version {}", (Object)protocolVersion, (Object)2);
            return;
        }
        int initiatorToken = dataInputStream.readInt();
        int ssrc = dataInputStream.readInt();
        Scanner scanner = new Scanner((InputStream)dataInputStream, StandardCharsets.UTF_8.name()).useDelimiter(NUL_TERMINATOR);
        if (!scanner.hasNext()) {
            log.info("Could not find \\0 terminating string");
            return;
        }
        String name = scanner.next();
        for (AppleMidiCommandListener listener : this.listeners) {
            listener.onMidiInvitation(new AppleMidiInvitationRequest(protocolVersion, initiatorToken, ssrc, name), appleMidiServer);
        }
    }

    private void handleInvitationAccepted(DataInputStream dataInputStream, AppleMidiServerAddress appleMidiServer) throws IOException {
        int protocolVersion = dataInputStream.readInt();
        if (protocolVersion != 2) {
            log.info("Protocol version: {} did not match version {}", (Object)protocolVersion, (Object)2);
            return;
        }
        int initiatorToken = dataInputStream.readInt();
        int ssrc = dataInputStream.readInt();
        Scanner scanner = new Scanner((InputStream)dataInputStream, StandardCharsets.UTF_8.name()).useDelimiter(NUL_TERMINATOR);
        if (!scanner.hasNext()) {
            log.info("Could not find \\0 terminating string");
            return;
        }
        String name = scanner.next();
        for (AppleMidiCommandListener listener : this.listeners) {
            listener.onMidiInvitationAccepted(new AppleMidiInvitationAccepted(protocolVersion, initiatorToken, ssrc, name), appleMidiServer);
        }
    }

    private void handleInvitationRejected(DataInputStream dataInputStream, AppleMidiServerAddress appleMidiServer) throws IOException {
        int protocolVersion = dataInputStream.readInt();
        if (protocolVersion != 2) {
            log.info("Protocol version: {} did not match version {}", (Object)protocolVersion, (Object)2);
            return;
        }
        int initiatorToken = dataInputStream.readInt();
        int ssrc = dataInputStream.readInt();
        Scanner scanner = new Scanner((InputStream)dataInputStream, StandardCharsets.UTF_8.name()).useDelimiter(NUL_TERMINATOR);
        if (!scanner.hasNext()) {
            log.info("Could not find \\0 terminating string");
            return;
        }
        String name = scanner.next();
        for (AppleMidiCommandListener listener : this.listeners) {
            listener.onMidiInvitationDeclined(new AppleMidiInvitationDeclined(protocolVersion, initiatorToken, ssrc, name), appleMidiServer);
        }
    }

    public void registerListener(@Nonnull AppleMidiCommandListener appleMidiCommandListener) {
        this.listeners.add(appleMidiCommandListener);
    }

    public void unregisterListener(@Nonnull AppleMidiCommandListener appleMidiCommandListener) {
        this.listeners.remove(appleMidiCommandListener);
    }
}

