/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.messages;

import io.github.leovr.rtipmidi.messages.AppleMidiCommand;
import io.github.leovr.rtipmidi.messages.CommandWord;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class AppleMidiInvitation
extends AppleMidiCommand {
    private final int protocolVersion;
    private final int initiatorToken;
    private final String name;

    AppleMidiInvitation(CommandWord commandWord, int protocolVersion, int initiatorToken, int ssrc, String name) {
        super(commandWord, ssrc);
        this.protocolVersion = protocolVersion;
        this.initiatorToken = initiatorToken;
        this.name = name;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(-1);
        dataOutputStream.write(-1);
        dataOutputStream.write(this.getCommandWord().name().getBytes(StandardCharsets.UTF_8));
        dataOutputStream.writeInt(this.protocolVersion);
        dataOutputStream.writeInt(this.initiatorToken);
        dataOutputStream.writeInt(this.getSsrc());
        dataOutputStream.write(this.name.getBytes(StandardCharsets.UTF_8));
        dataOutputStream.writeByte(0);
        dataOutputStream.flush();
        return outputStream.toByteArray();
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getInitiatorToken() {
        return this.initiatorToken;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "AppleMidiInvitation(super=" + super.toString() + ", protocolVersion=" + this.getProtocolVersion() + ", initiatorToken=" + this.getInitiatorToken() + ", name=" + this.getName() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppleMidiInvitation)) {
            return false;
        }
        AppleMidiInvitation other = (AppleMidiInvitation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getProtocolVersion() != other.getProtocolVersion()) {
            return false;
        }
        if (this.getInitiatorToken() != other.getInitiatorToken()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AppleMidiInvitation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getProtocolVersion();
        result = result * 59 + this.getInitiatorToken();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }
}

