/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.messages;

import io.github.leovr.rtipmidi.messages.MidiCommandHeader;
import io.github.leovr.rtipmidi.messages.MidiTimestampPair;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;

public class AppleMidiMessage {
    private final MidiCommandHeader midiCommandHeader;
    private final List<MidiTimestampPair> messages;

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        outputStream.write(this.midiCommandHeader.toByteArray());
        boolean first = true;
        for (MidiTimestampPair message : this.messages) {
            if (first && !this.midiCommandHeader.isZ()) {
                first = false;
            } else {
                int timestamp = message.getTimestamp();
                if (timestamp > 0xFFFFFFF) {
                    throw new IllegalArgumentException("Timestamp too big: " + timestamp);
                }
                if (timestamp > 0) {
                    for (int numberOfSeptets = (int)Math.ceil((double)Integer.bitCount(Integer.highestOneBit(timestamp) * 2 - 1) / 7.0); numberOfSeptets > 0; --numberOfSeptets) {
                        outputStream.writeByte((numberOfSeptets > 1 ? 128 : 0) | timestamp >> (numberOfSeptets - 1) * 7 & 0x7F);
                    }
                } else {
                    outputStream.writeByte(0);
                }
            }
            outputStream.write(message.getMidiMessage().getData());
        }
        outputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public AppleMidiMessage(MidiCommandHeader midiCommandHeader, List<MidiTimestampPair> messages) {
        this.midiCommandHeader = midiCommandHeader;
        this.messages = messages;
    }

    public MidiCommandHeader getMidiCommandHeader() {
        return this.midiCommandHeader;
    }

    public List<MidiTimestampPair> getMessages() {
        return this.messages;
    }
}

