/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.messages;

import io.github.leovr.rtipmidi.messages.RtpHeader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class MidiCommandHeader {
    private final boolean b;
    private final boolean j;
    private final boolean z;
    private final boolean p;
    private final short length;
    private final RtpHeader rtpHeader;

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        outputStream.write(this.rtpHeader.toByteArray());
        int midiCommandHeader1 = 0;
        midiCommandHeader1 = (byte)(midiCommandHeader1 | (this.b ? 1 : 0) << 7);
        midiCommandHeader1 = (byte)(midiCommandHeader1 | (this.j ? 1 : 0) << 6);
        midiCommandHeader1 = (byte)(midiCommandHeader1 | (this.z ? 1 : 0) << 5);
        midiCommandHeader1 = (byte)(midiCommandHeader1 | (this.p ? 1 : 0) << 4);
        if (this.b) {
            midiCommandHeader1 = (byte)(midiCommandHeader1 | (this.length & 0xF00) >> 8);
            outputStream.writeByte(midiCommandHeader1);
            outputStream.writeByte(this.length & 0xFF);
        } else {
            midiCommandHeader1 = (byte)(midiCommandHeader1 | this.length);
            outputStream.writeByte(midiCommandHeader1);
        }
        outputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public MidiCommandHeader(boolean b, boolean j, boolean z, boolean p, short length, RtpHeader rtpHeader) {
        this.b = b;
        this.j = j;
        this.z = z;
        this.p = p;
        this.length = length;
        this.rtpHeader = rtpHeader;
    }

    public boolean isB() {
        return this.b;
    }

    public boolean isJ() {
        return this.j;
    }

    public boolean isZ() {
        return this.z;
    }

    public boolean isP() {
        return this.p;
    }

    public short getLength() {
        return this.length;
    }

    public RtpHeader getRtpHeader() {
        return this.rtpHeader;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MidiCommandHeader)) {
            return false;
        }
        MidiCommandHeader other = (MidiCommandHeader)o;
        if (this.isB() != other.isB()) {
            return false;
        }
        if (this.isJ() != other.isJ()) {
            return false;
        }
        if (this.isZ() != other.isZ()) {
            return false;
        }
        if (this.isP() != other.isP()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        RtpHeader this$rtpHeader = this.getRtpHeader();
        RtpHeader other$rtpHeader = other.getRtpHeader();
        return !(this$rtpHeader == null ? other$rtpHeader != null : !((Object)this$rtpHeader).equals(other$rtpHeader));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isB() ? 79 : 97);
        result = result * 59 + (this.isJ() ? 79 : 97);
        result = result * 59 + (this.isZ() ? 79 : 97);
        result = result * 59 + (this.isP() ? 79 : 97);
        result = result * 59 + this.getLength();
        RtpHeader $rtpHeader = this.getRtpHeader();
        result = result * 59 + ($rtpHeader == null ? 43 : ((Object)$rtpHeader).hashCode());
        return result;
    }

    public String toString() {
        return "MidiCommandHeader(b=" + this.isB() + ", j=" + this.isJ() + ", z=" + this.isZ() + ", p=" + this.isP() + ", length=" + this.getLength() + ", rtpHeader=" + this.getRtpHeader() + ")";
    }
}

