/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.session;

import io.github.leovr.rtipmidi.AppleMidiCommandListener;
import io.github.leovr.rtipmidi.AppleMidiMessageListener;
import io.github.leovr.rtipmidi.AppleMidiServer;
import io.github.leovr.rtipmidi.error.AppleMidiSessionServerRuntimeException;
import io.github.leovr.rtipmidi.handler.AppleMidiCommandHandler;
import io.github.leovr.rtipmidi.handler.AppleMidiMessageHandler;
import io.github.leovr.rtipmidi.messages.AppleMidiClockSynchronization;
import io.github.leovr.rtipmidi.messages.AppleMidiCommand;
import io.github.leovr.rtipmidi.messages.AppleMidiEndSession;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationAccepted;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationDeclined;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationRequest;
import io.github.leovr.rtipmidi.messages.AppleMidiMessage;
import io.github.leovr.rtipmidi.messages.MidiCommandHeader;
import io.github.leovr.rtipmidi.messages.MidiTimestampPair;
import io.github.leovr.rtipmidi.messages.RtpHeader;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import io.github.leovr.rtipmidi.model.MidiMessage;
import io.github.leovr.rtipmidi.session.AppleMidiMessageSender;
import io.github.leovr.rtipmidi.session.AppleMidiSession;
import io.github.leovr.rtipmidi.session.AppleMidiSessionSender;
import io.github.leovr.rtipmidi.session.SessionChangeListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleMidiSessionClient
implements AppleMidiCommandListener,
AppleMidiMessageListener,
AppleMidiMessageSender,
AppleMidiSessionSender {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiSessionClient.class);
    private static final int SOCKET_TIMEOUT = 1000;
    private static final int RECEIVE_BUFFER_LENGTH = 1024;
    private ExecutorService executorService;
    private final int ssrc;
    private int remoteSsrc;
    private int initiatorToken;
    private final String localName;
    private final String remoteName;
    private final InetAddress inetAddress;
    private final int port;
    private final AppleMidiCommandHandler midiCommandHandler = new AppleMidiCommandHandler();
    private final AppleMidiMessageHandler midiMessageHandler = new AppleMidiMessageHandler();
    private boolean running = false;
    private DatagramSocket controlSocket;
    private DatagramSocket sessionSocket;
    private AppleMidiSession session;
    private final List<SessionChangeListener> sessionChangeListeners = new ArrayList<SessionChangeListener>();
    private Thread controlThread;
    private Thread sessionThread;
    private long lastClockSyncAt;
    private short sequenceNumber = (short)new Random().nextInt(32768);
    private Runnable controlRunnable = new Runnable(){

        @Override
        public void run() {
            while (AppleMidiSessionClient.this.running) {
                try {
                    final byte[] receiveDataControl = new byte[1024];
                    final DatagramPacket incomingPacketControl = new DatagramPacket(receiveDataControl, receiveDataControl.length);
                    AppleMidiSessionClient.this.controlSocket.receive(incomingPacketControl);
                    AppleMidiSessionClient.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (receiveDataControl[0] == -1) {
                                AppleMidiSessionClient.this.midiCommandHandler.handle(receiveDataControl, new AppleMidiServerAddress(incomingPacketControl.getAddress(), incomingPacketControl.getPort()));
                            } else {
                                AppleMidiSessionClient.this.midiMessageHandler.handle(receiveDataControl, new AppleMidiServerAddress(incomingPacketControl.getAddress(), incomingPacketControl.getPort()));
                            }
                        }
                    });
                }
                catch (SocketTimeoutException receiveDataControl) {
                }
                catch (IOException e) {
                    log.error("IOException while receiving", (Throwable)e);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - AppleMidiSessionClient.this.lastClockSyncAt <= 10000L || AppleMidiSessionClient.this.lastClockSyncAt == 0L || !AppleMidiSessionClient.this.running) continue;
                try {
                    AppleMidiSessionClient.this.sendClockSync();
                }
                catch (Exception exception) {}
            }
            System.err.println("Closing Control socket");
            AppleMidiSessionClient.this.controlSocket.close();
            AppleMidiSessionClient.this.controlSocket = null;
        }
    };
    private Runnable sessionRunnable = new Runnable(){

        @Override
        public void run() {
            while (AppleMidiSessionClient.this.running) {
                try {
                    final byte[] receiveDataSession = new byte[1024];
                    final DatagramPacket incomingPacketSession = new DatagramPacket(receiveDataSession, receiveDataSession.length);
                    AppleMidiSessionClient.this.sessionSocket.receive(incomingPacketSession);
                    AppleMidiSessionClient.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (receiveDataSession[0] == -1) {
                                AppleMidiSessionClient.this.midiCommandHandler.handle(receiveDataSession, new AppleMidiServerAddress(incomingPacketSession.getAddress(), incomingPacketSession.getPort()));
                            } else {
                                AppleMidiSessionClient.this.midiMessageHandler.handle(receiveDataSession, new AppleMidiServerAddress(incomingPacketSession.getAddress(), incomingPacketSession.getPort()));
                            }
                        }
                    });
                }
                catch (SocketTimeoutException receiveDataSession) {
                }
                catch (IOException e) {
                    log.error("IOException while receiving", (Throwable)e);
                }
                catch (RejectedExecutionException rejectedExecutionException) {}
            }
            System.err.println("Closing Session socket");
            AppleMidiSessionClient.this.sessionSocket.close();
            AppleMidiSessionClient.this.sessionSocket = null;
        }
    };

    public AppleMidiSessionClient(@Nonnull String remoteName, InetAddress inetAddress, int port, @Nonnull String localName) {
        this.port = port;
        this.remoteName = remoteName;
        this.localName = localName;
        this.ssrc = this.createSsrc(this.localName);
        this.inetAddress = inetAddress;
        this.midiCommandHandler.registerListener(this);
        this.midiMessageHandler.registerListener(this);
    }

    private int createSsrc(String hostName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(String.valueOf(new Date().getTime()).getBytes());
            md.update(String.valueOf(System.identityHashCode(this)).getBytes());
            md.update(Paths.get("", new String[0]).toAbsolutePath().normalize().toString().getBytes());
            md.update(hostName.getBytes());
            byte[] md5 = md.digest();
            int ssrc = 0;
            ByteBuffer byteBuffer = ByteBuffer.wrap(md5);
            for (int i = 0; i < 3; ++i) {
                ssrc ^= byteBuffer.getInt();
            }
            return ssrc;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not get MD5 algorithm", e);
        }
    }

    public synchronized void start() {
        this.running = true;
        this.lastClockSyncAt = 0L;
        this.executorService = Executors.newCachedThreadPool();
        this.controlThread = new Thread(this.controlRunnable, this.remoteName + ".control");
        this.sessionThread = new Thread(this.sessionRunnable, this.remoteName + ".session");
        try {
            this.controlSocket = new DatagramSocket();
            this.controlSocket.setSoTimeout(1000);
            this.controlSocket.connect(this.inetAddress, this.getControlPort());
            this.sessionSocket = new DatagramSocket();
            this.sessionSocket.setSoTimeout(1000);
            this.sessionSocket.connect(this.inetAddress, this.getSessionPort());
        }
        catch (SocketException e) {
            throw new AppleMidiSessionServerRuntimeException("DatagramSocket cannot be opened", e);
        }
        this.controlThread.start();
        this.sessionThread.start();
        log.debug("MIDI session client started");
        AppleMidiInvitationRequest invitation = new AppleMidiInvitationRequest(2, this.getNewInitiatorToken(), this.ssrc, this.localName);
        try {
            this.sendControl(invitation);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isConnected() {
        if (this.sessionSocket != null && this.isRunning()) {
            return this.sessionSocket.isConnected();
        }
        return false;
    }

    public boolean hasServerConnection(AppleMidiServer server) {
        return server.hasConnection(this.remoteName, this.inetAddress, this.getSessionPort());
    }

    public boolean is(InetAddress address, String remoteName) {
        return this.inetAddress.equals(address) && this.remoteName.equals(remoteName);
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public String getLocalName() {
        return this.localName;
    }

    public InetAddress getRemoteAddress() {
        return this.inetAddress;
    }

    public String getRemoteAddressString() {
        return this.getRemoteAddress().toString();
    }

    public int getControlPort() {
        return this.port;
    }

    public int getSessionPort() {
        return this.port + 1;
    }

    int getNewInitiatorToken() {
        return new Random().nextInt();
    }

    public void invitePeerAgainViaSession(AppleMidiInvitationAccepted acceptance) {
        AppleMidiServerAddress outgoingServer = new AppleMidiServerAddress(this.inetAddress, this.getSessionPort());
        this.initiatorToken = acceptance.getInitiatorToken();
        AppleMidiInvitationRequest invitation = new AppleMidiInvitationRequest(2, this.initiatorToken, this.ssrc, this.localName);
        try {
            this.send(invitation, outgoingServer);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void stopClient() {
        try {
            AppleMidiEndSession goodbye = new AppleMidiEndSession(2, this.initiatorToken, this.ssrc);
            this.sendControl(goodbye);
        }
        catch (Exception e2) {
            e2.printStackTrace(System.err);
        }
        this.running = false;
        try {
            this.executorService.shutdown();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.session != null) {
            this.session.removeSender(this);
        }
        log.debug("MIDI session server stopped");
    }

    private void sendControl(AppleMidiCommand midiCommand) throws IOException {
        this.sendControl(midiCommand.toByteArray());
    }

    private void sendControl(byte[] data) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Sending data {} to server {}", (Object)Hex.encodeHexString((byte[])data));
        }
        this.controlSocket.send(new DatagramPacket(data, data.length, this.inetAddress, this.getControlPort()));
    }

    public void sendControl(@Nonnull AppleMidiMessage appleMidiMessage) throws IOException {
        this.sendControl(appleMidiMessage.toByteArray());
    }

    private void send(AppleMidiCommand midiCommand, AppleMidiServerAddress appleMidiServer) throws IOException {
        this.send(midiCommand.toByteArray(), appleMidiServer);
    }

    private void send(byte[] data, AppleMidiServerAddress appleMidiServer) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Sending data {} to server {}", (Object)Hex.encodeHexString((byte[])data), (Object)appleMidiServer);
        }
        this.sessionSocket.send(new DatagramPacket(data, data.length, this.inetAddress, this.getSessionPort()));
    }

    @Override
    public void send(@Nonnull AppleMidiMessage appleMidiMessage, @Nonnull AppleMidiServerAddress appleMidiServer) throws IOException {
        this.send(appleMidiMessage.toByteArray(), appleMidiServer);
    }

    @Override
    public void onMidiInvitation(@Nonnull AppleMidiInvitationRequest invitation, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    @Override
    public void onMidiInvitationAccepted(@Nonnull AppleMidiInvitationAccepted acceptance, @Nonnull AppleMidiServerAddress appleMidiServer) {
        int port = appleMidiServer.getPort();
        if (port == this.getControlPort()) {
            this.invitePeerAgainViaSession(acceptance);
        } else if (port == this.getSessionPort()) {
            this.remoteSsrc = acceptance.getSsrc();
            this.session.addSender(this);
            this.session.onMidiInvitationAccepted(acceptance, appleMidiServer);
            this.sendClockSync();
        }
    }

    public long getCurrentTimestamp() {
        long currentTimestamp = ManagementFactory.getRuntimeMXBean().getUptime() * 10L;
        return currentTimestamp;
    }

    public void sendClockSync() {
        long currentTimestamp = this.getCurrentTimestamp();
        this.lastClockSyncAt = System.currentTimeMillis();
        AppleMidiClockSynchronization clockSynchronizationRequest = new AppleMidiClockSynchronization(this.ssrc, 0, currentTimestamp, 0L, 0L);
        try {
            this.send(clockSynchronizationRequest, new AppleMidiServerAddress(this.inetAddress, this.getSessionPort()));
        }
        catch (IOException e) {
            log.error("IOException while sending clock synchronization", (Throwable)e);
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void onClockSynchronization(@Nonnull AppleMidiClockSynchronization clockSynchronization, @Nonnull AppleMidiServerAddress appleMidiServer) {
        if (clockSynchronization.getCount() == 1) {
            long currentTimestamp = ManagementFactory.getRuntimeMXBean().getUptime() * 10L;
            AppleMidiClockSynchronization clockSynchronizationAnswer = new AppleMidiClockSynchronization(this.ssrc, 1, clockSynchronization.getTimestamp1(), clockSynchronization.getTimestamp2(), currentTimestamp);
            try {
                this.send(clockSynchronizationAnswer, appleMidiServer);
            }
            catch (IOException e) {
                log.error("IOException while sending clock synchronization", (Throwable)e);
            }
        }
    }

    @Override
    public void onEndSession(@Nonnull AppleMidiEndSession appleMidiEndSession, @Nonnull AppleMidiServerAddress appleMidiServer) {
        log.info("Session end from: {}", (Object)appleMidiServer);
        this.session.onEndSession(appleMidiEndSession, appleMidiServer);
        this.stopClient();
    }

    @Override
    public void onMidiMessage(MidiCommandHeader midiCommandHeader, MidiMessage message, int timestamp) {
        int inSsrc = midiCommandHeader.getRtpHeader().getSsrc();
        if (inSsrc != this.ssrc) {
            this.session.onMidiMessage(midiCommandHeader, message, timestamp);
        }
    }

    public void setAppleMidiSession(@Nonnull AppleMidiSession session) {
        this.session = session;
    }

    public void registerSessionChangeListener(@Nonnull SessionChangeListener listener) {
        this.sessionChangeListeners.add(listener);
    }

    public void unregisterSessionChangeListener(@Nonnull SessionChangeListener listener) {
        this.sessionChangeListeners.remove(listener);
    }

    @Override
    public void sendMidiMessage(@Nonnull MidiMessage message, long timestamp) {
        this.sequenceNumber = (short)(this.sequenceNumber + 1);
        AppleMidiServerAddress appleMidiServer = new AppleMidiServerAddress(this.inetAddress, this.getSessionPort());
        long currentTimeIn100Microseconds = this.getCurrentTimestamp();
        int rtpTimestamp = (int)currentTimeIn100Microseconds;
        RtpHeader rtpHeader = new RtpHeader(2, false, false, 0, false, 97, this.sequenceNumber, rtpTimestamp, this.ssrc);
        log.trace("Sending RTP-Header: {}", (Object)rtpHeader);
        boolean b = message.getLength() > 15;
        MidiCommandHeader midiCommandHeader = new MidiCommandHeader(b, false, false, false, (short)message.getLength(), rtpHeader);
        AppleMidiMessage appleMidiMessage = new AppleMidiMessage(midiCommandHeader, Collections.singletonList(new MidiTimestampPair(0, message)));
        try {
            this.send(appleMidiMessage, appleMidiServer);
        }
        catch (IOException e) {
            log.error("Error sending MidiMessage to {}", (Object)appleMidiServer, (Object)e);
            e.printStackTrace(System.err);
        }
    }

    @Override
    public void onMidiInvitationDeclined(@Nonnull AppleMidiInvitationDeclined decline, @Nonnull AppleMidiServerAddress appleMidiServer) {
        System.err.println("Invitation Declined!");
        this.stopClient();
        this.session.onMidiInvitationDeclined(decline, appleMidiServer);
    }
}

