/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.wrapper.microsoft.xinput;

import com.sun.jna.ptr.LongByReference;
import de.ralleytn.wrapper.microsoft.xinput.XInput;
import de.ralleytn.wrapper.microsoft.xinput.XInputBatteryInformation;
import de.ralleytn.wrapper.microsoft.xinput.XInputCapabilities;
import de.ralleytn.wrapper.microsoft.xinput.XInputKeystroke;
import de.ralleytn.wrapper.microsoft.xinput.XInputState;
import de.ralleytn.wrapper.microsoft.xinput.XInputVibration;
import java.lang.reflect.Method;
import java.util.Arrays;

public final class Info {
    private Method[] availableMethods;
    private String loadedDLL;

    Info() {
    }

    protected final void setLoadedDLL(String loadedDLL) {
        this.loadedDLL = loadedDLL;
        this.availableMethods = this.createAvailableMethodsArray();
    }

    private final Method[] createAvailableMethodsArray() {
        try {
            switch (this.loadedDLL) {
                case "xinput1_4.dll": {
                    return this.createAvailableMethodsFor14();
                }
                case "xinput1_3.dll": {
                    return this.createAvailableMethodsFor13();
                }
                case "xinput9_1_0.dll": {
                    return this.createAvailableMethodsFor910();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private final Method[] createAvailableMethodsFor14() throws NoSuchMethodException, SecurityException {
        return new Method[]{XInput.class.getDeclaredMethod("XInputEnable", Boolean.TYPE), XInput.class.getDeclaredMethod("XInputGetCapabilities", Integer.TYPE, Integer.TYPE, XInputCapabilities.class), XInput.class.getDeclaredMethod("XInputGetAudioDeviceIds", Integer.TYPE, char[].class, LongByReference.class, char[].class, LongByReference.class), XInput.class.getDeclaredMethod("XInputGetBatteryInformation", Integer.TYPE, Integer.TYPE, XInputBatteryInformation.class), XInput.class.getDeclaredMethod("XInputGetState", Integer.TYPE, XInputState.class), XInput.class.getDeclaredMethod("XInputSetState", Integer.TYPE, XInputVibration.class), XInput.class.getDeclaredMethod("XInputGetKeystroke", Integer.TYPE, Integer.TYPE, XInputKeystroke.class)};
    }

    private final Method[] createAvailableMethodsFor13() throws NoSuchMethodException, SecurityException {
        return new Method[]{XInput.class.getDeclaredMethod("XInputEnable", Boolean.TYPE), XInput.class.getDeclaredMethod("XInputGetCapabilities", Integer.TYPE, Integer.TYPE, XInputCapabilities.class), XInput.class.getDeclaredMethod("XInputGetBatteryInformation", Integer.TYPE, Integer.TYPE, XInputBatteryInformation.class), XInput.class.getDeclaredMethod("XInputGetDSoundAudioDeviceGuids", Integer.TYPE, char[].class, char[].class), XInput.class.getDeclaredMethod("XInputGetState", Integer.TYPE, XInputState.class), XInput.class.getDeclaredMethod("XInputSetState", Integer.TYPE, XInputVibration.class), XInput.class.getDeclaredMethod("XInputGetKeystroke", Integer.TYPE, Integer.TYPE, XInputKeystroke.class)};
    }

    private final Method[] createAvailableMethodsFor910() throws NoSuchMethodException, SecurityException {
        return new Method[]{XInput.class.getDeclaredMethod("XInputGetCapabilities", Integer.TYPE, Integer.TYPE, XInputCapabilities.class), XInput.class.getDeclaredMethod("XInputGetDSoundAudioDeviceGuids", Integer.TYPE, char[].class, char[].class), XInput.class.getDeclaredMethod("XInputGetState", Integer.TYPE, XInputState.class), XInput.class.getDeclaredMethod("XInputSetState", Integer.TYPE, XInputVibration.class)};
    }

    public final boolean isAvailable(String func3) {
        for (Method method : this.availableMethods) {
            if (!method.getName().equals(func3)) continue;
            return true;
        }
        return false;
    }

    public final Method[] getAvailableMethods() {
        return Arrays.copyOf(this.availableMethods, this.availableMethods.length);
    }

    public final String getLoadedDLL() {
        return this.loadedDLL;
    }
}

