/*
 * Decompiled with CFR 0.152.
 */
package de.ralleytn.wrapper.microsoft.xinput;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.ptr.LongByReference;
import de.ralleytn.wrapper.microsoft.xinput.Info;
import de.ralleytn.wrapper.microsoft.xinput.XInputBatteryInformation;
import de.ralleytn.wrapper.microsoft.xinput.XInputCapabilities;
import de.ralleytn.wrapper.microsoft.xinput.XInputKeystroke;
import de.ralleytn.wrapper.microsoft.xinput.XInputState;
import de.ralleytn.wrapper.microsoft.xinput.XInputVibration;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public interface XInput
extends Library {
    public static final int ERROR_SUCCESS = 0;
    public static final int ERROR_EMPTY = 4306;
    public static final int ERROR_DEVICE_NOT_CONNECTED = 1167;
    public static final int XINPUT_KEYSTROKE_KEYDOWN = 1;
    public static final int XINPUT_KEYSTROKE_KEYUP = 2;
    public static final int XINPUT_KEYSTROKE_REPEAT = 4;
    public static final int XINPUT_DEVSUBTYPE_UNKNOWN = 0;
    public static final int XINPUT_DEVSUBTYPE_GAMEPAD = 1;
    public static final int XINPUT_DEVSUBTYPE_WHEEL = 2;
    public static final int XINPUT_DEVSUBTYPE_ARCADE_STICK = 3;
    public static final int XINPUT_DEVSUBTYPE_FLIGHT_STICK = 4;
    public static final int XINPUT_DEVSUBTYPE_DANCE_PAD = 5;
    public static final int XINPUT_DEVSUBTYPE_GUITAR = 6;
    public static final int XINPUT_DEVSUBTYPE_GUITAR_ALTERNATE = 7;
    public static final int XINPUT_DEVSUBTYPE_DRUM_KIT = 8;
    public static final int XINPUT_DEVSUBTYPE_GUITAR_BASS = 11;
    public static final int XINPUT_DEVSUBTYPE_ARCADE_PAD = 19;
    public static final int VK_PAD_A = 22528;
    public static final int VK_PAD_B = 22529;
    public static final int VK_PAD_X = 22530;
    public static final int VK_PAD_Y = 22531;
    public static final int VK_PAD_RSHOULDER = 22532;
    public static final int VK_PAD_LSHOULDER = 22533;
    public static final int VK_PAD_LTRIGGER = 22534;
    public static final int VK_PAD_RTRIGGER = 22535;
    public static final int VK_PAD_DPAD_UP = 22544;
    public static final int VK_PAD_DPAD_DOWN = 22545;
    public static final int VK_PAD_DPAD_LEFT = 22546;
    public static final int VK_PAD_DPAD_RIGHT = 22547;
    public static final int VK_PAD_START = 22548;
    public static final int VK_PAD_BACK = 22549;
    public static final int VK_PAD_LTHUMB_PRESS = 22550;
    public static final int VK_PAD_RTHUMB_PRESS = 22551;
    public static final int VK_PAD_LTHUMB_UP = 22560;
    public static final int VK_PAD_LTHUMB_DOWN = 22561;
    public static final int VK_PAD_LTHUMB_RIGHT = 22562;
    public static final int VK_PAD_LTHUMB_LEFT = 22563;
    public static final int VK_PAD_LTHUMB_UPLEFT = 22564;
    public static final int VK_PAD_LTHUMB_UPRIGHT = 22565;
    public static final int VK_PAD_LTHUMB_DOWNRIGHT = 22566;
    public static final int VK_PAD_LTHUMB_DOWNLEFT = 22567;
    public static final int VK_PAD_RTHUMB_UP = 22576;
    public static final int VK_PAD_RTHUMB_DOWN = 22577;
    public static final int VK_PAD_RTHUMB_RIGHT = 22578;
    public static final int VK_PAD_RTHUMB_LEFT = 22579;
    public static final int VK_PAD_RTHUMB_UPLEFT = 22580;
    public static final int VK_PAD_RTHUMB_UPRIGHT = 22581;
    public static final int VK_PAD_RTHUMB_DOWNRIGHT = 22582;
    public static final int VK_PAD_RTHUMB_DOWNLEFT = 22583;
    public static final int XINPUT_DEVTYPE_GAMEPAD = 1;
    public static final int XINPUT_GAMEPAD_DPAD_UP = 1;
    public static final int XINPUT_GAMEPAD_DPAD_DOWN = 2;
    public static final int XINPUT_GAMEPAD_DPAD_LEFT = 4;
    public static final int XINPUT_GAMEPAD_DPAD_RIGHT = 8;
    public static final int XINPUT_GAMEPAD_START = 16;
    public static final int XINPUT_GAMEPAD_BACK = 32;
    public static final int XINPUT_GAMEPAD_LEFT_THUMB = 64;
    public static final int XINPUT_GAMEPAD_LEFT_THUMB_DEADZONE = 7849;
    public static final int XINPUT_GAMEPAD_RIGHT_THUMB = 128;
    public static final int XINPUT_GAMEPAD_RIGHT_THUMB_DEADZONE = 8689;
    public static final int XINPUT_GAMEPAD_LEFT_SHOULDER = 256;
    public static final int XINPUT_GAMEPAD_RIGHT_SHOULDER = 512;
    public static final int XINPUT_GAMEPAD_A = 4096;
    public static final int XINPUT_GAMEPAD_B = 8192;
    public static final int XINPUT_GAMEPAD_X = 16384;
    public static final int XINPUT_GAMEPAD_Y = 32768;
    public static final int XINPUT_GAMEPAD_TRIGGER_THRESHOLD = 30;
    public static final int BATTERY_TYPE_DISCONNECTED = 0;
    public static final int BATTERY_TYPE_WIRED = 1;
    public static final int BATTERY_TYPE_ALKALINE = 2;
    public static final int BATTERY_TYPE_NIMH = 3;
    public static final int BATTERY_TYPE_UNKNOWN = 255;
    public static final int BATTERY_DEVTYPE_GAMEPAD = 0;
    public static final int BATTERY_DEVTYPE_HEADSET = 1;
    public static final int BATTERY_LEVEL_EMPTY = 0;
    public static final int BATTERY_LEVEL_LOW = 1;
    public static final int BATTERY_LEVEL_MEDIUM = 2;
    public static final int BATTERY_LEVEL_FULL = 3;
    public static final int XINPUT_CAPS_FFB_SUPPORTED = 1;
    public static final int XINPUT_CAPS_WIRELESS = 2;
    public static final int XINPUT_CAPS_VOICE_SUPPORTED = 4;
    public static final int XINPUT_CAPS_PMD_SUPPORTED = 8;
    public static final int XINPUT_CAPS_NO_NAVIGATION = 16;
    public static final int XINPUT_FLAG_GAMEPAD = 1;
    public static final int XUSER_INDEX_ANY = 255;
    public static final int XUSER_MAX_COUNT = 4;
    public static final Info INFO = new Info();

    public static XInput create() {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            String[] dlls = new String[]{"xinput1_4.dll", "xinput1_3.dll", "xinput9_1_0.dll"};
            String directory = System.getProperty("os.arch.dir");
            if (directory == null) {
                directory = "c:\\windows";
            }
            String vmType = System.getProperty("sun.arch.data.model");
            Path path = Paths.get(directory, vmType.equals("64") ? "SysWOW64" : "System32");
            for (String dll : dlls) {
                if (!Files.exists(path.resolve(dll), new LinkOption[0])) continue;
                System.setProperty("jna.library.path", path.resolve(dll).toString());
                INFO.setLoadedDLL(dll);
                return Native.load(dll, XInput.class);
            }
        }
        return null;
    }

    public void XInputEnable(boolean var1);

    public int XInputGetCapabilities(int var1, int var2, XInputCapabilities var3);

    public int XInputGetAudioDeviceIds(int var1, char[] var2, LongByReference var3, char[] var4, LongByReference var5);

    public int XInputGetBatteryInformation(int var1, int var2, XInputBatteryInformation var3);

    @Deprecated
    public int XInputGetDSoundAudioDeviceGuids(int var1, char[] var2, char[] var3);

    public int XInputGetState(int var1, XInputState var2);

    public int XInputSetState(int var1, XInputVibration var2);

    public int XInputGetKeystroke(int var1, int var2, XInputKeystroke var3);
}

