/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class ZonedDateTimeDeserializer
extends StdScalarDeserializer<ZonedDateTime> {
    public ZonedDateTimeDeserializer() {
        super(Long.TYPE);
    }

    @Override
    public ZonedDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        long value;
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT || t == JsonToken.VALUE_NUMBER_FLOAT) {
            value = jp.getLongValue();
        } else if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            try {
                value = Long.parseLong(str);
            }
            catch (NumberFormatException e) {
                throw ctxt.mappingException(this.handledType());
            }
        } else {
            throw ctxt.mappingException(this.handledType());
        }
        return Instant.ofEpochSecond(value).atZone(ZoneOffset.UTC);
    }
}

