/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi;

import io.github.leovr.rtipmidi.adapter.ShortMessageAdapter;
import io.github.leovr.rtipmidi.adapter.SysexMessageAdapter;
import io.github.leovr.rtipmidi.model.MidiMessage;
import io.github.leovr.rtipmidi.model.ShortMessage;
import io.github.leovr.rtipmidi.model.SysexMessage;

class JavaxMidiMessageConverter {
    JavaxMidiMessageConverter() {
    }

    javax.sound.midi.MidiMessage convert(MidiMessage message) {
        if (message instanceof ShortMessage) {
            return this.handleShortMessage((ShortMessage)message);
        }
        if (message instanceof SysexMessage) {
            return this.handleSysexMessage((SysexMessage)message);
        }
        throw new IllegalArgumentException("Message could not be converted");
    }

    MidiMessage convert(javax.sound.midi.MidiMessage message) {
        if (message instanceof javax.sound.midi.ShortMessage) {
            javax.sound.midi.ShortMessage shortMessage = (javax.sound.midi.ShortMessage)message;
            return new ShortMessage((byte)shortMessage.getCommand(), (byte)shortMessage.getData1(), (byte)shortMessage.getData2());
        }
        if (message instanceof javax.sound.midi.SysexMessage) {
            javax.sound.midi.SysexMessage sysexMessage = (javax.sound.midi.SysexMessage)message;
            return new SysexMessage(sysexMessage.getMessage(), sysexMessage.getLength());
        }
        throw new IllegalArgumentException("Message could not be converted");
    }

    private javax.sound.midi.MidiMessage handleSysexMessage(SysexMessage message) {
        return new SysexMessageAdapter(message);
    }

    private javax.sound.midi.MidiMessage handleShortMessage(ShortMessage message) {
        return new ShortMessageAdapter(message);
    }
}

