/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.control;

import io.github.leovr.rtipmidi.AppleMidiCommandListener;
import io.github.leovr.rtipmidi.AppleMidiServer;
import io.github.leovr.rtipmidi.EndSessionListener;
import io.github.leovr.rtipmidi.error.AppleMidiControlServerRuntimeException;
import io.github.leovr.rtipmidi.handler.AppleMidiCommandHandler;
import io.github.leovr.rtipmidi.messages.AppleMidiClockSynchronization;
import io.github.leovr.rtipmidi.messages.AppleMidiCommand;
import io.github.leovr.rtipmidi.messages.AppleMidiEndSession;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitation;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationAccepted;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationDeclined;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationRequest;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleMidiControlServer
extends Thread
implements AppleMidiCommandListener {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiControlServer.class);
    private static final int SOCKET_TIMEOUT = 1000;
    private static final int RECEIVE_BUFFER_LENGTH = 1024;
    private static final String THREAD_SUFFIX = "ControlThread";
    private final int port;
    private int maxNumberOfSessions;
    private boolean running = true;
    private int ssrc;
    private final AppleMidiServer server;
    private final String name;
    private final InetAddress inetAddress;
    private final AppleMidiCommandHandler handler;
    private DatagramSocket socket;
    private final List<AppleMidiServerAddress> acceptedServers = new ArrayList<AppleMidiServerAddress>();
    private final List<EndSessionListener> endSessionListeners = new ArrayList<EndSessionListener>();

    public AppleMidiControlServer(InetAddress inetAddress, @Nonnull String name, int port, AppleMidiServer server) {
        this(new AppleMidiCommandHandler(), inetAddress, name, port, server);
    }

    AppleMidiControlServer(@Nonnull AppleMidiCommandHandler handler, InetAddress inetAddress, @Nonnull String name, int port, AppleMidiServer server) {
        super(name + THREAD_SUFFIX);
        this.handler = handler;
        this.server = server;
        this.port = port;
        this.inetAddress = inetAddress;
        this.name = name;
        handler.registerListener(this);
    }

    @Override
    public synchronized void start() {
        try {
            this.socket = this.initDatagramSocket();
            this.socket.setSoTimeout(1000);
            this.initialize(this.inetAddress.getHostName());
        }
        catch (SocketException e) {
            e.printStackTrace(System.err);
            throw new AppleMidiControlServerRuntimeException("DatagramSocket cannot be opened", e);
        }
        super.start();
        log.debug("MIDI control server started");
    }

    private void initialize(String hostName) {
        this.ssrc = this.createSsrc(hostName);
    }

    private int createSsrc(String hostName) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(String.valueOf(new Date().getTime()).getBytes());
            md.update(String.valueOf(System.identityHashCode(this)).getBytes());
            md.update(Paths.get("", new String[0]).toAbsolutePath().normalize().toString().getBytes());
            md.update(hostName.getBytes());
            byte[] md5 = md.digest();
            int ssrc = 0;
            ByteBuffer byteBuffer = ByteBuffer.wrap(md5);
            for (int i = 0; i < 3; ++i) {
                ssrc ^= byteBuffer.getInt();
            }
            return ssrc;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not get MD5 algorithm", e);
        }
    }

    DatagramSocket initDatagramSocket() throws SocketException {
        return new DatagramSocket(new InetSocketAddress(this.inetAddress, this.port));
    }

    public void stopServer() {
        for (AppleMidiServerAddress server : this.acceptedServers) {
            try {
                log.info("Sending end session to {}", (Object)server);
                this.send(new AppleMidiEndSession(2, this.getNewInitiatorToken(), this.ssrc), server);
            }
            catch (IOException e) {
                log.info("Error closing session with server: {}", (Object)server, (Object)e);
            }
        }
        this.running = false;
        this.acceptedServers.clear();
        log.debug("MIDI control server stopped");
    }

    int getNewInitiatorToken() {
        return new Random().nextInt();
    }

    @Override
    public void run() {
        System.err.println("AppleMidiControlServer.run();");
        while (this.running) {
            try {
                byte[] receiveData = new byte[1024];
                DatagramPacket incomingPacket = this.initDatagramPacket(receiveData);
                this.socket.receive(incomingPacket);
                this.handler.handle(receiveData, new AppleMidiServerAddress(incomingPacket.getAddress(), incomingPacket.getPort()));
            }
            catch (SocketTimeoutException receiveData) {
            }
            catch (IOException e) {
                log.error("IOException while receiving", e);
            }
        }
        this.socket.close();
    }

    DatagramPacket initDatagramPacket(byte[] receiveData) {
        return new DatagramPacket(receiveData, receiveData.length);
    }

    @Override
    public void onMidiInvitation(@Nonnull AppleMidiInvitationRequest invitation, @Nonnull AppleMidiServerAddress appleMidiServer) {
        log.info("MIDI invitation from: {}", (Object)appleMidiServer);
        boolean contains = this.acceptedServers.contains(appleMidiServer);
        if (contains) {
            log.info("Server {} was still in accepted servers list. Removing old entry.", (Object)appleMidiServer);
            this.onEndSession(new AppleMidiEndSession(invitation.getProtocolVersion(), invitation.getInitiatorToken(), invitation.getSsrc()), appleMidiServer);
        }
        if (this.getServerState() == State.ACCEPT_INVITATIONS) {
            this.sendMidiInvitationAnswer(appleMidiServer, "accept", new AppleMidiInvitationAccepted(invitation.getProtocolVersion(), invitation.getInitiatorToken(), this.ssrc, this.name));
            this.acceptedServers.add(appleMidiServer);
        } else {
            this.sendMidiInvitationAnswer(appleMidiServer, "decline", new AppleMidiInvitationDeclined(invitation.getProtocolVersion(), invitation.getInitiatorToken(), this.ssrc, this.name));
        }
    }

    private void sendMidiInvitationAnswer(AppleMidiServerAddress appleMidiServer, String type, AppleMidiInvitation midiInvitation) {
        try {
            log.info("Sending invitation {} to: {}", (Object)type, (Object)appleMidiServer);
            this.send(midiInvitation, appleMidiServer);
        }
        catch (IOException e) {
            log.error("IOException while sending invitation {}", (Object)type, (Object)e);
        }
    }

    private void send(AppleMidiCommand midiCommand, AppleMidiServerAddress appleMidiServer) throws IOException {
        byte[] invitationAcceptedBytes = midiCommand.toByteArray();
        this.socket.send(new DatagramPacket(invitationAcceptedBytes, invitationAcceptedBytes.length, appleMidiServer.getInetAddress(), appleMidiServer.getPort()));
    }

    @Override
    public void onClockSynchronization(@Nonnull AppleMidiClockSynchronization clockSynchronization, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    private State getServerState() {
        return this.server.getAppleMidiSession() != null ? State.ACCEPT_INVITATIONS : State.FULL;
    }

    @Override
    public void onEndSession(@Nonnull AppleMidiEndSession appleMidiEndSession, @Nonnull AppleMidiServerAddress appleMidiServer) {
        log.info("Session ended with: {}", (Object)appleMidiServer);
        this.acceptedServers.remove(appleMidiServer);
        for (EndSessionListener listener : this.endSessionListeners) {
            listener.onEndSession(appleMidiEndSession, appleMidiServer);
        }
    }

    public void closeConnection(InetAddress address, int port) {
        AppleMidiServerAddress dServer = null;
        for (AppleMidiServerAddress server : this.acceptedServers) {
            if (!server.getInetAddress().equals(address) || server.getPort() != port) continue;
            dServer = server;
        }
        if (dServer != null) {
            System.err.println("Found Control connection to close " + dServer.toString());
            try {
                AppleMidiEndSession goodbye = new AppleMidiEndSession(2, this.getNewInitiatorToken(), this.ssrc);
                this.send(goodbye, dServer);
                this.onEndSession(goodbye, dServer);
            }
            catch (Exception e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    public void registerEndSessionListener(EndSessionListener listener) {
        this.endSessionListeners.add(listener);
    }

    public void unregisterEndSessionListener(EndSessionListener listener) {
        this.endSessionListeners.remove(listener);
    }

    @Override
    public void onMidiInvitationAccepted(@Nonnull AppleMidiInvitationAccepted acceptance, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    @Override
    public void onMidiInvitationDeclined(@Nonnull AppleMidiInvitationDeclined decline, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    public int getMaxNumberOfSessions() {
        return this.maxNumberOfSessions;
    }

    public void setMaxNumberOfSessions(int maxNumberOfSessions) {
        this.maxNumberOfSessions = maxNumberOfSessions;
    }

    void setSsrc(int ssrc) {
        this.ssrc = ssrc;
    }

    private static enum State {
        ACCEPT_INVITATIONS,
        FULL;

    }
}

