/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.handler;

import io.github.leovr.rtipmidi.AppleMidiCommandListener;
import io.github.leovr.rtipmidi.messages.AppleMidiClockSynchronization;
import io.github.leovr.rtipmidi.messages.AppleMidiEndSession;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationAccepted;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationDeclined;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationRequest;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppleMidiCommandLogListener
implements AppleMidiCommandListener {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiCommandLogListener.class);

    AppleMidiCommandLogListener() {
    }

    @Override
    public void onMidiInvitation(@Nonnull AppleMidiInvitationRequest invitation, @Nonnull AppleMidiServerAddress appleMidiServer) {
        log.trace("MIDI invitation: invitation: {}, appleMidiServer: {}", (Object)invitation, (Object)appleMidiServer);
    }

    @Override
    public void onClockSynchronization(@Nonnull AppleMidiClockSynchronization clockSynchronization, @Nonnull AppleMidiServerAddress appleMidiServer) {
        log.trace("MIDI clock synchronization: clockSynchronization: {}, appleMidiServer: {}", (Object)clockSynchronization, (Object)appleMidiServer);
    }

    @Override
    public void onEndSession(@Nonnull AppleMidiEndSession appleMidiEndSession, @Nonnull AppleMidiServerAddress appleMidiServer) {
        log.trace("MIDI end session: appleMidiEndSession: {}, appleMidiServer: {}", (Object)appleMidiEndSession, (Object)appleMidiServer);
    }

    @Override
    public void onMidiInvitationAccepted(@Nonnull AppleMidiInvitationAccepted acceptance, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    @Override
    public void onMidiInvitationDeclined(@Nonnull AppleMidiInvitationDeclined decline, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }
}

