/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.messages;

import io.github.leovr.rtipmidi.messages.AppleMidiCommand;
import io.github.leovr.rtipmidi.messages.CommandWord;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class AppleMidiClockSynchronization
extends AppleMidiCommand {
    private final byte count;
    private final long timestamp1;
    private final long timestamp2;
    private final long timestamp3;

    public AppleMidiClockSynchronization(int ssrc, byte count, long timestamp1, long timestamp2, long timestamp3) {
        super(CommandWord.CK, ssrc);
        this.count = count;
        this.timestamp1 = timestamp1;
        this.timestamp2 = timestamp2;
        this.timestamp3 = timestamp3;
    }

    @Override
    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.write(-1);
        dataOutputStream.write(-1);
        dataOutputStream.write(this.getCommandWord().name().getBytes(StandardCharsets.UTF_8));
        dataOutputStream.writeInt(this.getSsrc());
        dataOutputStream.writeByte(this.count);
        dataOutputStream.write(new byte[3]);
        dataOutputStream.writeLong(this.timestamp1);
        dataOutputStream.writeLong(this.timestamp2);
        dataOutputStream.writeLong(this.timestamp3);
        dataOutputStream.flush();
        return outputStream.toByteArray();
    }

    public byte getCount() {
        return this.count;
    }

    public long getTimestamp1() {
        return this.timestamp1;
    }

    public long getTimestamp2() {
        return this.timestamp2;
    }

    public long getTimestamp3() {
        return this.timestamp3;
    }

    @Override
    public String toString() {
        return "AppleMidiClockSynchronization(super=" + super.toString() + ", count=" + this.getCount() + ", timestamp1=" + this.getTimestamp1() + ", timestamp2=" + this.getTimestamp2() + ", timestamp3=" + this.getTimestamp3() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppleMidiClockSynchronization)) {
            return false;
        }
        AppleMidiClockSynchronization other = (AppleMidiClockSynchronization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.getTimestamp1() != other.getTimestamp1()) {
            return false;
        }
        if (this.getTimestamp2() != other.getTimestamp2()) {
            return false;
        }
        return this.getTimestamp3() == other.getTimestamp3();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AppleMidiClockSynchronization;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCount();
        long $timestamp1 = this.getTimestamp1();
        result = result * 59 + (int)($timestamp1 >>> 32 ^ $timestamp1);
        long $timestamp2 = this.getTimestamp2();
        result = result * 59 + (int)($timestamp2 >>> 32 ^ $timestamp2);
        long $timestamp3 = this.getTimestamp3();
        result = result * 59 + (int)($timestamp3 >>> 32 ^ $timestamp3);
        return result;
    }
}

