/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.messages;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class RtpHeader {
    private final byte version;
    private final boolean paddingFlag;
    private final boolean extensionFlag;
    private final byte contributingSourceIdentifiersCount;
    private final boolean markerFlag;
    private final byte payloadType;
    private final short sequenceNumber;
    private final int timestamp;
    private final int ssrc;

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(12);
        DataOutputStream outputStream = new DataOutputStream(byteArrayOutputStream);
        int header1 = 0;
        header1 = (byte)(header1 | this.version << 6);
        header1 = (byte)(header1 | (this.paddingFlag ? 1 : 0) << 5);
        header1 = (byte)(header1 | (this.extensionFlag ? 1 : 0) << 4);
        header1 = (byte)(header1 | this.contributingSourceIdentifiersCount);
        outputStream.writeByte(header1);
        int header2 = 0;
        header2 = (byte)(header2 | (this.markerFlag ? 1 : 0) << 7);
        header2 = (byte)(header2 | this.payloadType);
        outputStream.writeByte(header2);
        outputStream.writeShort(this.sequenceNumber);
        outputStream.writeInt(this.timestamp);
        outputStream.writeInt(this.ssrc);
        outputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public RtpHeader(byte version, boolean paddingFlag, boolean extensionFlag, byte contributingSourceIdentifiersCount, boolean markerFlag, byte payloadType, short sequenceNumber, int timestamp, int ssrc) {
        this.version = version;
        this.paddingFlag = paddingFlag;
        this.extensionFlag = extensionFlag;
        this.contributingSourceIdentifiersCount = contributingSourceIdentifiersCount;
        this.markerFlag = markerFlag;
        this.payloadType = payloadType;
        this.sequenceNumber = sequenceNumber;
        this.timestamp = timestamp;
        this.ssrc = ssrc;
    }

    public byte getVersion() {
        return this.version;
    }

    public boolean isPaddingFlag() {
        return this.paddingFlag;
    }

    public boolean isExtensionFlag() {
        return this.extensionFlag;
    }

    public byte getContributingSourceIdentifiersCount() {
        return this.contributingSourceIdentifiersCount;
    }

    public boolean isMarkerFlag() {
        return this.markerFlag;
    }

    public byte getPayloadType() {
        return this.payloadType;
    }

    public short getSequenceNumber() {
        return this.sequenceNumber;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getSsrc() {
        return this.ssrc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtpHeader)) {
            return false;
        }
        RtpHeader other = (RtpHeader)o;
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isPaddingFlag() != other.isPaddingFlag()) {
            return false;
        }
        if (this.isExtensionFlag() != other.isExtensionFlag()) {
            return false;
        }
        if (this.getContributingSourceIdentifiersCount() != other.getContributingSourceIdentifiersCount()) {
            return false;
        }
        if (this.isMarkerFlag() != other.isMarkerFlag()) {
            return false;
        }
        if (this.getPayloadType() != other.getPayloadType()) {
            return false;
        }
        if (this.getSequenceNumber() != other.getSequenceNumber()) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        return this.getSsrc() == other.getSsrc();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVersion();
        result = result * 59 + (this.isPaddingFlag() ? 79 : 97);
        result = result * 59 + (this.isExtensionFlag() ? 79 : 97);
        result = result * 59 + this.getContributingSourceIdentifiersCount();
        result = result * 59 + (this.isMarkerFlag() ? 79 : 97);
        result = result * 59 + this.getPayloadType();
        result = result * 59 + this.getSequenceNumber();
        result = result * 59 + this.getTimestamp();
        result = result * 59 + this.getSsrc();
        return result;
    }

    public String toString() {
        return "RtpHeader(version=" + this.getVersion() + ", paddingFlag=" + this.isPaddingFlag() + ", extensionFlag=" + this.isExtensionFlag() + ", contributingSourceIdentifiersCount=" + this.getContributingSourceIdentifiersCount() + ", markerFlag=" + this.isMarkerFlag() + ", payloadType=" + this.getPayloadType() + ", sequenceNumber=" + this.getSequenceNumber() + ", timestamp=" + this.getTimestamp() + ", ssrc=" + this.getSsrc() + ")";
    }
}

