/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.session;

import io.github.leovr.rtipmidi.messages.AppleMidiMessage;
import io.github.leovr.rtipmidi.messages.MidiCommandHeader;
import io.github.leovr.rtipmidi.messages.MidiTimestampPair;
import io.github.leovr.rtipmidi.messages.RtpHeader;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import io.github.leovr.rtipmidi.model.MidiMessage;
import io.github.leovr.rtipmidi.session.AppleMidiMessageSender;
import io.github.leovr.rtipmidi.session.AppleMidiSession;
import io.github.leovr.rtipmidi.session.AppleMidiSessionSender;
import java.io.IOException;
import java.util.Collections;
import java.util.Random;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AppleMidiSessionConnection
implements AppleMidiSessionSender {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiSessionConnection.class);
    @Nonnull
    private final AppleMidiSession appleMidiSession;
    @Nonnull
    private final AppleMidiServerAddress appleMidiServerAddress;
    private final int ssrc;
    @Nonnull
    private final AppleMidiMessageSender appleMidiMessageSender;
    private int initiatorToken;
    private String name;
    private short sequenceNumber = (short)new Random().nextInt(32768);

    public AppleMidiSessionConnection(@Nonnull AppleMidiSession appleMidiSession, @Nonnull AppleMidiServerAddress appleMidiServer, int ssrc, @Nonnull AppleMidiMessageSender appleMidiMessageSender) {
        this.appleMidiSession = appleMidiSession;
        this.appleMidiServerAddress = appleMidiServer;
        this.ssrc = ssrc;
        this.appleMidiMessageSender = appleMidiMessageSender;
    }

    public void setInitiatorToken(int initiatorToken) {
        this.initiatorToken = initiatorToken;
    }

    public int getInitiatorToken() {
        return this.initiatorToken;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void sendMidiMessage(@Nonnull MidiMessage message, long timestamp) {
        this.sequenceNumber = (short)(this.sequenceNumber + 1);
        long currentTimeIn100Microseconds = this.appleMidiSession.getCurrentTimestamp();
        int rtpTimestamp = (int)currentTimeIn100Microseconds;
        RtpHeader rtpHeader = new RtpHeader(2, false, false, 0, false, 97, this.sequenceNumber, rtpTimestamp, this.ssrc);
        log.trace("Sending RTP-Header: {}", (Object)rtpHeader);
        boolean b = message.getLength() > 15;
        MidiCommandHeader midiCommandHeader = new MidiCommandHeader(b, false, false, false, (short)message.getLength(), rtpHeader);
        AppleMidiMessage appleMidiMessage = new AppleMidiMessage(midiCommandHeader, Collections.singletonList(new MidiTimestampPair(0, message)));
        try {
            this.appleMidiMessageSender.send(appleMidiMessage, this.appleMidiServerAddress);
        }
        catch (IOException e) {
            log.error("Error sending MidiMessage to {}", (Object)this.appleMidiServerAddress, (Object)e);
            e.printStackTrace(System.err);
        }
    }

    @Nonnull
    public AppleMidiSession getAppleMidiSession() {
        return this.appleMidiSession;
    }

    @Nonnull
    public AppleMidiServerAddress getAppleMidiServerAddress() {
        return this.appleMidiServerAddress;
    }

    public int getSsrc() {
        return this.ssrc;
    }

    @Nonnull
    public AppleMidiMessageSender getAppleMidiMessageSender() {
        return this.appleMidiMessageSender;
    }
}

