/*
 * Decompiled with CFR 0.152.
 */
package io.github.leovr.rtipmidi.session;

import io.github.leovr.rtipmidi.AppleMidiCommandListener;
import io.github.leovr.rtipmidi.AppleMidiMessageListener;
import io.github.leovr.rtipmidi.AppleMidiServer;
import io.github.leovr.rtipmidi.error.AppleMidiSessionServerRuntimeException;
import io.github.leovr.rtipmidi.handler.AppleMidiCommandHandler;
import io.github.leovr.rtipmidi.handler.AppleMidiMessageHandler;
import io.github.leovr.rtipmidi.messages.AppleMidiClockSynchronization;
import io.github.leovr.rtipmidi.messages.AppleMidiCommand;
import io.github.leovr.rtipmidi.messages.AppleMidiEndSession;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitation;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationAccepted;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationDeclined;
import io.github.leovr.rtipmidi.messages.AppleMidiInvitationRequest;
import io.github.leovr.rtipmidi.messages.AppleMidiMessage;
import io.github.leovr.rtipmidi.messages.MidiCommandHeader;
import io.github.leovr.rtipmidi.model.AppleMidiServerAddress;
import io.github.leovr.rtipmidi.model.MidiMessage;
import io.github.leovr.rtipmidi.session.AppleMidiMessageSender;
import io.github.leovr.rtipmidi.session.AppleMidiSession;
import io.github.leovr.rtipmidi.session.AppleMidiSessionConnection;
import io.github.leovr.rtipmidi.session.SessionChangeListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppleMidiSessionServer
implements AppleMidiCommandListener,
AppleMidiMessageListener,
Runnable,
AppleMidiMessageSender {
    private static final Logger log = LoggerFactory.getLogger(AppleMidiSessionServer.class);
    private static final int SOCKET_TIMEOUT = 1000;
    private static final int RECEIVE_BUFFER_LENGTH = 1024;
    private final AppleMidiServer server;
    private final ExecutorService executorService;
    private final int ssrc;
    private final String name;
    private final InetAddress inetAddress;
    private final AppleMidiCommandHandler midiCommandHandler = new AppleMidiCommandHandler();
    private final AppleMidiMessageHandler midiMessageHandler = new AppleMidiMessageHandler();
    private final int port;
    private boolean running = true;
    private DatagramSocket socket;
    private final Map<Integer, AppleMidiSessionConnection> currentSessions = new HashMap<Integer, AppleMidiSessionConnection>();
    private final List<SessionChangeListener> sessionChangeListeners = new ArrayList<SessionChangeListener>();
    private Thread thread;

    public AppleMidiSessionServer(InetAddress inetAddress, @Nonnull String name, int port, AppleMidiServer server) {
        this(inetAddress, name, port, Executors.newCachedThreadPool(), server);
    }

    AppleMidiSessionServer(InetAddress inetAddress, @Nonnull String name, int port, ExecutorService executorService, AppleMidiServer server) {
        this.port = port;
        this.ssrc = new Random().nextInt();
        this.name = name;
        this.server = server;
        this.executorService = executorService;
        this.inetAddress = inetAddress;
        this.midiCommandHandler.registerListener(this);
        this.midiMessageHandler.registerListener(this);
    }

    Thread createThread(@Nonnull String name) {
        return new Thread((Runnable)this, name + "SessionThread");
    }

    public synchronized void start() {
        this.thread = this.createThread(this.name);
        try {
            this.socket = this.createSocket();
            this.socket.setSoTimeout(1000);
        }
        catch (SocketException e) {
            throw new AppleMidiSessionServerRuntimeException("DatagramSocket cannot be opened", e);
        }
        this.thread.start();
        log.debug("MIDI session server started");
    }

    DatagramSocket createSocket() throws SocketException {
        return new DatagramSocket(this.port, this.inetAddress);
    }

    private static String cleanAddress(InetAddress address) {
        if (address != null) {
            String sAddress = address.toString();
            if (sAddress == null) {
                sAddress = "";
            }
            if (sAddress.startsWith("/")) {
                sAddress = sAddress.substring(1);
            }
            return sAddress;
        }
        return "";
    }

    public boolean hasConnection(String remoteName, InetAddress address, int port) {
        String sAddress = AppleMidiSessionServer.cleanAddress(address);
        for (AppleMidiSessionConnection connection : this.currentSessions.values()) {
            AppleMidiServerAddress server = connection.getAppleMidiServerAddress();
            String rAddress = AppleMidiSessionServer.cleanAddress(server.getInetAddress());
            if (!rAddress.equals(sAddress) || !remoteName.equals(connection.getName())) continue;
            return true;
        }
        return false;
    }

    public void closeConnection(InetAddress address, int port) {
        AppleMidiSessionConnection conn = null;
        int rSsrc = 0;
        for (Map.Entry<Integer, AppleMidiSessionConnection> sessionConnection : this.currentSessions.entrySet()) {
            AppleMidiServerAddress server = sessionConnection.getValue().getAppleMidiServerAddress();
            if (!server.getInetAddress().equals(address) || server.getPort() != port) continue;
            conn = sessionConnection.getValue();
            rSsrc = sessionConnection.getKey();
        }
        if (conn != null) {
            try {
                AppleMidiServerAddress server = conn.getAppleMidiServerAddress();
                System.err.println("Found Session connection to close " + server.toString());
                AppleMidiEndSession goodbye = new AppleMidiEndSession(2, conn.getInitiatorToken(), rSsrc);
                this.send(goodbye, server);
                this.onEndSession(goodbye, server);
            }
            catch (Exception e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                final byte[] receiveData = new byte[1024];
                final DatagramPacket incomingPacket = new DatagramPacket(receiveData, receiveData.length);
                this.socket.receive(incomingPacket);
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (receiveData[0] == -1) {
                            AppleMidiSessionServer.this.midiCommandHandler.handle(receiveData, new AppleMidiServerAddress(incomingPacket.getAddress(), incomingPacket.getPort()));
                        } else {
                            AppleMidiSessionServer.this.midiMessageHandler.handle(receiveData, new AppleMidiServerAddress(incomingPacket.getAddress(), incomingPacket.getPort()));
                        }
                    }
                });
            }
            catch (SocketTimeoutException receiveData) {
            }
            catch (IOException e) {
                log.error("IOException while receiving", e);
            }
        }
        this.socket.close();
    }

    public void stopServer() {
        this.running = false;
        this.currentSessions.clear();
        this.executorService.shutdown();
        log.debug("MIDI session server stopped");
    }

    private void send(AppleMidiCommand midiCommand, AppleMidiServerAddress appleMidiServer) throws IOException {
        this.send(midiCommand.toByteArray(), appleMidiServer);
    }

    private void send(byte[] data, AppleMidiServerAddress appleMidiServer) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace("Sending data {} to server {}", (Object)Hex.encodeHexString(data), (Object)appleMidiServer);
        }
        this.socket.send(new DatagramPacket(data, data.length, appleMidiServer.getInetAddress(), appleMidiServer.getPort()));
    }

    @Override
    public void send(@Nonnull AppleMidiMessage appleMidiMessage, @Nonnull AppleMidiServerAddress appleMidiServer) throws IOException {
        this.send(appleMidiMessage.toByteArray(), appleMidiServer);
    }

    @Override
    public void onMidiInvitation(@Nonnull AppleMidiInvitationRequest invitation, @Nonnull AppleMidiServerAddress appleMidiServer) {
        log.info("MIDI invitation from: {}", (Object)appleMidiServer);
        if (this.getSessionServerState() == State.ACCEPT_INVITATIONS) {
            this.sendMidiInvitationAnswer(appleMidiServer, "accept", new AppleMidiInvitationAccepted(invitation.getProtocolVersion(), invitation.getInitiatorToken(), this.ssrc, this.name));
            AppleMidiSessionConnection connection = new AppleMidiSessionConnection(this.server.getAppleMidiSession(), appleMidiServer, this.ssrc, this);
            connection.setInitiatorToken(invitation.getInitiatorToken());
            connection.setName(invitation.getName());
            this.server.getAppleMidiSession().addSender(connection);
            this.currentSessions.put(invitation.getSsrc(), connection);
        } else {
            this.sendMidiInvitationAnswer(appleMidiServer, "decline", new AppleMidiInvitationDeclined(invitation.getProtocolVersion(), invitation.getInitiatorToken(), this.ssrc, this.name));
        }
    }

    @Override
    public void onMidiInvitationAccepted(@Nonnull AppleMidiInvitationAccepted acceptance, @Nonnull AppleMidiServerAddress appleMidiServer) {
        System.err.println("Midi Invitation Accepted - SessionServer");
    }

    private State getSessionServerState() {
        return this.server.getAppleMidiSession() == null ? State.FULL : State.ACCEPT_INVITATIONS;
    }

    private void sendMidiInvitationAnswer(AppleMidiServerAddress appleMidiServer, String type, AppleMidiInvitation midiInvitation) {
        try {
            log.info("Sending invitation {} to: {}", (Object)type, (Object)appleMidiServer);
            this.send(midiInvitation, appleMidiServer);
        }
        catch (IOException e) {
            log.error("IOException while sending invitation {}", (Object)type, (Object)e);
        }
    }

    @Override
    public void onClockSynchronization(@Nonnull AppleMidiClockSynchronization clockSynchronization, @Nonnull AppleMidiServerAddress appleMidiServer) {
        if (clockSynchronization.getCount() == 0) {
            long sessionTimestamp;
            AppleMidiSessionConnection sessionTuple = this.currentSessions.get(clockSynchronization.getSsrc());
            long currentTimestamp = sessionTuple != null ? ((sessionTimestamp = sessionTuple.getAppleMidiSession().getCurrentTimestamp()) != -1L ? sessionTimestamp : this.getFallbackTimestamp()) : this.getFallbackTimestamp();
            log.debug("Answering with timestamp: {}", (Object)currentTimestamp);
            AppleMidiClockSynchronization clockSynchronizationAnswer = new AppleMidiClockSynchronization(this.ssrc, 1, clockSynchronization.getTimestamp1(), currentTimestamp, 0L);
            try {
                this.send(clockSynchronizationAnswer, appleMidiServer);
            }
            catch (IOException e) {
                log.error("IOException while sending clock synchronization", e);
            }
        } else if (clockSynchronization.getCount() == 2) {
            long offsetEstimate = (clockSynchronization.getTimestamp3() + clockSynchronization.getTimestamp1()) / 2L - clockSynchronization.getTimestamp2();
            AppleMidiSessionConnection midiServer = this.currentSessions.get(clockSynchronization.getSsrc());
            if (midiServer != null) {
                midiServer.getAppleMidiSession().setOffsetEstimate(offsetEstimate);
            }
        }
    }

    private long getFallbackTimestamp() {
        return ManagementFactory.getRuntimeMXBean().getUptime() * 10L;
    }

    @Override
    public void onEndSession(@Nonnull AppleMidiEndSession appleMidiEndSession, @Nonnull AppleMidiServerAddress appleMidiServer) {
        AppleMidiSessionConnection sessionTuple;
        log.info("Session end from: {}", (Object)appleMidiServer);
        AppleMidiSessionConnection midiServer = this.currentSessions.get(appleMidiEndSession.getSsrc());
        if (midiServer != null) {
            AppleMidiSession appleMidiSession = midiServer.getAppleMidiSession();
            appleMidiSession.removeSender(midiServer);
            appleMidiSession.onEndSession(appleMidiEndSession, appleMidiServer);
        }
        if ((sessionTuple = this.currentSessions.remove(appleMidiEndSession.getSsrc())) != null) {
            System.err.println("sessionTuple Removed");
        }
    }

    @Override
    public void onMidiMessage(MidiCommandHeader midiCommandHeader, MidiMessage message, int timestamp) {
        AppleMidiSessionConnection sessionTuple = this.currentSessions.get(midiCommandHeader.getRtpHeader().getSsrc());
        if (sessionTuple != null) {
            sessionTuple.getAppleMidiSession().onMidiMessage(midiCommandHeader, message, timestamp);
        } else {
            log.debug("Could not find session for ssrc: {}", (Object)this.ssrc);
        }
    }

    public void registerSessionChangeListener(@Nonnull SessionChangeListener listener) {
        this.sessionChangeListeners.add(listener);
    }

    public void unregisterSessionChangeListener(@Nonnull SessionChangeListener listener) {
        this.sessionChangeListeners.remove(listener);
    }

    @Override
    public void onMidiInvitationDeclined(@Nonnull AppleMidiInvitationDeclined decline, @Nonnull AppleMidiServerAddress appleMidiServer) {
    }

    private static enum State {
        ACCEPT_INVITATIONS,
        FULL;

    }
}

