/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.tasks.state;

import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.impl.DNSOutgoing;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.JmDNSImpl;
import javax.jmdns.impl.ServiceInfoImpl;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSState;
import javax.jmdns.impl.tasks.state.DNSStateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Prober
extends DNSStateTask {
    static Logger logger = LoggerFactory.getLogger(Prober.class.getName());

    public Prober(JmDNSImpl jmDNSImpl) {
        super(jmDNSImpl, Prober.defaultTTL());
        this.setTaskState(DNSState.PROBING_1);
        this.associate(DNSState.PROBING_1);
    }

    @Override
    public String getName() {
        return "Prober(" + (this.getDns() != null ? this.getDns().getName() : "") + ")";
    }

    @Override
    public String toString() {
        return super.toString() + " state: " + (Object)((Object)this.getTaskState());
    }

    @Override
    public void start(Timer timer) {
        long now = System.currentTimeMillis();
        if (now - this.getDns().getLastThrottleIncrement() < 5000L) {
            this.getDns().setThrottle(this.getDns().getThrottle() + 1);
        } else {
            this.getDns().setThrottle(1);
        }
        this.getDns().setLastThrottleIncrement(now);
        if (this.getDns().isAnnounced() && this.getDns().getThrottle() < 10) {
            timer.schedule((TimerTask)this, JmDNSImpl.getRandom().nextInt(251), 250L);
        } else if (!this.getDns().isCanceling() && !this.getDns().isCanceled()) {
            timer.schedule((TimerTask)this, 1000L, 1000L);
        }
    }

    @Override
    public boolean cancel() {
        this.removeAssociation();
        return super.cancel();
    }

    @Override
    public String getTaskDescription() {
        return "probing";
    }

    @Override
    protected boolean checkRunCondition() {
        return !this.getDns().isCanceling() && !this.getDns().isCanceled();
    }

    @Override
    protected DNSOutgoing createOugoing() {
        return new DNSOutgoing(0);
    }

    @Override
    protected DNSOutgoing buildOutgoingForDNS(DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        newOut.addQuestion(DNSQuestion.newQuestion(this.getDns().getLocalHost().getName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
        for (DNSRecord answer : this.getDns().getLocalHost().answers(DNSRecordClass.CLASS_ANY, false, this.getTTL())) {
            newOut = this.addAuthoritativeAnswer(newOut, answer);
        }
        return newOut;
    }

    @Override
    protected DNSOutgoing buildOutgoingForInfo(ServiceInfoImpl info, DNSOutgoing out) throws IOException {
        DNSOutgoing newOut = out;
        newOut = this.addQuestion(newOut, DNSQuestion.newQuestion(info.getQualifiedName(), DNSRecordType.TYPE_ANY, DNSRecordClass.CLASS_IN, false));
        newOut = this.addAuthoritativeAnswer(newOut, new DNSRecord.Service(info.getQualifiedName(), DNSRecordClass.CLASS_IN, false, this.getTTL(), info.getPriority(), info.getWeight(), info.getPort(), this.getDns().getLocalHost().getName()));
        return newOut;
    }

    @Override
    protected void recoverTask(Throwable e) {
        this.getDns().recover();
    }

    @Override
    protected void advanceTask() {
        this.setTaskState(this.getTaskState().advance());
        if (!this.getTaskState().isProbing()) {
            this.cancel();
            this.getDns().startAnnouncer();
        }
    }
}

