/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.openstatic.MidiAPIPort;
import org.openstatic.MidiControlRule;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiControl;
import org.openstatic.midi.MidiControlListener;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortListener;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.MidiPortMapping;
import org.openstatic.midi.MidiPortProvider;

public class APIWebServer
implements MidiControlListener,
MidiPortListener,
MidiPortProvider {
    private Server httpServer;
    protected ArrayList<WebSocketSession> wsSessions;
    protected ArrayList<WebSocketSession> wsCanvasSessions;
    protected HashMap<WebSocketSession, String> canvasNames;
    protected static APIWebServer instance;
    private String staticRoot;
    private LinkedHashMap<String, MidiAPIPort> virtualPorts = new LinkedHashMap();

    public APIWebServer() {
        instance = this;
        this.wsSessions = new ArrayList();
        this.wsCanvasSessions = new ArrayList();
        this.canvasNames = new HashMap();
        this.httpServer = new Server(6123);
        ServletContextHandler context = new ServletContextHandler(0);
        context.setContextPath("/");
        context.addServlet(ApiServlet.class, "/api/*");
        context.addServlet(CanvasWebSocketServlet.class, "/canvas/*");
        context.addServlet(EventsWebSocketServlet.class, "/events/*");
        try {
            DefaultServlet assetServlet = new DefaultServlet();
            ServletHolder holderAssets = new ServletHolder("assets", assetServlet);
            String assetsPath = MidiTools.getAssetFolder().toPath().toUri().toASCIIString();
            System.err.println("Assets Path: " + assetsPath);
            holderAssets.setInitParameter("resourceBase", assetsPath);
            holderAssets.setInitParameter("dirAllowed", "true");
            holderAssets.setInitParameter("pathInfoOnly", "true");
            context.addServlet(holderAssets, "/assets/*");
            URL url = MidiTools.class.getResource("/midi-tools-res/index.html");
            this.staticRoot = url.toString().replaceAll("index.html", "");
            DefaultServlet defaultServlet = new DefaultServlet();
            ServletHolder holderPwd = new ServletHolder("default", defaultServlet);
            System.err.println("Static Root Path: " + this.staticRoot);
            holderPwd.setInitParameter("resourceBase", this.staticRoot);
            context.addServlet(holderPwd, "/*");
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            httpConfiguration.setSecureScheme("https");
            httpConfiguration.setSecurePort(6124);
            SslContextFactory sslContextFactory = new SslContextFactory(this.staticRoot + "midi-tools.jks");
            sslContextFactory.setKeyStorePassword("miditools");
            HttpConfiguration httpsConfiguration = new HttpConfiguration(httpConfiguration);
            httpsConfiguration.addCustomizer(new SecureRequestCustomizer());
            ServerConnector httpsConnector = new ServerConnector(this.httpServer, new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfiguration));
            httpsConnector.setPort(6124);
            this.httpServer.addConnector(httpsConnector);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.httpServer.setHandler(context);
        MidiPortManager.addMidiPortListener(this);
    }

    public void handleWebSocketEvent(JSONObject j, WebSocketSession session) {
        if (j.has("do")) {
            MidiControl mc;
            String doCmd = j.optString("do", "");
            if (doCmd.equals("registerMidiDevice")) {
                String hostname = session.getRemoteAddress().getHostName();
                String deviceName = j.optString("name", "unknown");
                String deviceId = j.optString("device", "unknown");
                String deviceFullName = deviceName + " (" + hostname + ")";
                String deviceFullId = deviceId + "." + hostname;
                int type = 0;
                String sType = j.optString("type", "both");
                if (sType.equals("input")) {
                    type = 1;
                } else if (sType.equals("output")) {
                    type = 2;
                }
                if (!this.virtualPorts.containsKey(deviceFullId)) {
                    MidiAPIPort apiPort = new MidiAPIPort(deviceFullName, deviceId, session, type);
                    this.virtualPorts.put(deviceFullId, apiPort);
                } else {
                    this.virtualPorts.get(deviceFullId).setWebSocketSession(session);
                }
            } else if (doCmd.equals("fetchStatus")) {
                this.transmitStatus(session, j.optString("__sourceId", null));
            } else if (doCmd.equals("removeMidiDevice")) {
                String hostname = session.getRemoteAddress().getHostName();
                String deviceId = j.optString("device", "unknown");
                String deviceFullId = deviceId + "." + hostname;
                if (this.virtualPorts.containsKey(deviceFullId)) {
                    this.virtualPorts.remove(deviceFullId);
                }
            } else if (doCmd.equals("midiShortMessage") || doCmd.equals("beatClock")) {
                String hostname = session.getRemoteAddress().getHostName();
                String deviceId = j.optString("device", "unknown");
                String deviceFullId = deviceId + "." + hostname;
                MidiAPIPort port = this.virtualPorts.get(deviceFullId);
                if (port != null) {
                    port.handleWebSocketEvent(j);
                }
            } else if (doCmd.equals("openDevice")) {
                String deviceId = j.optString("device", "unknown");
                String deviceType = j.optString("type", "both");
                if ("input".equals(deviceType)) {
                    MidiPort p = MidiPortManager.findReceivingPortByName(deviceId);
                    p.open();
                } else if ("output".equals(deviceType)) {
                    MidiPort p = MidiPortManager.findTransmittingPortByName(deviceId);
                    p.open();
                } else {
                    MidiPort p = MidiPortManager.findBidirectionalPortByName(deviceId);
                    p.open();
                }
            } else if (doCmd.equals("closeDevice")) {
                String deviceId = j.optString("device", "unknown");
                String deviceType = j.optString("type", "both");
                if ("input".equals(deviceType)) {
                    MidiPort p = MidiPortManager.findReceivingPortByName(deviceId);
                    p.close();
                } else if ("output".equals(deviceType)) {
                    MidiPort p = MidiPortManager.findTransmittingPortByName(deviceId);
                    p.close();
                } else {
                    MidiPort p = MidiPortManager.findBidirectionalPortByName(deviceId);
                    p.close();
                }
            } else if (doCmd.equals("openMapping")) {
                String mappingId = j.optString("mappingId", null);
                MidiPortMapping mapping = MidiPortManager.findMidiPortMappingById(mappingId);
                if (mapping != null) {
                    mapping.open();
                }
            } else if (doCmd.equals("closeMapping")) {
                String mappingId = j.optString("mappingId", null);
                MidiPortMapping mapping = MidiPortManager.findMidiPortMappingById(mappingId);
                if (mapping != null) {
                    mapping.close();
                }
            } else if (doCmd.equals("changeControlValue") && (mc = MidiTools.getMidiControlByChannelCC(j.optInt("channel", 0), j.optInt("cc", 0))) != null) {
                mc.manualAdjust(j.optInt("value", 0));
                MidiTools.repaintControls();
            }
        }
    }

    public void setState(boolean b) {
        if (b) {
            try {
                this.httpServer.start();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            try {
                this.httpServer.stop();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    @Override
    public void portAdded(int idx, MidiPort port) {
        JSONObject event = new JSONObject();
        event.put("event", "deviceAdded");
        event.put("id", idx);
        event.put("device", MidiTools.MidiPortToJSONObject(port));
        this.broadcastJSONObject(event);
    }

    @Override
    public void portRemoved(int idx, MidiPort port) {
        JSONObject event = new JSONObject();
        event.put("event", "deviceRemoved");
        event.put("id", idx);
        event.put("device", MidiTools.MidiPortToJSONObject(port));
        this.broadcastJSONObject(event);
    }

    @Override
    public void portOpened(MidiPort port) {
        JSONObject event = new JSONObject();
        event.put("event", "deviceOpened");
        event.put("device", MidiTools.MidiPortToJSONObject(port));
        this.broadcastJSONObject(event);
    }

    @Override
    public void portClosed(MidiPort port) {
        JSONObject event = new JSONObject();
        event.put("event", "deviceClosed");
        event.put("device", MidiTools.MidiPortToJSONObject(port));
        this.broadcastJSONObject(event);
    }

    @Override
    public void mappingOpened(MidiPortMapping mapping) {
        JSONObject event = new JSONObject();
        event.put("event", "mappingOpened");
        event.put("mapping", mapping.toJSONObject());
        this.broadcastJSONObject(event);
    }

    @Override
    public void mappingClosed(MidiPortMapping mapping) {
        JSONObject event = new JSONObject();
        event.put("event", "mappingClosed");
        event.put("mapping", mapping.toJSONObject());
        this.broadcastJSONObject(event);
    }

    @Override
    public void mappingAdded(int idx, MidiPortMapping mapping) {
        JSONObject event = new JSONObject();
        event.put("event", "mappingAdded");
        event.put("mapping", mapping.toJSONObject());
        this.broadcastJSONObject(event);
    }

    @Override
    public void mappingRemoved(int idx, MidiPortMapping mapping) {
        JSONObject event = new JSONObject();
        event.put("event", "mappingAdded");
        event.put("mapping", mapping.toJSONObject());
        this.broadcastJSONObject(event);
    }

    @Override
    public void controlValueChanged(MidiControl control, int old_value, int new_value) {
        JSONObject event = new JSONObject();
        event.put("event", "controlValueChanged");
        event.put("control", control.toJSONObject());
        event.put("oldValue", old_value);
        event.put("newValue", new_value);
        this.broadcastJSONObject(event);
    }

    @Override
    public void controlValueSettled(MidiControl control, int old_value, int new_value) {
        JSONObject event = new JSONObject();
        event.put("event", "controlValueSettled");
        event.put("control", control.toJSONObject());
        event.put("oldValue", old_value);
        event.put("newValue", new_value);
        this.broadcastJSONObject(event);
    }

    public void broadcastJSONObject(JSONObject jo) {
        String message = jo.toString();
        for (Session session : this.wsSessions) {
            try {
                session.getRemote().sendStringByFuture(message);
            }
            catch (Exception exception) {}
        }
    }

    public boolean broadcastCanvasJSONObject(JSONObject jo) {
        boolean sent = false;
        String canvas = jo.optString("canvas", null);
        String message = jo.toString();
        for (WebSocketSession s : this.wsCanvasSessions) {
            try {
                if (canvas == null || "(ALL)".equals(canvas)) {
                    s.getRemote().sendStringByFuture(message);
                    sent = true;
                    continue;
                }
                String canvasName = this.canvasNames.get(s);
                if (!canvas.equals(canvasName)) continue;
                s.getRemote().sendStringByFuture(message);
                sent = true;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
        return sent;
    }

    public void transmitStatus(WebSocketSession wssession, String targetId) {
        JSONObject event;
        Enumeration<MidiControl> cenum = MidiTools.instance.midiControlsPanel.getControlsEnumeration();
        while (cenum.hasMoreElements()) {
            MidiControl mc = cenum.nextElement();
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("event", "controlAdded");
            jSONObject.put("control", mc.toJSONObject());
            if (targetId != null) {
                jSONObject.put("__targetId", targetId);
            }
            wssession.getRemote().sendStringByFuture(jSONObject.toString());
        }
        int idx = 0;
        for (MidiPort midiPort : MidiPortManager.getPorts()) {
            event = new JSONObject();
            event.put("event", "deviceAdded");
            event.put("id", idx);
            event.put("device", MidiTools.MidiPortToJSONObject(midiPort));
            if (targetId != null) {
                event.put("__targetId", targetId);
            }
            wssession.getRemote().sendStringByFuture(event.toString());
            ++idx;
        }
        idx = 0;
        for (MidiPortMapping midiPortMapping : MidiPortManager.getMidiPortMappings()) {
            event = new JSONObject();
            event.put("event", "mappingAdded");
            event.put("id", idx);
            event.put("mapping", midiPortMapping.toJSONObject());
            if (targetId != null) {
                event.put("__targetId", targetId);
            }
            wssession.getRemote().sendStringByFuture(event.toString());
            ++idx;
        }
    }

    @Override
    public Collection<? extends MidiPort> getMidiPorts() {
        return this.virtualPorts.values();
    }

    public static class ApiServlet
    extends HttpServlet {
        public JSONObject readJSONObjectPOST(HttpServletRequest request) {
            StringBuffer jb = new StringBuffer();
            String line = null;
            try {
                BufferedReader reader = request.getReader();
                while ((line = reader.readLine()) != null) {
                    jb.append(line);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            try {
                JSONObject jsonObject = new JSONObject(jb.toString());
                return jsonObject;
            }
            catch (JSONException e) {
                e.printStackTrace(System.err);
                return new JSONObject();
            }
        }

        public boolean isNumber(String v) {
            try {
                Integer.parseInt(v);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        protected void doGet(HttpServletRequest request, HttpServletResponse httpServletResponse) throws ServletException, IOException {
            httpServletResponse.setContentType("text/javascript");
            httpServletResponse.setStatus(200);
            httpServletResponse.setCharacterEncoding("iso-8859-1");
            String target = request.getPathInfo();
            System.err.println("Path: " + target);
            JSONObject response = new JSONObject();
            try {
                if ("/rules/add/".equals(target)) {
                    try {
                        JSONObject rule = this.readJSONObjectPOST(request);
                        MidiControlRule mcr = new MidiControlRule(rule);
                        MidiTools.instance.midiControlRulePanel.addElement(mcr);
                        response.put("rule", mcr.toJSONObject());
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                } else if ("/rules/enable/".equals(target)) {
                    String ruleId = request.getParameter("ruleId");
                    MidiControlRule rule = MidiTools.getMidiControlRuleById(ruleId);
                    if (rule != null) {
                        rule.setEnabled(true);
                        response.put(ruleId, rule.toJSONObject());
                    } else {
                        response.put("error", "Rule Not Found!");
                    }
                } else if ("/rules/disable/".equals(target)) {
                    String ruleId = request.getParameter("ruleId");
                    MidiControlRule rule = MidiTools.getMidiControlRuleById(ruleId);
                    if (rule != null) {
                        rule.setEnabled(false);
                        response.put(ruleId, rule.toJSONObject());
                    } else {
                        response.put("error", "Rule Not Found!");
                    }
                } else if ("/rules/".equals(target)) {
                    response.put("rules", MidiTools.instance.rulesAsJSONArray());
                } else if ("/controls/".equals(target)) {
                    response.put("controls", MidiTools.instance.controlsAsJSONArray());
                } else if ("/control/".equals(target)) {
                    MidiControl control;
                    String cc = request.getParameter("cc");
                    String channel = request.getParameter("channel");
                    String value = request.getParameter("value");
                    if (cc != null && channel != null && (control = MidiTools.getMidiControlByChannelCC(Integer.valueOf(channel), Integer.valueOf(cc))) != null) {
                        if (value != null) {
                            int intValue = Integer.valueOf(value);
                            control.manualAdjust(intValue);
                        }
                        response.put("control", control.toJSONObject());
                    }
                } else if ("/mappings/add/".equals(target)) {
                    String source = request.getParameter("source");
                    String destination = request.getParameter("destination");
                    MidiPort sourcePort = MidiPortManager.findTransmittingPortByName(source);
                    MidiPort destinationPort = MidiPortManager.findReceivingPortByName(destination);
                    if (sourcePort != null && destinationPort != null) {
                        MidiPortMapping mpm = MidiPortManager.createMidiPortMapping(sourcePort, destinationPort);
                        response.put("mapping", mpm.toJSONObject());
                    } else {
                        response.put("error", "Bad Request");
                    }
                } else if ("/mappings/".equals(target)) {
                    response.put("mappings", MidiTools.instance.mappingsAsJSONArray());
                } else if ("/assets/".equals(target)) {
                    response.put("asssets", new JSONArray(MidiTools.getAllAssetNames()));
                }
            }
            catch (Exception x) {
                x.printStackTrace(System.err);
            }
            httpServletResponse.getWriter().println(response.toString());
        }
    }

    public static class CanvasWebSocketServlet
    extends WebSocketServlet {
        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(CanvasWebSocket.class);
        }
    }

    public static class EventsWebSocketServlet
    extends WebSocketServlet {
        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(EventsWebSocket.class);
        }
    }

    @WebSocket
    public static class CanvasWebSocket {
        @OnWebSocketMessage
        public void onText(Session session, String message) throws IOException {
            try {
                JSONObject jo = new JSONObject(message);
                if (session instanceof WebSocketSession) {
                    WebSocketSession wssession = (WebSocketSession)session;
                    if (jo.has("identify")) {
                        APIWebServer.instance.canvasNames.put(wssession, jo.optString("identify"));
                    }
                } else {
                    System.err.println("not instance of WebSocketSession");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }

        @OnWebSocketConnect
        public void onConnect(Session session) throws IOException {
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                System.out.println(wssession.getRemoteAddress().getHostString() + " connected to canvas!");
                APIWebServer.instance.wsCanvasSessions.add(wssession);
                Vector<String> canvasNames = MidiTools.getCanvasNames();
                JSONObject welcomeObject = new JSONObject();
                welcomeObject.put("canvasList", new JSONArray(canvasNames));
                welcomeObject.put("sounds", new JSONArray(MidiTools.getSoundAssets()));
                welcomeObject.put("images", new JSONArray(MidiTools.getImageAssets()));
                String projectName = MidiTools.getProjectName();
                if (projectName != null) {
                    welcomeObject.put("projectName", projectName);
                }
                session.getRemote().sendStringByFuture(welcomeObject.toString());
            } else {
                System.err.println("Not an instance of WebSocketSession");
            }
        }

        @OnWebSocketClose
        public void onClose(Session session, int status, String reason) {
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                APIWebServer.instance.wsCanvasSessions.remove(wssession);
                if (APIWebServer.instance.canvasNames.containsKey(wssession)) {
                    APIWebServer.instance.canvasNames.remove(wssession);
                }
            }
        }
    }

    @WebSocket
    public static class EventsWebSocket {
        @OnWebSocketMessage
        public void onText(Session session, String message) throws IOException {
            try {
                JSONObject jo = new JSONObject(message);
                if (session instanceof WebSocketSession) {
                    WebSocketSession wssession = (WebSocketSession)session;
                    instance.handleWebSocketEvent(jo, wssession);
                } else {
                    System.err.println("not instance of WebSocketSession");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }

        @OnWebSocketConnect
        public void onConnect(Session session) throws IOException {
            System.err.println("@OnWebSocketConnect");
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                System.out.println(wssession.getRemoteAddress().getHostString() + " connected!");
                APIWebServer.instance.wsSessions.add(wssession);
            } else {
                System.err.println("Not an instance of WebSocketSession");
            }
        }

        @OnWebSocketClose
        public void onClose(Session session, int status, String reason) {
            if (session instanceof WebSocketSession) {
                WebSocketSession wssession = (WebSocketSession)session;
                APIWebServer.instance.wsSessions.remove(wssession);
                APIWebServer.instance.virtualPorts.entrySet().removeIf(entry -> {
                    if (((MidiAPIPort)entry.getValue()).getWebSocketSession() == wssession) {
                        System.err.println("Removed Session onClose " + (String)entry.getKey());
                        return true;
                    }
                    return false;
                });
            }
        }
    }
}

