/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.MidiPortMapping;

public class CreateMappingDialog
extends JDialog
implements ActionListener {
    private JTextField nicknameField;
    private JComboBox<MidiPort> selectSource;
    private JComboBox<MidiPort> selectDestination;
    private JButton saveButton;
    private JButton deleteButton;

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            this.dispose();
        }
        if (e.getSource() == this.saveButton) {
            MidiPortMapping mapping = MidiPortManager.createMidiPortMapping((MidiPort)this.selectSource.getSelectedItem(), (MidiPort)this.selectDestination.getSelectedItem());
            if (!"".equals(this.nicknameField.getText())) {
                mapping.setNickname(this.nicknameField.getText());
            }
            this.dispose();
        }
    }

    public CreateMappingDialog() {
        super(MidiTools.instance, "Mapping Creator", true);
        this.setLayout(new BorderLayout());
        this.nicknameField = new JTextField("");
        this.selectSource = new JComboBox();
        this.selectSource.setModel(new DefaultComboBoxModel((Vector)MidiPortManager.getTransmittingPorts()));
        this.selectDestination = new JComboBox();
        this.selectDestination.setModel(new DefaultComboBoxModel((Vector)MidiPortManager.getReceivingPorts()));
        JPanel formPanel = new JPanel(new GridBagLayout());
        formPanel.add((Component)new JLabel("Nickname", 2), this.gbc(1, 1, 0.4));
        formPanel.add((Component)this.nicknameField, this.gbc(2, 1, 0.6));
        formPanel.add((Component)new JLabel("Source Device", 2), this.gbc(1, 2, 0.4));
        formPanel.add(this.selectSource, this.gbc(2, 2, 0.6));
        formPanel.add((Component)new JLabel("Destination Device", 2), this.gbc(1, 3, 0.4));
        formPanel.add(this.selectDestination, this.gbc(2, 3, 0.6));
        this.saveButton = new JButton("Create Mapping");
        this.deleteButton = new JButton("Cancel");
        this.saveButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.saveButton);
        formPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)formPanel, "First");
        this.add((Component)buttonPanel, "Last");
        this.centerWindow();
    }

    private GridBagConstraints gbc(int x, int y, double weightx) {
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = weightx;
        g.gridx = x;
        g.gridy = y;
        g.ipady = 2;
        g.ipadx = 5;
        return g;
    }

    public JPanel labelComponent(String label, Component c) {
        JPanel x = new JPanel(new GridLayout(1, 2));
        x.add(new JLabel(label, 0));
        x.add(c);
        return x;
    }

    public void centerWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        float WIDTH = screenSize.width;
        float HEIGHT = screenSize.height;
        int wWidth = 400;
        int wHeight = 250;
        int x = (int)(WIDTH / 2.0f - (float)wWidth / 2.0f);
        int y = (int)(HEIGHT / 2.0f - (float)wHeight / 2.0f);
        this.setBounds(x, y, wWidth, wHeight);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
    }
}

