/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.openstatic.MidiControlRule;
import org.openstatic.midi.MidiToolsPlugin;

public class MidiControlRuleCellRenderer
extends JPanel
implements ListCellRenderer<MidiControlRule> {
    private Border selectedBorder;
    private Border regularBorder;
    private JCheckBox checkBox;
    private ImageIcon speakerIcon;
    private ImageIcon logIcon;
    private ImageIcon dialIcon;
    private ImageIcon disableIcon;
    private ImageIcon enableIcon;
    private ImageIcon gearsIcon;
    private ImageIcon toggleIcon;
    private ImageIcon urlIcon;
    private ImageIcon pluginIcon;
    private ImageIcon imageIcon;
    private ImageIcon mappingIcon;
    private ImageIcon noteIcon;

    public MidiControlRuleCellRenderer() {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.selectedBorder = BorderFactory.createLineBorder(Color.RED, 1);
        this.checkBox = new JCheckBox("");
        this.checkBox.setOpaque(false);
        this.add((Component)this.checkBox, "Center");
        try {
            this.speakerIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/speaker32.png")));
            this.logIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/log32.png")));
            this.disableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/disable32.png")));
            this.enableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/enable32.png")));
            this.dialIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/dial32.png")));
            this.gearsIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/gears32.png")));
            this.toggleIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/toggle32.png")));
            this.urlIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/url32.png")));
            this.pluginIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/plug_in.png")));
            this.imageIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/image32.png")));
            this.mappingIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/cable32.png")));
            this.noteIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/midifile32.png")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends MidiControlRule> list, MidiControlRule rule, int index, boolean isSelected, boolean cellHasFocus) {
        if (rule.getNickname() != null) {
            this.checkBox.setText("<html><body style=\"padding: 3px 3px 3px 3px;\"><b style=\"font-size: 14px;\">" + rule.getNickname() + "</b><br />" + rule.toString() + "</body></html>");
        } else {
            this.checkBox.setText("<html><body style=\"padding: 3px 3px 3px 3px;\">" + rule.toString() + "</body></html>");
        }
        if (rule.getActionType() == 2) {
            this.checkBox.setIcon(this.speakerIcon);
        } else if (rule.getActionType() == 5 || rule.getActionType() == 6) {
            this.checkBox.setIcon(this.logIcon);
        } else if (rule.getActionType() == 3) {
            this.checkBox.setIcon(this.dialIcon);
        } else if (rule.getActionType() == 14) {
            this.checkBox.setIcon(this.noteIcon);
        } else if (rule.getActionType() == 15) {
            this.checkBox.setIcon(this.noteIcon);
        } else if (rule.getActionType() == 7) {
            this.checkBox.setIcon(this.enableIcon);
        } else if (rule.getActionType() == 8) {
            this.checkBox.setIcon(this.disableIcon);
        } else if (rule.getActionType() == 9) {
            this.checkBox.setIcon(this.toggleIcon);
        } else if (rule.getActionType() == 4) {
            MidiToolsPlugin plugin = rule.getSelectedPlugin();
            if (plugin != null) {
                Icon pluginSelfIcon = plugin.getIcon();
                if (pluginSelfIcon != null) {
                    this.checkBox.setIcon(pluginSelfIcon);
                } else {
                    this.checkBox.setIcon(this.pluginIcon);
                }
            } else {
                this.checkBox.setIcon(this.pluginIcon);
            }
        } else if (rule.getActionType() == 1) {
            this.checkBox.setIcon(this.gearsIcon);
        } else if (rule.getActionType() == 0) {
            this.checkBox.setIcon(this.urlIcon);
        } else if (rule.getActionType() == 10) {
            this.checkBox.setIcon(this.imageIcon);
        } else if (rule.getActionType() == 11 || rule.getActionType() == 12 || rule.getActionType() == 13) {
            this.checkBox.setIcon(this.mappingIcon);
        } else {
            this.checkBox.setIcon(this.gearsIcon);
        }
        if (rule.isEnabled()) {
            if (System.currentTimeMillis() - rule.getLastFailed() < 1000L) {
                this.setBackground(new Color(255, 102, 102));
            } else if (System.currentTimeMillis() - rule.getLastTriggered() < 1000L) {
                this.setBackground(new Color(102, 255, 102));
            } else {
                this.setBackground(Color.WHITE);
            }
        } else {
            this.setBackground(Color.GRAY);
        }
        this.checkBox.setSelected(rule.isEnabled());
        this.setFont(list.getFont());
        this.setEnabled(list.isEnabled());
        if (isSelected) {
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(this.regularBorder);
        }
        return this;
    }
}

