/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstatic.MidiControlRule;
import org.openstatic.MidiTools;
import org.openstatic.RuleActionCellRenderer;
import org.openstatic.midi.MidiControl;
import org.openstatic.midi.MidiPort;
import org.openstatic.midi.MidiPortManager;
import org.openstatic.midi.MidiPortMapping;
import org.openstatic.midi.MidiToolsPlugin;

public class MidiControlRuleEditor
extends JDialog
implements ActionListener {
    private MidiControlRule rule;
    private JComboBox<String> eventSelector;
    private JComboBox<MidiControl> controlSelector;
    private JComboBox<String> pluginSelector;
    private JComboBox<String> pluginTargetSelector;
    private JComboBox<String> showImageModeSelector;
    private JCheckBox soloImageCheckBox;
    private JPanel imageOptionsPanel;
    private JComboBox<String> fillOptions;
    private JComboBox<Integer> actionSelector;
    private JTextField nicknameField;
    private JComboBox<String> ruleGroupField;
    private JComboBox<String> canvasSelectorField;
    private JTextArea actionValueField;
    private JComboBox<String> deviceSelectAVF;
    private JComboBox<String> channelSelectAVF;
    private JComboBox<String> selectRuleGroupDropdown;
    private JComboBox<MidiPortMapping> selectMappingDropdown;
    private JLabel ccLabel;
    private JTextField ccAVF;
    private JTextField valueAVF;
    private JTextField zIndexField;
    private JPanel transmitMidiPanel;
    private JCheckBox valueInvertedCheckBox;
    private JCheckBox valueSettledCheckBox;
    private JPanel modifierPanel;
    private JPanel selectFilePanel;
    private JButton selectFileButton;
    private JComboBox<String> selectFileField;
    private JLabel actionValueLabel;
    private JPanel actionValuePanel;
    private JButton saveButton;
    private JButton deleteButton;

    @Override
    public void actionPerformed(ActionEvent e) {
        String pluginName;
        if (e.getSource() == this.eventSelector) {
            this.rule.setEventMode(this.eventSelector.getSelectedIndex());
        }
        if (e.getSource() == this.selectFileButton) {
            File fileToLoad;
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle("Select a file");
            int userSelection = fileChooser.showOpenDialog(this);
            if (userSelection == 0 && (fileToLoad = fileChooser.getSelectedFile()) != null) {
                File assetFile = MidiTools.addProjectAsset(fileToLoad);
                String filename = assetFile.getName();
                this.selectFileField.setSelectedItem(filename);
                if ((Integer)this.actionSelector.getSelectedItem() == 10) {
                    this.actionValueField.setText(filename + "," + this.getImageEffects());
                } else {
                    this.actionValueField.setText(filename);
                }
            }
        }
        if (e.getSource() == this.showImageModeSelector || e.getSource() == this.soloImageCheckBox || e.getSource() == this.fillOptions || e.getSource() == this.zIndexField) {
            this.actionValueField.setText(this.selectFileField.getSelectedItem().toString() + "," + this.getImageEffects());
        }
        if (e.getSource() == this.pluginSelector) {
            pluginName = this.pluginSelector.getSelectedItem().toString();
            MidiToolsPlugin plugin = MidiTools.instance.plugins.get(pluginName);
            this.pluginTargetSelector.setModel(this.getPluginTargetModel(plugin));
            this.actionValueField.setText(plugin.getTitle() + "," + this.pluginTargetSelector.getSelectedItem().toString());
        }
        if (e.getSource() == this.selectFileField) {
            String fileName = this.selectFileField.getSelectedItem().toString();
            if ((Integer)this.actionSelector.getSelectedItem() == 10) {
                this.actionValueField.setText(fileName + "," + this.getImageEffects());
            } else {
                this.actionValueField.setText(fileName);
            }
        }
        if (e.getSource() == this.pluginTargetSelector) {
            pluginName = this.pluginSelector.getSelectedItem().toString();
            MidiToolsPlugin plugin = MidiTools.instance.plugins.get(pluginName);
            this.actionValueField.setText(plugin.getTitle() + "," + this.pluginTargetSelector.getSelectedItem().toString());
        }
        if (e.getSource() == this.actionSelector) {
            int avi = (Integer)this.actionSelector.getSelectedItem();
            this.rule.setActionType(avi);
            this.changeActionSelector(avi);
        }
        if (e.getSource() == this.deviceSelectAVF || e.getSource() == this.channelSelectAVF) {
            this.actionValueField.setText(String.valueOf(this.deviceSelectAVF.getSelectedItem()) + "," + String.valueOf(this.channelSelectAVF.getSelectedItem()) + "," + this.ccAVF.getText() + "," + this.valueAVF.getText());
        }
        if (e.getSource() == this.selectRuleGroupDropdown) {
            this.actionValueField.setText(this.selectRuleGroupDropdown.getSelectedItem().toString());
        }
        if (e.getSource() == this.selectMappingDropdown) {
            MidiPortMapping selectedMapping = (MidiPortMapping)this.selectMappingDropdown.getSelectedItem();
            this.actionValueField.setText(selectedMapping.getMappingId());
        }
        if (e.getSource() == this.deleteButton) {
            if (MidiTools.instance.midiControlRulePanel.contains(this.rule)) {
                MidiTools.instance.midiControlRulePanel.removeElement(this.rule);
            }
            MidiTools.removeListenerFromControls(this.rule);
            this.dispose();
        }
        if (e.getSource() == this.saveButton) {
            if (!"".equals(this.nicknameField.getText())) {
                this.rule.setNickname(this.nicknameField.getText());
            } else {
                this.rule.setNickname(null);
            }
            if (!"".equals(this.ruleGroupField.getSelectedItem())) {
                this.rule.setRuleGroup(this.ruleGroupField.getSelectedItem().toString());
            } else {
                this.rule.setRuleGroup("all");
            }
            if (this.canvasSelectorField.getSelectedItem() != null) {
                if (!"".equals(this.canvasSelectorField.getSelectedItem())) {
                    this.rule.setCanvasName(this.canvasSelectorField.getSelectedItem().toString());
                } else {
                    this.rule.setCanvasName(null);
                }
            } else {
                this.rule.setCanvasName(null);
            }
            if (!"".equals(this.actionValueField.getText())) {
                this.rule.setActionValue(this.actionValueField.getText());
            } else {
                this.rule.setActionValue(null);
            }
            int ci = this.controlSelector.getSelectedIndex();
            if (ci == -1) {
                this.rule.setMidiControl(null);
            } else {
                this.rule.setMidiControl(MidiTools.getMidiControlByIndex(ci));
            }
            if (!MidiTools.instance.midiControlRulePanel.contains(this.rule)) {
                MidiTools.instance.midiControlRulePanel.addElement(this.rule);
            }
            this.rule.setValueInverted(this.valueInvertedCheckBox.isSelected());
            this.rule.setValueSettled(this.valueSettledCheckBox.isSelected());
            this.rule.updateRule();
            this.dispose();
        }
    }

    private String getImageEffects() {
        Object extras = "";
        if (this.soloImageCheckBox.isSelected()) {
            extras = (String)extras + " solo";
        }
        String rs = this.showImageModeSelector.getSelectedItem().toString() + (String)extras + " " + this.fillOptions.getSelectedItem().toString() + "," + this.zIndexField.getText();
        System.err.println("Image Effects: " + rs);
        return rs;
    }

    public void changeActionSelector(int i) {
        this.actionValuePanel.removeAll();
        if (i == 0 || i == 5 || i == 6) {
            this.actionValuePanel.add((Component)this.actionValueField, "Center");
            if (i == 0) {
                this.actionValueLabel.setText("URL");
            } else if (i == 5 || i == 6) {
                this.actionValueLabel.setText("Message to display");
            }
            this.canvasSelectorField.setEnabled(false);
            this.canvasSelectorField.setSelectedItem("");
        } else if (i == 1 || i == 2 || i == 10) {
            ArrayList<String> extens = new ArrayList<String>();
            if (i == 1) {
                this.actionValueLabel.setText("Program");
                extens.add(".cmd");
                extens.add(".bat");
                extens.add(".php");
                extens.add(".sh");
                extens.add(".exe");
            } else if (i == 2) {
                this.actionValueLabel.setText("Asset Filename");
                extens.add(".wav");
                this.canvasSelectorField.setEnabled(true);
                this.canvasSelectorField.setSelectedItem(this.rule.getCanvasName());
            } else if (i == 10) {
                this.actionValueLabel.setText("Asset Filename");
                extens.add(".png");
                extens.add(".gif");
                extens.add(".jpg");
                extens.add(".jpeg");
                extens.add(".webp");
                extens.add(".svg");
                this.canvasSelectorField.setEnabled(true);
                this.canvasSelectorField.setSelectedItem(this.rule.getCanvasName());
            }
            this.actionValuePanel.add((Component)this.selectFilePanel, "Center");
            this.selectFileField.setModel(MidiTools.getAssetComboBoxModel(extens));
            if (i == 10) {
                Object selectedItem;
                this.actionValuePanel.add((Component)this.imageOptionsPanel, "Last");
                StringTokenizer st = new StringTokenizer(this.actionValueField.getText(), ",");
                if (st.hasMoreTokens()) {
                    String filename = st.nextToken();
                    this.selectFileField.setSelectedItem(filename);
                }
                if (st.hasMoreTokens()) {
                    String mode = st.nextToken();
                    this.showImageModeSelector.setSelectedItem(mode.replace(" solo", "").replace(" fill-x", "").replace(" fill-y", ""));
                    this.soloImageCheckBox.setSelected(mode.contains("solo"));
                    if (mode.contains("fill-x")) {
                        this.fillOptions.setSelectedItem("fill-x");
                    } else {
                        this.fillOptions.setSelectedItem("fill-y");
                    }
                }
                if (st.hasMoreTokens()) {
                    String zIn = st.nextToken();
                    this.zIndexField.setText(zIn);
                }
                if ((selectedItem = this.selectFileField.getSelectedItem()) != null) {
                    this.actionValueField.setText(selectedItem.toString() + "," + this.getImageEffects());
                }
            } else {
                this.selectFileField.setSelectedItem(this.actionValueField.getText());
                Object selectedItem = this.selectFileField.getSelectedItem();
                if (selectedItem != null) {
                    this.actionValueField.setText(selectedItem.toString());
                }
            }
        } else if (i == 3) {
            this.actionValueLabel.setText("MIDI Message");
            this.refreshDevices();
            StringTokenizer st = new StringTokenizer(this.actionValueField.getText(), ",");
            if (st.countTokens() == 4) {
                String devName = st.nextToken();
                String chanNum = st.nextToken();
                String ccNum = st.nextToken();
                String val2 = st.nextToken();
                this.deviceSelectAVF.setSelectedItem(devName);
                this.channelSelectAVF.setSelectedItem(chanNum);
                this.ccAVF.setText(ccNum);
                this.valueAVF.setText(val2);
            } else {
                this.deviceSelectAVF.setSelectedIndex(0);
                this.channelSelectAVF.setSelectedIndex(0);
                this.ccAVF.setText("{{cc}}");
                this.valueAVF.setText("{{value}}");
            }
            this.valueAVF.setEnabled(true);
            this.ccLabel.setText("CC");
            this.actionValuePanel.add((Component)this.transmitMidiPanel, "Center");
            this.canvasSelectorField.setEnabled(false);
            this.canvasSelectorField.setSelectedItem("");
        } else if (i == 14) {
            this.actionValueLabel.setText("MIDI Message");
            this.refreshDevices();
            StringTokenizer st = new StringTokenizer(this.actionValueField.getText(), ",");
            if (st.countTokens() == 4) {
                String devName = st.nextToken();
                String chanNum = st.nextToken();
                String ccNum = st.nextToken();
                String val3 = st.nextToken();
                this.deviceSelectAVF.setSelectedItem(devName);
                this.channelSelectAVF.setSelectedItem(chanNum);
                this.ccAVF.setText(ccNum);
                this.valueAVF.setText(val3);
            } else {
                this.deviceSelectAVF.setSelectedIndex(0);
                this.channelSelectAVF.setSelectedIndex(0);
                this.ccAVF.setText("{{note}}");
                this.valueAVF.setText("{{value}}");
            }
            this.valueAVF.setEnabled(true);
            this.ccLabel.setText("NOTE#");
            this.actionValuePanel.add((Component)this.transmitMidiPanel, "Center");
            this.canvasSelectorField.setEnabled(false);
            this.canvasSelectorField.setSelectedItem("");
        } else if (i == 15) {
            this.actionValueLabel.setText("MIDI Message");
            this.refreshDevices();
            StringTokenizer st = new StringTokenizer(this.actionValueField.getText(), ",");
            if (st.countTokens() == 4) {
                String devName = st.nextToken();
                String chanNum = st.nextToken();
                String ccNum = st.nextToken();
                String val4 = st.nextToken();
                this.deviceSelectAVF.setSelectedItem(devName);
                this.channelSelectAVF.setSelectedItem(chanNum);
                this.ccAVF.setText(ccNum);
                this.valueAVF.setText("0");
            } else {
                this.deviceSelectAVF.setSelectedIndex(0);
                this.channelSelectAVF.setSelectedIndex(0);
                this.ccAVF.setText("{{note}}");
                this.valueAVF.setText("0");
            }
            this.valueAVF.setEnabled(false);
            this.ccLabel.setText("NOTE#");
            this.actionValuePanel.add((Component)this.transmitMidiPanel, "Center");
            this.canvasSelectorField.setEnabled(false);
            this.canvasSelectorField.setSelectedItem("");
        } else if (i == 8 || i == 7 || i == 9) {
            this.actionValueLabel.setText("Rule Group");
            this.selectRuleGroupDropdown.setModel(this.getRuleGroupModel());
            this.selectRuleGroupDropdown.setSelectedItem(this.actionValueField.getText());
            this.actionValuePanel.add(this.selectRuleGroupDropdown, "Center");
            this.canvasSelectorField.setEnabled(false);
            this.canvasSelectorField.setSelectedItem("");
        } else if (i == 12 || i == 11 || i == 13) {
            this.actionValueLabel.setText("Port Mapping");
            this.selectMappingDropdown.setSelectedItem(this.actionValueField.getText());
            this.actionValuePanel.add(this.selectMappingDropdown, "Center");
            this.canvasSelectorField.setEnabled(false);
            this.canvasSelectorField.setSelectedItem("");
            MidiPortMapping selectedMapping = (MidiPortMapping)this.selectMappingDropdown.getSelectedItem();
            this.actionValueField.setText(selectedMapping.getMappingId());
        } else if (i == 4) {
            try {
                StringTokenizer st = new StringTokenizer(this.actionValueField.getText(), ",");
                this.actionValueLabel.setText("Plugin");
                this.pluginSelector.setModel(this.getPluginModel());
                if (st.countTokens() == 2) {
                    String pluginName = st.nextToken();
                    String targetName = st.nextToken();
                    MidiToolsPlugin plugin = MidiTools.instance.plugins.get(pluginName);
                    this.pluginTargetSelector.setModel(this.getPluginTargetModel(plugin));
                    this.pluginSelector.setSelectedItem(pluginName);
                    this.pluginTargetSelector.setSelectedItem(targetName);
                    this.actionValueField.setText(pluginName + "," + targetName);
                } else {
                    String firstPlugin = this.pluginSelector.getSelectedItem().toString();
                    MidiToolsPlugin plugin = MidiTools.instance.plugins.get(firstPlugin);
                    this.pluginTargetSelector.setModel(this.getPluginTargetModel(plugin));
                    try {
                        this.actionValueField.setText(firstPlugin + "," + this.pluginTargetSelector.getSelectedItem().toString());
                    }
                    catch (Exception e2) {
                        e2.printStackTrace(System.err);
                    }
                }
                this.actionValuePanel.add(this.pluginSelector, "Center");
                this.actionValuePanel.add(this.pluginTargetSelector, "Last");
            }
            catch (Exception e) {
                MidiTools.instance.midi_logger_a.printException(e);
                this.actionValuePanel.removeAll();
                this.actionValuePanel.add((Component)this.actionValueField, "Center");
            }
            this.canvasSelectorField.setEnabled(false);
            this.canvasSelectorField.setSelectedItem("");
        }
        this.actionValuePanel.revalidate();
        this.actionValuePanel.repaint();
    }

    public MidiControlRuleEditor(MidiControlRule rule) {
        this(rule, false);
    }

    public MidiControlRuleEditor(MidiControlRule rule, boolean newRule) {
        super(MidiTools.instance, "Rule Editor", true);
        this.setLayout(new BorderLayout());
        this.rule = rule;
        Vector<Integer> actionList = new Vector<Integer>();
        actionList.add(4);
        actionList.add(10);
        actionList.add(0);
        actionList.add(1);
        actionList.add(2);
        actionList.add(3);
        actionList.add(14);
        actionList.add(15);
        actionList.add(5);
        actionList.add(6);
        actionList.add(7);
        actionList.add(8);
        actionList.add(9);
        actionList.add(11);
        actionList.add(12);
        actionList.add(13);
        Vector<String> eventModeList = new Vector<String>();
        for (int i = 0; i < 14; ++i) {
            eventModeList.add(MidiControlRule.eventModeToString(i));
        }
        this.controlSelector = new JComboBox();
        this.controlSelector.setEditable(false);
        this.controlSelector.addActionListener(this);
        this.controlSelector.setBackground(Color.WHITE);
        Vector<MidiControl> ctrls = new Vector<MidiControl>();
        Enumeration<MidiControl> cenum = MidiTools.instance.midiControlsPanel.getControlsEnumeration();
        while (cenum.hasMoreElements()) {
            ctrls.add(cenum.nextElement());
        }
        this.controlSelector.setModel(new DefaultComboBoxModel(ctrls));
        this.selectMappingDropdown = new JComboBox();
        this.selectMappingDropdown.setEditable(false);
        this.selectMappingDropdown.addActionListener(this);
        this.setBackground(Color.WHITE);
        Vector<MidiPortMapping> mappings = new Vector<MidiPortMapping>();
        Iterator<MidiPortMapping> mpmIterator = MidiPortManager.getMidiPortMappings().iterator();
        while (mpmIterator.hasNext()) {
            mappings.add(mpmIterator.next());
        }
        this.selectMappingDropdown.setModel(new DefaultComboBoxModel(mappings));
        this.eventSelector = new JComboBox(eventModeList);
        this.eventSelector.setEditable(false);
        this.eventSelector.addActionListener(this);
        this.eventSelector.setBackground(Color.WHITE);
        this.actionSelector = new JComboBox(actionList);
        this.actionSelector.setEditable(false);
        this.actionSelector.setRenderer(new RuleActionCellRenderer());
        this.actionSelector.addActionListener(this);
        this.actionSelector.setBackground(Color.WHITE);
        this.pluginSelector = new JComboBox();
        this.pluginSelector.setEditable(false);
        this.pluginSelector.addActionListener(this);
        this.pluginSelector.setBackground(Color.WHITE);
        this.pluginTargetSelector = new JComboBox();
        this.pluginTargetSelector.setEditable(false);
        this.pluginTargetSelector.addActionListener(this);
        this.pluginTargetSelector.setBackground(Color.WHITE);
        this.soloImageCheckBox = new JCheckBox();
        this.soloImageCheckBox.addActionListener(this);
        this.showImageModeSelector = new JComboBox();
        this.showImageModeSelector.setEditable(false);
        this.showImageModeSelector.addActionListener(this);
        this.showImageModeSelector.setBackground(Color.WHITE);
        Vector<String> imageModes = new Vector<String>();
        imageModes.add("opacity");
        imageModes.add("none");
        imageModes.add("scale");
        imageModes.add("rotate");
        imageModes.add("curtain");
        imageModes.add("riser");
        imageModes.add("opacity scale");
        imageModes.add("rotate scale");
        imageModes.add("opacity rotate");
        imageModes.add("opacity rotate scale");
        this.showImageModeSelector.setModel(new DefaultComboBoxModel(imageModes));
        Vector<String> fills = new Vector<String>();
        fills.add("fill-y");
        fills.add("fill-x");
        this.fillOptions = new JComboBox();
        this.fillOptions.setModel(new DefaultComboBoxModel(fills));
        this.fillOptions.addActionListener(this);
        this.fillOptions.setBackground(Color.WHITE);
        this.fillOptions.setEditable(false);
        this.zIndexField = new JTextField("0");
        this.zIndexField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MidiControlRuleEditor.this.actionValueField.setText(MidiControlRuleEditor.this.selectFileField.getSelectedItem().toString() + "," + MidiControlRuleEditor.this.getImageEffects());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MidiControlRuleEditor.this.actionValueField.setText(MidiControlRuleEditor.this.selectFileField.getSelectedItem().toString() + "," + MidiControlRuleEditor.this.getImageEffects());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MidiControlRuleEditor.this.actionValueField.setText(MidiControlRuleEditor.this.selectFileField.getSelectedItem().toString() + "," + MidiControlRuleEditor.this.getImageEffects());
            }
        });
        this.imageOptionsPanel = new JPanel(new GridLayout(4, 2));
        this.imageOptionsPanel.add(new JLabel("Image Effect (by value)"));
        this.imageOptionsPanel.add(this.showImageModeSelector);
        this.imageOptionsPanel.add(new JLabel("Image Stretch"));
        this.imageOptionsPanel.add(this.fillOptions);
        this.imageOptionsPanel.add(new JLabel("Solo (clear canvas first)"));
        this.imageOptionsPanel.add(this.soloImageCheckBox);
        this.imageOptionsPanel.add(new JLabel("Layer number (zIndex)"));
        this.imageOptionsPanel.add(this.zIndexField);
        this.selectRuleGroupDropdown = new JComboBox();
        this.selectRuleGroupDropdown.setEditable(true);
        this.selectRuleGroupDropdown.addActionListener(this);
        this.selectRuleGroupDropdown.setBackground(Color.WHITE);
        this.nicknameField = new JTextField("");
        this.ruleGroupField = new JComboBox();
        this.ruleGroupField.setEditable(true);
        this.ruleGroupField.setModel(this.getRuleGroupModel());
        this.ruleGroupField.setBackground(Color.WHITE);
        this.ruleGroupField.setToolTipText("Assign this rule to a named group");
        this.canvasSelectorField = new JComboBox();
        this.canvasSelectorField.setEditable(true);
        this.canvasSelectorField.setModel(this.getCanvasSelectorModel());
        this.canvasSelectorField.setBackground(Color.WHITE);
        this.canvasSelectorField.setToolTipText("Select the Canvas to display this media, select (NONE) for local or enter a name like \"Main Display\" (Canvases are created dynamically)");
        this.actionValueField = new JTextArea("");
        this.actionValueField.setLineWrap(true);
        this.actionValueField.setBorder(new EtchedBorder());
        this.actionValueField.setBackground(Color.WHITE);
        this.selectFilePanel = new JPanel(new BorderLayout());
        this.selectFilePanel.setBorder(new EtchedBorder());
        this.selectFileField = new JComboBox();
        this.selectFileField.setEditable(true);
        this.selectFileField.addActionListener(this);
        this.selectFileField.setSelectedItem(this.actionValueField.getText());
        this.selectFileField.setToolTipText("Select a file from the project's assets");
        this.selectFileButton = new JButton("...");
        this.selectFileButton.addActionListener(this);
        this.selectFilePanel.add(this.selectFileField, "Center");
        this.selectFilePanel.add((Component)this.selectFileButton, "East");
        this.transmitMidiPanel = new JPanel(new GridBagLayout());
        this.deviceSelectAVF = new JComboBox();
        this.deviceSelectAVF.addActionListener(this);
        Vector<String> midiChannels = new Vector<String>();
        for (int i = 1; i < 17; ++i) {
            midiChannels.add(String.valueOf(i));
        }
        DocumentListener xmitDL = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                MidiControlRuleEditor.this.actionValueField.setText(String.valueOf(MidiControlRuleEditor.this.deviceSelectAVF.getSelectedItem()) + "," + String.valueOf(MidiControlRuleEditor.this.channelSelectAVF.getSelectedItem()) + "," + MidiControlRuleEditor.this.ccAVF.getText() + "," + MidiControlRuleEditor.this.valueAVF.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MidiControlRuleEditor.this.actionValueField.setText(String.valueOf(MidiControlRuleEditor.this.deviceSelectAVF.getSelectedItem()) + "," + String.valueOf(MidiControlRuleEditor.this.channelSelectAVF.getSelectedItem()) + "," + MidiControlRuleEditor.this.ccAVF.getText() + "," + MidiControlRuleEditor.this.valueAVF.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                MidiControlRuleEditor.this.actionValueField.setText(String.valueOf(MidiControlRuleEditor.this.deviceSelectAVF.getSelectedItem()) + "," + String.valueOf(MidiControlRuleEditor.this.channelSelectAVF.getSelectedItem()) + "," + MidiControlRuleEditor.this.ccAVF.getText() + "," + MidiControlRuleEditor.this.valueAVF.getText());
            }
        };
        this.channelSelectAVF = new JComboBox(midiChannels);
        this.channelSelectAVF.addActionListener(this);
        this.ccAVF = new JTextField("{{cc}}");
        this.ccAVF.getDocument().addDocumentListener(xmitDL);
        this.valueAVF = new JTextField("{{value}}");
        this.valueAVF.getDocument().addDocumentListener(xmitDL);
        this.transmitMidiPanel.add((Component)new JLabel("Device", 2), this.gbc(1, 1, 0.4));
        this.transmitMidiPanel.add(this.deviceSelectAVF, this.gbc(2, 1, 0.6));
        this.transmitMidiPanel.add((Component)new JLabel("Channel", 2), this.gbc(1, 2, 0.4));
        this.transmitMidiPanel.add(this.channelSelectAVF, this.gbc(2, 2, 0.6));
        this.ccLabel = new JLabel("CC", 2);
        this.transmitMidiPanel.add((Component)this.ccLabel, this.gbc(1, 3, 0.4));
        this.transmitMidiPanel.add((Component)this.ccAVF, this.gbc(2, 3, 0.6));
        this.transmitMidiPanel.add((Component)new JLabel("Value/Velocity", 2), this.gbc(1, 4, 0.4));
        this.transmitMidiPanel.add((Component)this.valueAVF, this.gbc(2, 4, 0.6));
        this.modifierPanel = new JPanel(new GridLayout(2, 1));
        this.valueInvertedCheckBox = new JCheckBox("Value Inverted");
        this.valueInvertedCheckBox.setSelected(this.rule.isValueInverted());
        this.valueInvertedCheckBox.setToolTipText("Invert the received value from 0-127 to 127-0");
        this.modifierPanel.add(this.valueInvertedCheckBox);
        this.valueSettledCheckBox = new JCheckBox("Value Settled");
        this.valueSettledCheckBox.setSelected(this.rule.shouldValueSettle());
        this.valueSettledCheckBox.setToolTipText("Dont fire the rule until the value stops changing");
        this.modifierPanel.add(this.valueSettledCheckBox);
        this.actionValuePanel = new JPanel(new BorderLayout());
        JPanel formPanel = new JPanel(new GridBagLayout());
        formPanel.add((Component)new JLabel("Rule Name", 2), this.gbc(1, 1, 0.4));
        formPanel.add((Component)this.nicknameField, this.gbc(2, 1, 0.6));
        formPanel.add((Component)new JLabel("Rule Group", 2), this.gbc(1, 2, 0.4));
        formPanel.add(this.ruleGroupField, this.gbc(2, 2, 0.6));
        formPanel.add((Component)new JLabel("Select Control", 2), this.gbc(1, 3, 0.4));
        formPanel.add(this.controlSelector, this.gbc(2, 3, 0.6));
        formPanel.add((Component)new JLabel("Modifiers", 2), this.gbc(1, 4, 0.4));
        formPanel.add((Component)this.modifierPanel, this.gbc(2, 4, 0.6));
        formPanel.add((Component)new JLabel("Select Event", 2), this.gbc(1, 5, 0.4));
        formPanel.add(this.eventSelector, this.gbc(2, 5, 0.6));
        formPanel.add((Component)new JLabel("Action Type", 2), this.gbc(1, 6, 0.4));
        formPanel.add(this.actionSelector, this.gbc(2, 6, 0.6));
        formPanel.add((Component)new JLabel("Target Canvas", 2), this.gbc(1, 7, 0.4));
        formPanel.add(this.canvasSelectorField, this.gbc(2, 7, 0.6));
        this.actionValueLabel = new JLabel("Action Value", 2);
        formPanel.add((Component)this.actionValueLabel, this.gbc(1, 8, 0.4));
        formPanel.add((Component)this.actionValuePanel, this.gbc(2, 8, 0.6));
        if (newRule) {
            this.saveButton = new JButton("Create Rule");
            this.deleteButton = new JButton("Cancel");
        } else {
            this.saveButton = new JButton("Save Rule");
            this.deleteButton = new JButton("Delete Rule");
        }
        this.saveButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.add(this.deleteButton);
        buttonPanel.add(this.saveButton);
        formPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)formPanel, "First");
        this.add((Component)buttonPanel, "Last");
        this.eventSelector.setSelectedIndex(this.rule.getEventMode());
        this.controlSelector.setSelectedIndex(MidiTools.getIndexForMidiControl(this.rule.getMidiControl()));
        if (this.rule.getNickname() != null) {
            this.nicknameField.setText(this.rule.getNickname());
        }
        if (this.rule.getRuleGroup() != null) {
            this.ruleGroupField.setSelectedItem(this.rule.getRuleGroup());
        }
        if (this.rule.getActionValue() != null) {
            this.actionValueField.setText(this.rule.getActionValue());
        }
        if (this.rule.getCanvasName() != null) {
            this.canvasSelectorField.setSelectedItem(this.rule.getCanvasName());
        } else {
            this.canvasSelectorField.setSelectedItem("");
        }
        int avi = this.rule.getActionType();
        this.actionSelector.setSelectedItem(avi);
        this.changeActionSelector(avi);
        this.centerWindow();
    }

    private GridBagConstraints gbc(int x, int y, double weightx) {
        GridBagConstraints g = new GridBagConstraints();
        g.fill = 2;
        g.weightx = weightx;
        g.gridx = x;
        g.gridy = y;
        g.ipady = 2;
        g.ipadx = 5;
        return g;
    }

    public void refreshDevices() {
        try {
            DefaultComboBoxModel<String> deviceModel = new DefaultComboBoxModel<String>();
            for (MidiPort p : MidiPortManager.getReceivingPorts()) {
                deviceModel.addElement(p.getName());
            }
            this.deviceSelectAVF.setModel(deviceModel);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public DefaultComboBoxModel<String> getRuleGroupModel() {
        try {
            Vector<String> ruleGroups = new Vector<String>();
            Enumeration<MidiControlRule> newRuleEnum = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
            while (newRuleEnum.hasMoreElements()) {
                MidiControlRule mcr = newRuleEnum.nextElement();
                String groupName = mcr.getRuleGroup();
                if (ruleGroups.contains(groupName)) continue;
                ruleGroups.add(groupName);
            }
            DefaultComboBoxModel<String> ruleGroupModel = new DefaultComboBoxModel<String>(ruleGroups);
            return ruleGroupModel;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public DefaultComboBoxModel<String> getCanvasSelectorModel() {
        try {
            DefaultComboBoxModel<String> canvasGroupModel = new DefaultComboBoxModel<String>(MidiTools.getCanvasNames());
            return canvasGroupModel;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public DefaultComboBoxModel<String> getPluginModel() {
        try {
            Vector<String> plugins = new Vector<String>();
            for (MidiToolsPlugin plugin : MidiTools.instance.plugins.values()) {
                Collection<String> rule_targets = plugin.getRuleTargets();
                if (rule_targets == null || rule_targets.size() <= 0) continue;
                plugins.add(plugin.getTitle());
            }
            DefaultComboBoxModel<String> pluginModel = new DefaultComboBoxModel<String>(plugins);
            return pluginModel;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return null;
        }
    }

    public DefaultComboBoxModel<String> getPluginTargetModel(MidiToolsPlugin mtp) {
        try {
            Vector<String> pluginTargets = new Vector<String>(mtp.getRuleTargets());
            DefaultComboBoxModel<String> pluginModel = new DefaultComboBoxModel<String>(pluginTargets);
            return pluginModel;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            Vector<String> pluginTargets = new Vector<String>();
            pluginTargets.add("");
            DefaultComboBoxModel<String> pluginModel = new DefaultComboBoxModel<String>(pluginTargets);
            return pluginModel;
        }
    }

    public JPanel labelComponent(String label, Component c) {
        JPanel x = new JPanel(new GridLayout(1, 2));
        x.add(new JLabel(label, 0));
        x.add(c);
        return x;
    }

    public void centerWindow() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        float WIDTH = screenSize.width;
        float HEIGHT = screenSize.height;
        int wWidth = 400;
        int wHeight = 450;
        int x = (int)(WIDTH / 2.0f - (float)wWidth / 2.0f);
        int y = (int)(HEIGHT / 2.0f - (float)wHeight / 2.0f);
        this.setBounds(x, y, wWidth, wHeight);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setVisible(true);
    }
}

