/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstatic.MidiControlRule;
import org.openstatic.MidiControlRuleCellRenderer;
import org.openstatic.MidiControlRuleEditor;
import org.openstatic.MidiTools;

public class MidiControlRulePanel
extends JPanel
implements ActionListener {
    protected DefaultListModel<MidiControlRule> rules;
    protected MidiControlRuleCellRenderer midiControlRuleCellRenderer;
    private JList<MidiControlRule> rulesList;
    private long lastRuleClick;
    private JPanel buttonPanel;
    private JButton createRuleButton;
    private JButton selectAllButton;
    private JButton disableAllButton;
    private JButton enableAllButton;
    private JButton deleteButton;
    private JButton labelButton;
    private DropTarget drop_targ = new DropTarget(){

        @Override
        public synchronized void drop(DropTargetDropEvent evt) {
            try {
                evt.acceptDrop(1);
                List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                if (droppedFiles.size() == 1) {
                    try {
                        File droppedFile = (File)droppedFiles.get(0);
                        Thread t = new Thread(() -> MidiControlRulePanel.this.handleFileDrop(droppedFile));
                        t.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                } else {
                    int i = 0;
                    while (i < droppedFiles.size()) {
                        int fi = i++;
                        Thread t = new Thread(() -> MidiControlRulePanel.this.handleFileDrop((File)droppedFiles.get(fi)));
                        t.start();
                    }
                }
                System.err.println("Cleanly LEFT DROP Routine");
                evt.dropComplete(true);
            }
            catch (Exception ex) {
                evt.dropComplete(true);
                System.err.println("Exception During DROP Routine");
                ex.printStackTrace();
            }
        }
    };

    public MidiControlRulePanel() {
        super(new BorderLayout());
        this.rules = new DefaultListModel();
        this.midiControlRuleCellRenderer = new MidiControlRuleCellRenderer();
        this.rulesList = new JList<MidiControlRule>(this.rules);
        this.rulesList.setOpaque(true);
        this.rulesList.setBackground(Color.WHITE);
        this.rulesList.setDropTarget(this.drop_targ);
        this.rulesList.setSelectionMode(2);
        this.rulesList.setCellRenderer(this.midiControlRuleCellRenderer);
        JScrollPane ruleScrollPane = new JScrollPane(this.rulesList, 22, 31);
        this.rulesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = MidiControlRulePanel.this.rulesList.locationToIndex(e.getPoint());
                if (index != -1) {
                    MidiControlRule source = MidiControlRulePanel.this.rules.getElementAt(index);
                    if (e.getButton() == 1) {
                        long cms = System.currentTimeMillis();
                        if (cms - MidiControlRulePanel.this.lastRuleClick < 500L && MidiControlRulePanel.this.lastRuleClick > 0L) {
                            source.toggleEnabled();
                        }
                        MidiControlRulePanel.this.lastRuleClick = cms;
                    } else if (e.getButton() == 2 || e.getButton() == 3) {
                        MidiControlRuleEditor midiControlRuleEditor = new MidiControlRuleEditor(source);
                    }
                }
            }
        });
        this.add((Component)ruleScrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        try {
            ImageIcon scriptIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/script32.png")));
            this.createRuleButton = new JButton(scriptIcon);
            this.createRuleButton.addActionListener(this);
            this.createRuleButton.setActionCommand("create_rule");
            this.createRuleButton.setToolTipText("Create a new rule");
            ImageIcon labelIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/label32.png")));
            this.labelButton = new JButton(labelIcon);
            this.labelButton.addActionListener(this);
            this.labelButton.setActionCommand("edit_rules");
            this.labelButton.setToolTipText("Edit selected Rules");
            ImageIcon selectAllIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/selectall32.png")));
            this.selectAllButton = new JButton(selectAllIcon);
            this.selectAllButton.addActionListener(this);
            this.selectAllButton.setActionCommand("select_all");
            this.selectAllButton.setToolTipText("Select All");
            ImageIcon disableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/disable32.png")));
            this.disableAllButton = new JButton(disableIcon);
            this.disableAllButton.addActionListener(this);
            this.disableAllButton.setActionCommand("disable_selected");
            this.disableAllButton.setToolTipText("Disable selected Rules");
            ImageIcon enableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/enable32.png")));
            this.enableAllButton = new JButton(enableIcon);
            this.enableAllButton.addActionListener(this);
            this.enableAllButton.setActionCommand("enable_selected");
            this.enableAllButton.setToolTipText("Enable selected Rules");
            ImageIcon trashIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/trash32.png")));
            this.deleteButton = new JButton(trashIcon);
            this.deleteButton.addActionListener(this);
            this.deleteButton.setActionCommand("delete_selected");
            this.deleteButton.setToolTipText("Delete selected Rules");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.buttonPanel.add(this.createRuleButton);
        this.buttonPanel.add(this.labelButton);
        this.buttonPanel.add(this.selectAllButton);
        this.buttonPanel.add(this.disableAllButton);
        this.buttonPanel.add(this.enableAllButton);
        this.buttonPanel.add(this.deleteButton);
        this.add((Component)this.buttonPanel, "West");
    }

    public void handleFileDrop(File file) {
        MidiControlRule newRule;
        System.err.println("File dropped: " + file.toString());
        String filename = file.getName();
        String filenameLower = filename.toLowerCase();
        if (filenameLower.endsWith(".wav")) {
            newRule = new MidiControlRule(null, 1, 2, MidiTools.addProjectAsset(file).getName());
            newRule.setValueSettled(true);
            newRule.setNickname(filename.substring(0, filename.length() - 4));
            if (!this.contains(newRule)) {
                this.addElement(newRule);
            }
        }
        if (filenameLower.endsWith(".exe") || filenameLower.endsWith(".bat") || filenameLower.endsWith(".cmd") || filenameLower.endsWith(".php") || filenameLower.endsWith(".sh")) {
            newRule = new MidiControlRule(null, 0, 1, file.getAbsolutePath() + ",{{value}}");
            newRule.setValueSettled(true);
            newRule.setNickname(filename.substring(0, filename.length() - 4));
            if (!this.contains(newRule)) {
                this.addElement(newRule);
            }
        }
        if (filenameLower.endsWith(".jpg") || filenameLower.endsWith(".gif") || filenameLower.endsWith(".png") || filenameLower.endsWith(".jpeg") || filenameLower.endsWith(".svg") || filenameLower.endsWith(".webp")) {
            newRule = new MidiControlRule(null, 0, 10, MidiTools.addProjectAsset(file).getName());
            newRule.setNickname(filename.substring(0, filename.length() - 4));
            if (!this.contains(newRule)) {
                this.addElement(newRule);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block9: {
            Collection<MidiControlRule> selectedRules;
            String cmd;
            block12: {
                block11: {
                    block10: {
                        block8: {
                            cmd = e.getActionCommand();
                            if (!cmd.equals("create_rule")) break block8;
                            MidiControlRule newRule = new MidiControlRule(null, 0, 0, null);
                            MidiControlRuleEditor midiControlRuleEditor = new MidiControlRuleEditor(newRule, true);
                            break block9;
                        }
                        if (!cmd.equals("enable_selected")) break block10;
                        Collection<MidiControlRule> selectedRules2 = this.getSelectedRules();
                        if (selectedRules2.size() == 0) break block9;
                        for (MidiControlRule rule : selectedRules2) {
                            rule.setEnabled(true);
                        }
                        break block9;
                    }
                    if (!cmd.equals("disable_selected")) break block11;
                    Collection<MidiControlRule> selectedRules3 = this.getSelectedRules();
                    if (selectedRules3.size() == 0) break block9;
                    for (MidiControlRule rule : selectedRules3) {
                        rule.setEnabled(false);
                    }
                    break block9;
                }
                if (!cmd.equals("delete_selected")) break block12;
                Collection<MidiControlRule> selectedRules4 = this.getSelectedRules();
                if (selectedRules4.size() == 0) break block9;
                for (MidiControlRule rule : selectedRules4) {
                    this.removeElement(rule);
                }
                break block9;
            }
            if (cmd.equals("select_all")) {
                int rs = this.rules.size();
                int[] indices = new int[rs];
                for (int i = 0; i < rs; ++i) {
                    indices[i] = i;
                }
                this.rulesList.setSelectedIndices(indices);
            } else if (cmd.equals("edit_rules") && (selectedRules = this.getSelectedRules()).size() != 0) {
                for (MidiControlRule rule : selectedRules) {
                    MidiControlRuleEditor midiControlRuleEditor = new MidiControlRuleEditor(rule);
                }
            }
        }
    }

    public MidiControlRule elementAt(int i) {
        return this.rules.elementAt(i);
    }

    public int indexOf(MidiControlRule rule) {
        return this.rules.indexOf(rule);
    }

    public Enumeration<MidiControlRule> getRulesEnumeration() {
        return this.rules.elements();
    }

    public Collection<MidiControlRule> getSelectedRules() {
        return this.rulesList.getSelectedValuesList();
    }

    public void addElement(MidiControlRule rule) {
        this.rules.addElement(rule);
    }

    public boolean removeElement(MidiControlRule rule) {
        rule.setEnabled(false);
        MidiTools.removeListenerFromControls(rule);
        return this.rules.removeElement(rule);
    }

    public boolean contains(MidiControlRule rule) {
        return this.rules.contains(rule);
    }

    public void clear() {
        Enumeration<MidiControlRule> rulesEnum = this.rules.elements();
        Vector<MidiControlRule> removalVector = new Vector<MidiControlRule>();
        while (rulesEnum.hasMoreElements()) {
            removalVector.add(rulesEnum.nextElement());
        }
        removalVector.forEach(rule -> this.removeElement((MidiControlRule)rule));
    }
}

