/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.openstatic.CreateControlDialog;
import org.openstatic.MidiControlRule;
import org.openstatic.MidiControlRuleEditor;
import org.openstatic.MidiTools;
import org.openstatic.midi.MidiControl;
import org.openstatic.midi.MidiControlCellRenderer;
import org.openstatic.midi.MidiControlListener;

public class MidiControlsPanel
extends JPanel
implements ActionListener,
Receiver {
    protected JList<MidiControl> controlList;
    protected MidiControlCellRenderer midiControlCellRenderer = new MidiControlCellRenderer();
    protected DefaultListModel<MidiControl> controls = new DefaultListModel();
    private JPanel buttonPanel;
    private JToggleButton listenForMidiButton;
    private JButton createControlButton;
    private JButton createRuleButton;
    private JButton deleteButton;
    private JButton labelButton;
    private JButton selectAllButton;

    public MidiControlsPanel() {
        super(new BorderLayout());
        this.controlList = new JList<MidiControl>(this.controls);
        this.controlList.setCellRenderer(this.midiControlCellRenderer);
        this.controlList.setSelectionMode(2);
        this.controlList.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                MidiControl t;
                if (e.getKeyCode() == 127) {
                    MidiControl t2 = MidiControlsPanel.this.controlList.getSelectedValue();
                    if (t2 != null) {
                        new Thread(() -> MidiControlsPanel.this.removeMidiControl(t2)).start();
                    }
                } else if (e.getKeyCode() == 39) {
                    MidiControl t3 = MidiControlsPanel.this.controlList.getSelectedValue();
                    if (t3 != null) {
                        t3.manualAdjust(t3.getValue() + 1);
                    }
                } else if (e.getKeyCode() == 37) {
                    MidiControl t4 = MidiControlsPanel.this.controlList.getSelectedValue();
                    if (t4 != null) {
                        t4.manualAdjust(t4.getValue() - 1);
                    }
                } else if (e.getKeyCode() == 32) {
                    MidiControl t5 = MidiControlsPanel.this.controlList.getSelectedValue();
                    if (t5 != null && t5.getValue() != 127) {
                        t5.manualAdjust(127);
                    }
                } else if (e.getKeyCode() == 10 && (t = MidiControlsPanel.this.controlList.getSelectedValue()) != null) {
                    if (t.getValue() == 127) {
                        t.manualAdjust(0);
                    } else {
                        t.manualAdjust(127);
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                MidiControl t;
                if (e.getKeyCode() == 32 && (t = MidiControlsPanel.this.controlList.getSelectedValue()) != null && t.getValue() != 0) {
                    t.manualAdjust(0);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JScrollPane controlsScrollPane = new JScrollPane(this.controlList, 22, 31);
        this.add((Component)controlsScrollPane, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        try {
            ImageIcon listenIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/listen32.png")));
            this.listenForMidiButton = new JToggleButton(listenIcon);
            this.listenForMidiButton.setToolTipText("Listen to controllers and create controls automatically");
            ImageIcon dialIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/dial32.png")));
            this.createControlButton = new JButton(dialIcon);
            this.createControlButton.setActionCommand("new_control");
            this.createControlButton.addActionListener(this);
            this.createControlButton.setToolTipText("Create new control");
            ImageIcon scriptIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/script32.png")));
            this.createRuleButton = new JButton(scriptIcon);
            this.createRuleButton.addActionListener(this);
            this.createRuleButton.setActionCommand("create_rule");
            this.createRuleButton.setToolTipText("Create rule for selected controls");
            ImageIcon labelIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/label32.png")));
            this.labelButton = new JButton(labelIcon);
            this.labelButton.addActionListener(this);
            this.labelButton.setActionCommand("label_control");
            this.labelButton.setToolTipText("Rename selected controls");
            ImageIcon selectAllIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/selectall32.png")));
            this.selectAllButton = new JButton(selectAllIcon);
            this.selectAllButton.addActionListener(this);
            this.selectAllButton.setActionCommand("select_all");
            this.selectAllButton.setToolTipText("Select All");
            ImageIcon trashIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/trash32.png")));
            this.deleteButton = new JButton(trashIcon);
            this.deleteButton.addActionListener(this);
            this.deleteButton.setActionCommand("delete_control");
            this.deleteButton.setToolTipText("Delete Selected Controls");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.listenForMidiButton.setSelected(false);
        this.buttonPanel.add(this.listenForMidiButton);
        this.buttonPanel.add(this.createControlButton);
        this.buttonPanel.add(this.createRuleButton);
        this.buttonPanel.add(this.labelButton);
        this.buttonPanel.add(this.selectAllButton);
        this.buttonPanel.add(this.deleteButton);
        this.add((Component)this.buttonPanel, "West");
    }

    @Override
    public void send(MidiMessage msg, long timeStamp) {
        if (msg instanceof ShortMessage) {
            ShortMessage sm = (ShortMessage)msg;
            if (sm.getCommand() == 176 || sm.getCommand() == 144 || sm.getCommand() == 128) {
                MidiControl mc;
                boolean should_repaint = false;
                boolean found_control = false;
                Enumeration<MidiControl> mce = this.getControlsEnumeration();
                while (mce.hasMoreElements()) {
                    MidiControl mc2 = mce.nextElement();
                    if (!mc2.messageMatches(sm)) continue;
                    try {
                        mc2.processMessage(sm);
                        found_control = true;
                        should_repaint = true;
                    }
                    catch (Exception e) {
                        MidiTools.instance.midi_logger_b.printException(e);
                    }
                }
                if (!found_control && this.listenForMidiButton.isSelected() && sm.getCommand() == 176) {
                    int channel = sm.getChannel() + 1;
                    int cc = sm.getData1();
                    if (cc != 121 && cc != 123) {
                        mc = new MidiControl(channel, cc);
                        MidiTools.handleNewMidiControl(mc);
                    }
                }
                if (!found_control && this.listenForMidiButton.isSelected() && sm.getCommand() == 144) {
                    int channel = sm.getChannel() + 1;
                    int note = sm.getData1() % 12;
                    mc = new MidiControl(channel, note, true);
                    MidiTools.handleNewMidiControl(mc);
                }
                if (should_repaint) {
                    this.controlList.repaint();
                }
            }
        } else {
            MidiTools.logIt("Unknown non-short message " + msg.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("create_rule")) {
            Collection<MidiControl> selectedControls = this.getSelectedControls();
            if (selectedControls.size() != 0) {
                Iterator<MidiControl> controlIterator = selectedControls.iterator();
                int defaultEventMode = 0;
                int defaultActionType = 0;
                String defaultRuleGroupName = "all";
                String defaultActionValue = null;
                boolean defaultInverted = false;
                boolean defaultSettled = false;
                while (controlIterator.hasNext()) {
                    MidiControl control = controlIterator.next();
                    MidiControlRule newRule = new MidiControlRule(control, defaultEventMode, defaultActionType, defaultActionValue);
                    newRule.setValueInverted(defaultInverted);
                    newRule.setValueSettled(defaultSettled);
                    newRule.setRuleGroup(defaultRuleGroupName);
                    MidiControlRuleEditor editor = new MidiControlRuleEditor(newRule, true);
                    defaultEventMode = newRule.getEventMode();
                    defaultActionType = newRule.getActionType();
                    defaultRuleGroupName = newRule.getRuleGroup();
                    defaultActionValue = newRule.getActionValue();
                    defaultInverted = newRule.isValueInverted();
                    defaultSettled = newRule.shouldValueSettle();
                }
                this.repaint();
            }
        } else if (cmd.equals("label_control")) {
            Collection<MidiControl> selectedControls = this.getSelectedControls();
            if (selectedControls.size() != 0) {
                for (MidiControl control : selectedControls) {
                    String s = JOptionPane.showInputDialog(this, "Rename Control " + control.toString(), control.getNickname());
                    control.setNickname(s);
                }
                this.repaint();
            }
        } else if (cmd.equals("delete_control")) {
            Collection<MidiControl> selectedControls = this.getSelectedControls();
            if (selectedControls.size() != 0) {
                for (MidiControl control : selectedControls) {
                    this.removeMidiControl(control);
                }
                this.repaint();
            }
        } else if (cmd.equals("new_control")) {
            CreateControlDialog selectedControls = new CreateControlDialog();
        } else if (cmd.equals("select_all")) {
            int rs = this.controls.size();
            int[] indices = new int[rs];
            for (int i = 0; i < rs; ++i) {
                indices[i] = i;
            }
            this.controlList.setSelectedIndices(indices);
        }
    }

    public MidiControl elementAt(int i) {
        return this.controls.elementAt(i);
    }

    public int indexOf(MidiControl control) {
        return this.controls.indexOf(control);
    }

    public void removeListenerFromControls(MidiControlListener mcl) {
        Enumeration<MidiControl> mce = this.controls.elements();
        while (mce.hasMoreElements()) {
            MidiControl mc = mce.nextElement();
            mc.removeMidiControlListener(mcl);
        }
    }

    public Collection<MidiControl> getSelectedControls() {
        return this.controlList.getSelectedValuesList();
    }

    public Enumeration<MidiControl> getControlsEnumeration() {
        return this.controls.elements();
    }

    public void insertElementAt(MidiControl control, int index) {
        this.controls.insertElementAt(control, index);
    }

    public void removeMidiControl(MidiControl mc) {
        MidiTools.logIt("Removed Midi Control: " + mc.getNickname());
        try {
            mc.removeAllListeners();
            this.controls.removeElement(mc);
            Enumeration<MidiControlRule> re = MidiTools.instance.midiControlRulePanel.getRulesEnumeration();
            while (re.hasMoreElements()) {
                MidiControlRule rule = re.nextElement();
                if (rule.getMidiControl() != mc) continue;
                rule.setMidiControl(null);
            }
            MidiTools.repaintControls();
        }
        catch (Exception e) {
            MidiTools.instance.midi_logger_b.printException(e);
        }
    }

    public void clear() {
        Enumeration<MidiControl> controlsEnum = this.controls.elements();
        Vector<MidiControl> removalVector = new Vector<MidiControl>();
        while (controlsEnum.hasMoreElements()) {
            removalVector.add(controlsEnum.nextElement());
        }
        removalVector.forEach(control -> this.removeMidiControl((MidiControl)control));
    }

    @Override
    public void close() {
    }
}

