/*
 * Decompiled with CFR 0.152.
 */
package org.openstatic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.json.JSONObject;
import org.openstatic.midi.RandomizerListModel;
import org.openstatic.midi.RandomizerRuleCellRenderer;
import org.openstatic.midi.ports.MidiRandomizerPort;
import org.openstatic.util.JSONObjectDialog;

public class RandomizerControlBox
extends JPanel
implements ActionListener {
    private JList<JSONObject> randomizerRuleList;
    private RandomizerRuleCellRenderer randomizerRuleCellRenderer;
    private long lastMappingClick;
    private JPanel buttonPanel;
    private JButton createRuleButton;
    private MidiRandomizerPort randomizerPort;
    private JButton selectAllButton;
    private JButton disableAllButton;
    private JButton enableAllButton;
    private JButton deleteButton;

    public RandomizerControlBox(MidiRandomizerPort randomizerPort) {
        super(new BorderLayout());
        this.randomizerPort = randomizerPort;
        this.randomizerRuleCellRenderer = new RandomizerRuleCellRenderer();
        this.randomizerRuleList = new JList<JSONObject>(new RandomizerListModel(this.randomizerPort));
        this.randomizerRuleList.setOpaque(true);
        this.randomizerRuleList.setSelectionMode(2);
        this.randomizerRuleList.setCellRenderer(this.randomizerRuleCellRenderer);
        this.randomizerRuleList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int index = RandomizerControlBox.this.randomizerRuleList.locationToIndex(e.getPoint());
                if (index != -1) {
                    JSONObject rule = RandomizerControlBox.this.randomizerRuleList.getModel().getElementAt(index);
                    if (e.getButton() == 1) {
                        long cms = System.currentTimeMillis();
                        if (cms - RandomizerControlBox.this.lastMappingClick < 500L && RandomizerControlBox.this.lastMappingClick > 0L) {
                            RandomizerControlBox.this.randomizerPort.toggleRandomRule(index);
                        }
                        RandomizerControlBox.this.lastMappingClick = cms;
                    }
                    RandomizerControlBox.this.repaint();
                }
            }
        });
        JScrollPane mappingScrollPane = new JScrollPane(this.randomizerRuleList, 22, 31);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        try {
            ImageIcon diceIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/dice32.png")));
            this.createRuleButton = new JButton(diceIcon);
            this.createRuleButton.setActionCommand("create");
            this.createRuleButton.setToolTipText("Create a new rule for the Randomizer Device");
            this.createRuleButton.addActionListener(this);
            this.buttonPanel.add(this.createRuleButton);
            ImageIcon selectAllIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/selectall32.png")));
            this.selectAllButton = new JButton(selectAllIcon);
            this.selectAllButton.addActionListener(this);
            this.selectAllButton.setActionCommand("select_all");
            this.selectAllButton.setToolTipText("Select All");
            this.buttonPanel.add(this.selectAllButton);
            ImageIcon disableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/disable32.png")));
            this.disableAllButton = new JButton(disableIcon);
            this.disableAllButton.addActionListener(this);
            this.disableAllButton.setActionCommand("disable_selected");
            this.disableAllButton.setToolTipText("Disable selected randomizer rules");
            this.buttonPanel.add(this.disableAllButton);
            ImageIcon enableIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/enable32.png")));
            this.enableAllButton = new JButton(enableIcon);
            this.enableAllButton.addActionListener(this);
            this.enableAllButton.setActionCommand("enable_selected");
            this.enableAllButton.setToolTipText("Enable selected randomizer rules");
            this.buttonPanel.add(this.enableAllButton);
            ImageIcon trashIcon = new ImageIcon(ImageIO.read(this.getClass().getResourceAsStream("/midi-tools-res/trash32.png")));
            this.deleteButton = new JButton(trashIcon);
            this.deleteButton.addActionListener(this);
            this.deleteButton.setActionCommand("delete_selected");
            this.deleteButton.setToolTipText("Delete Selected randomizer rules");
            this.buttonPanel.add(this.deleteButton);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        this.add((Component)mappingScrollPane, "Center");
        this.add((Component)this.buttonPanel, "West");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.createRuleButton) {
            JSONObject newRule = MidiRandomizerPort.defaultRuleJSONObject();
            JSONObjectDialog jod = new JSONObjectDialog("New Randomizer Rule", newRule);
            JSONObject returnRule = jod.getJSONObject();
            if (returnRule != null) {
                this.randomizerPort.addRandomRule(returnRule);
            } else {
                System.err.println("Return rule was null");
            }
        } else if (e.getSource() == this.enableAllButton) {
            Collection<JSONObject> selectedMappings = this.getSelectedRules();
            if (selectedMappings.size() != 0) {
                for (JSONObject rule : selectedMappings) {
                    rule.put("enabled", true);
                }
                this.repaint();
            }
        } else if (e.getSource() == this.disableAllButton) {
            Collection<JSONObject> selectedRules = this.getSelectedRules();
            if (selectedRules.size() != 0) {
                for (JSONObject rule : selectedRules) {
                    rule.put("enabled", false);
                }
                this.repaint();
            }
        } else if (e.getSource() == this.deleteButton) {
            Collection<JSONObject> selectedRules = this.getSelectedRules();
            if (selectedRules.size() != 0) {
                for (JSONObject rule : selectedRules) {
                    this.randomizerPort.removeRandomRule(rule);
                }
                this.repaint();
            }
        } else if (e.getSource() == this.selectAllButton) {
            int rs = this.randomizerPort.getAllRules().length();
            int[] indices = new int[rs];
            for (int i = 0; i < rs; ++i) {
                indices[i] = i;
            }
            this.randomizerRuleList.setSelectedIndices(indices);
        }
    }

    public Collection<JSONObject> getSelectedRules() {
        return this.randomizerRuleList.getSelectedValuesList();
    }
}

